/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.ListResult;
import de.jstacs.results.ResultSet;
import java.io.BufferedReader;
import java.io.FileReader;
import projects.dimont.Interpolation;

public class EvaluateDCM
extends EvaluateSingleDataSetSlimDimontHOSingleCl {
    public static void main(String[] args) throws Exception {
        String base = args[0];
        String prefix = args[2];
        String infix = "";
        if (args.length > 4) {
            infix = "_" + args[4];
        }
        DNADataSet top = new DNADataSet(String.valueOf(base) + "_top" + infix + ".fa");
        DNADataSet shuffled = new DNADataSet(String.valueOf(base) + "_shuffled" + infix + ".fa");
        DataSet sampled = new DNADataSet(args[3]);
        sampled = EvaluateDCM.subSample(sampled, top.getNumberOfElements() * 10);
        DNADataSet all = new DNADataSet(String.valueOf(base) + (infix.length() > 0 ? "_part" + infix : "") + ".fa", '>', new SplitSequenceAnnotationParser(":", ";"));
        double[] allstat = new double[all.getNumberOfElements()];
        int i = 0;
        while (i < all.getNumberOfElements()) {
            allstat[i] = Double.parseDouble(all.getElementAt(i).getSequenceAnnotationByType("signal", 0).getIdentifier());
            ++i;
        }
        double[] allw = Interpolation.getWeight(all, allstat, 0.2, Interpolation.RANK_LOG);
        double[] nallw = Interpolation.getBgWeight(allw);
        DNAAlphabet alp = DNAAlphabet.SINGLETON;
        BufferedReader reader = new BufferedReader(new FileReader(args[1]));
        String str = "";
        double[][][] matrix = null;
        while ((str = reader.readLine()) != null) {
            if (!str.matches("^" + prefix + "[ACGT][ACGT]\\|.*")) continue;
            String sym1 = str.substring(prefix.length() + 0, prefix.length() + 1);
            String sym2 = str.substring(prefix.length() + 1, prefix.length() + 2);
            String[] parts = str.substring(prefix.length() + 3).split(" ");
            if (matrix == null) {
                matrix = new double[parts.length][4][4];
            }
            int i2 = 0;
            while (i2 < parts.length) {
                matrix[i2][((DiscreteAlphabet)alp).getCode((String)sym1)][((DiscreteAlphabet)alp).getCode((String)sym2)] = Double.parseDouble(parts[i2]);
                ++i2;
            }
        }
        reader.close();
        double[] sc = EvaluateDCM.getMaxScores(all, matrix);
        double[] topAr = EvaluateDCM.getMaxScores(top, matrix);
        double[] shufAr = EvaluateDCM.getMaxScores(shuffled, matrix);
        double[] sampAr = EvaluateDCM.getMaxScores(sampled, matrix);
        ResultSet res = EvaluateDCM.getResult(-1, -1, topAr, shufAr, sampAr, sc, Double.NaN, allstat, allw, nallw);
        System.out.println(new ListResult("", "", null, res));
    }

    private static double[] getMaxScores(DataSet data, double[][][] matrix) throws Exception {
        double[] scs = new double[data.getNumberOfElements()];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            double sc;
            double max = Double.NEGATIVE_INFINITY;
            Sequence seq = data.getElementAt(i);
            int j = 0;
            while (j < seq.getLength() - matrix.length) {
                sc = EvaluateDCM.getScore(matrix, seq, j);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            seq = seq.reverseComplement();
            j = 0;
            while (j < seq.getLength() - matrix.length) {
                sc = EvaluateDCM.getScore(matrix, seq, j);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            scs[i] = max;
            ++i;
        }
        return scs;
    }

    private static double getScore(double[][][] matrix, Sequence seq, int start) {
        double score = 0.0;
        int i = 0;
        while (i < matrix.length) {
            score += matrix[i][seq.discreteVal(start + i)][seq.discreteVal(start + i + 1)];
            ++i;
        }
        return score;
    }

    private static void print(double[][][] matrix) {
        DNAAlphabet alp = DNAAlphabet.SINGLETON;
        int i = 0;
        while ((double)i < alp.length()) {
            int j = 0;
            while ((double)j < alp.length()) {
                System.err.print(String.valueOf(alp.getSymbolAt(i)) + alp.getSymbolAt(j) + "|");
                int l = 0;
                while (l < matrix.length) {
                    System.err.print(" " + matrix[l][i][j]);
                    ++l;
                }
                System.err.println();
                ++j;
            }
            ++i;
        }
    }
}

