/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.ListResult;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.Normalisation;
import java.io.BufferedReader;
import java.io.FileReader;
import projects.dimont.Interpolation;

public class EvaluateMEME
extends EvaluateSingleDataSetSlimDimontHOSingleCl {
    public static void main(String[] args) throws Exception {
        double[] sc;
        boolean max = true;
        String base = args[0];
        String infix = "";
        boolean logOdds = true;
        if (args.length > 3) {
            logOdds = Boolean.parseBoolean(args[3]);
        }
        if (args.length > 4) {
            infix = "_" + args[4];
        }
        DNADataSet top = new DNADataSet(String.valueOf(base) + "_top" + infix + ".fa");
        DNADataSet shuffled = new DNADataSet(String.valueOf(base) + "_shuffled" + infix + ".fa");
        DataSet sampled = new DNADataSet(args[2]);
        sampled = EvaluateMEME.subSample(sampled, top.getNumberOfElements() * 10);
        DNADataSet all = new DNADataSet(String.valueOf(base) + (infix.length() > 0 ? "_part" + infix : "") + ".fa", '>', new SplitSequenceAnnotationParser(":", ";"));
        double[] allstat = new double[all.getNumberOfElements()];
        int i = 0;
        while (i < all.getNumberOfElements()) {
            allstat[i] = Double.parseDouble(all.getElementAt(i).getSequenceAnnotationByType("signal", 0).getIdentifier());
            ++i;
        }
        double[] allw = Interpolation.getWeight(all, allstat, 0.2, Interpolation.RANK_LOG);
        double[] nallw = Interpolation.getBgWeight(allw);
        DNAAlphabet alp = DNAAlphabet.SINGLETON;
        BufferedReader reader = new BufferedReader(new FileReader(args[1]));
        String str = "";
        double[][] matrix = null;
        int i2 = 0;
        while ((str = reader.readLine()) != null) {
            int j;
            int len;
            String[] parts;
            if (logOdds) {
                if (str.matches("log\\-odds matrix.*")) {
                    parts = str.split(" ");
                    len = Integer.parseInt(parts[5]);
                    matrix = new double[len][4];
                    i2 = 0;
                    continue;
                }
                if (matrix != null && i2 < matrix.length) {
                    str = str.trim();
                    parts = str.split("\\s+");
                    j = 0;
                    while (j < parts.length) {
                        matrix[i2][j] = Double.parseDouble(parts[j]);
                        ++j;
                    }
                    ++i2;
                    continue;
                }
                if (matrix == null || i2 != matrix.length) continue;
                break;
            }
            if (str.matches("letter\\-probability matrix.*")) {
                parts = str.split(" ");
                len = Integer.parseInt(parts[5]);
                matrix = new double[len][4];
                i2 = 0;
                continue;
            }
            if (matrix != null && i2 < matrix.length) {
                str = str.trim();
                parts = str.split("\\s+");
                j = 0;
                while (j < parts.length) {
                    matrix[i2][j] = Math.log(Double.parseDouble(parts[j]) + 1.0E-6);
                    ++j;
                }
                ++i2;
                continue;
            }
            if (matrix != null && i2 == matrix.length) break;
        }
        reader.close();
        if (max) {
            sc = EvaluateMEME.getMaxScores(all, matrix);
            double[] topAr = EvaluateMEME.getMaxScores(top, matrix);
            double[] shufAr = EvaluateMEME.getMaxScores(shuffled, matrix);
            double[] sampAr = EvaluateMEME.getMaxScores(sampled, matrix);
            ResultSet res = EvaluateMEME.getResult(-1, -1, topAr, shufAr, sampAr, sc, Double.NaN, allstat, allw, nallw);
            System.out.println(new ListResult("", "", null, res));
        } else {
            sc = EvaluateMEME.getMeanScores(all, matrix);
            double[] topAr = EvaluateMEME.getMeanScores(top, matrix);
            double[] shufAr = EvaluateMEME.getMeanScores(shuffled, matrix);
            double[] sampAr = EvaluateMEME.getMeanScores(sampled, matrix);
            ResultSet res = EvaluateMEME.getResult(-1, -1, topAr, shufAr, sampAr, sc, Double.NaN, allstat, allw, nallw);
            System.out.println(new ListResult("", "", null, res));
        }
    }

    private static double[] getMeanScores(DataSet data, double[][] pwm) throws Exception {
        double[] scs = new double[data.getNumberOfElements()];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            double[] sc = new double[seq.getLength() - pwm.length + 1];
            int j = 0;
            while (j < seq.getLength() - pwm.length + 1) {
                sc[j] = EvaluateMEME.getScore(pwm, seq, j);
                ++j;
            }
            double fwd = Normalisation.getLogSum(sc);
            seq = seq.reverseComplement();
            int j2 = 0;
            while (j2 < seq.getLength() - pwm.length + 1) {
                sc[j2] = EvaluateMEME.getScore(pwm, seq, j2);
                ++j2;
            }
            double rc = Normalisation.getLogSum(sc);
            scs[i] = Normalisation.getLogSum(fwd, rc);
            ++i;
        }
        return scs;
    }

    private static double[] getMaxScores(DataSet data, double[][] pwm) throws Exception {
        double[] scs = new double[data.getNumberOfElements()];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            double sc;
            double max = Double.NEGATIVE_INFINITY;
            Sequence seq = data.getElementAt(i);
            int j = 0;
            while (j < seq.getLength() - pwm.length + 1) {
                sc = EvaluateMEME.getScore(pwm, seq, j);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            seq = seq.reverseComplement();
            j = 0;
            while (j < seq.getLength() - pwm.length + 1) {
                sc = EvaluateMEME.getScore(pwm, seq, j);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            scs[i] = max;
            ++i;
        }
        return scs;
    }

    private static double getScore(double[][] pwm, Sequence seq, int start) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += pwm[i][seq.discreteVal(start + i)];
            ++i;
        }
        return score;
    }

    private static void print(double[][] pwm) {
        DNAAlphabet alp = DNAAlphabet.SINGLETON;
        int i = 0;
        while (i < pwm.length) {
            int j = 0;
            while ((double)j < alp.length()) {
                System.out.print(" " + pwm[i][j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

