/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasureParameterSet;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.SimpleResult;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.LinkedList;
import projects.dimont.Interpolation;
import projects.dimont.ThresholdedStrandChIPper;

public class EvaluateSingleDataSetSlimDimontHOSingleCl {
    public static void main(String[] args) throws Exception {
        String base = args[0];
        String classif = args[1];
        DNADataSet top = new DNADataSet(String.valueOf(base) + "_top.fa");
        DNADataSet shuffled = new DNADataSet(String.valueOf(base) + "_shuffled.fa");
        DataSet sampled = new DNADataSet(args[2]);
        sampled = EvaluateSingleDataSetSlimDimontHOSingleCl.subSample(sampled, top.getNumberOfElements() * 10);
        DNADataSet all = new DNADataSet(String.valueOf(base) + ".fa", '>', new SplitSequenceAnnotationParser(":", ";"));
        double[] allstat = new double[all.getNumberOfElements()];
        int i = 0;
        while (i < all.getNumberOfElements()) {
            allstat[i] = Double.parseDouble(all.getElementAt(i).getSequenceAnnotationByType("signal", 0).getIdentifier());
            ++i;
        }
        double[] allw = Interpolation.getWeight(all, allstat, 0.2, Interpolation.RANK_LOG);
        double[] nallw = Interpolation.getBgWeight(allw);
        ResultSet[] rs = new ResultSet[3];
        AucROC aucroc = new AucROC();
        AucPR aucpr = new AucPR();
        PerformanceMeasureParameterSet perfs = new PerformanceMeasureParameterSet(aucroc, aucpr);
        int i2 = 0;
        try {
            GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(classif));
            rs[i2] = EvaluateSingleDataSetSlimDimontHOSingleCl.getResult(cl, -1, -1, top, shuffled, sampled, all, allstat, allw, nallw);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ResultSet[] temp = EvaluateSingleDataSetSlimDimontHOSingleCl.getMinMaxResult(top, shuffled, sampled, all, (double[])allw.clone(), (double[])nallw.clone());
        rs[rs.length - 2] = temp[0];
        rs[rs.length - 1] = temp[1];
        System.out.println(new ListResult("", "", null, rs));
    }

    public static DataSet subSample(DataSet dat, int num) throws Exception {
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        int i = 0;
        while (i < num) {
            list.add(dat.getElementAt(i));
            ++i;
        }
        return new DataSet("", list);
    }

    public static ResultSet getResult(GenDisMixClassifier cl, int order, int components, DNADataSet top, DNADataSet shuffled, DataSet sampled, DNADataSet all, double[] allstat, double[] allw, double[] nallw) throws Exception {
        return EvaluateSingleDataSetSlimDimontHOSingleCl.getResult(order, components, cl.getScores(top), cl.getScores(shuffled), cl.getScores(sampled), cl.getScores(all), cl.getLastScore(), allstat, allw, nallw);
    }

    public static ResultSet getResult(int order, int components, double[] topScores, double[] shuffledScores, double[] sampledScores, double[] allScores, double lastScore, double[] allstat, double[] allw, double[] nallw) throws Exception {
        topScores = (double[])topScores.clone();
        Arrays.sort(topScores);
        shuffledScores = (double[])shuffledScores.clone();
        Arrays.sort(shuffledScores);
        sampledScores = (double[])sampledScores.clone();
        Arrays.sort(sampledScores);
        AucROC aucroc = new AucROC();
        AucPR aucpr = new AucPR();
        ResultSet res3 = EvaluateSingleDataSetSlimDimontHOSingleCl.getMeasures((double[])allScores.clone(), (double[])allstat.clone(), (double[])allw.clone(), (double[])nallw.clone(), "");
        LinkedList<Result> list = new LinkedList<Result>();
        list.add(new NumericalResult("Order", "", order));
        list.add(new NumericalResult("Components", "", components));
        list.add(new NumericalResult("LastScore", "", lastScore));
        NumericalResultSet res1 = aucroc.compute(topScores, shuffledScores);
        list.add(res1.getResultAt(0));
        res1 = aucpr.compute(topScores, shuffledScores);
        int j = 0;
        while (j < res1.getNumberOfResults()) {
            list.add(res1.getResultAt(j));
            ++j;
        }
        NumericalResultSet res2 = aucroc.compute(topScores, sampledScores);
        list.add(new NumericalResult(String.valueOf(res2.getResultAt(0).getName()) + " (sampled)", "", (Double)res2.getResultAt(0).getValue()));
        res2 = aucpr.compute(topScores, sampledScores);
        int j2 = 0;
        while (j2 < res2.getNumberOfResults()) {
            list.add(new NumericalResult(String.valueOf(res2.getResultAt(j2).getName()) + " (sampled)", "", (Double)res2.getResultAt(j2).getValue()));
            ++j2;
        }
        j2 = 0;
        while (j2 < res3.getNumberOfResults()) {
            list.add(res3.getResultAt(j2));
            ++j2;
        }
        return new ResultSet(list);
    }

    public static ResultSet[] getMinMaxResult(DNADataSet top, DNADataSet shuffled, DataSet sampled, DNADataSet all, double[] allw, double[] nallw) throws Exception {
        ResultSet[] rs = new ResultSet[2];
        double[] mm = EvaluateSingleDataSetSlimDimontHOSingleCl.getMinMax(top, shuffled, sampled, all, (double[])allw.clone(), (double[])nallw.clone());
        LinkedList<SimpleResult> list = new LinkedList<SimpleResult>();
        list.add(new CategoricalResult("Order", "", "Max"));
        list.add(new CategoricalResult("Components", "", "Max"));
        list.add(new NumericalResult("LastScore", "", Double.NaN));
        list.add(new NumericalResult("AUC-ROC", "", 1.0));
        list.add(new NumericalResult("AUC-PR (Davis and Goadrich)", "", 1.0));
        list.add(new NumericalResult("AUC-PR (Integral)", "", 1.0));
        list.add(new NumericalResult("AUC-ROC (sampled)", "", 1.0));
        list.add(new NumericalResult("AUC-PR (Davis and Goadrich) (sampled)", "", 1.0));
        list.add(new NumericalResult("AUC-PR (Integral) (sampled)", "", 1.0));
        list.add(new NumericalResult("wAUC-ROC", "", mm[0]));
        list.add(new NumericalResult("wAUC-PR", "", mm[1]));
        list.add(new NumericalResult("Pearson correlation", "", 1.0));
        list.add(new NumericalResult("Spearman correlation", "", 1.0));
        rs[0] = new ResultSet(list);
        list.clear();
        list.add(new CategoricalResult("Order", "", "Min"));
        list.add(new CategoricalResult("Components", "", "Min"));
        list.add(new NumericalResult("LastScore", "", Double.NaN));
        list.add(new NumericalResult("AUC-ROC", "", 0.0));
        list.add(new NumericalResult("AUC-PR (Davis and Goadrich)", "", mm[4]));
        list.add(new NumericalResult("AUC-PR (Integral)", "", mm[5]));
        list.add(new NumericalResult("AUC-ROC (sampled)", "", 0.0));
        list.add(new NumericalResult("AUC-PR (Davis and Goadrich) (sampled)", "", mm[6]));
        list.add(new NumericalResult("AUC-PR (Integral) (sampled)", "", mm[7]));
        list.add(new NumericalResult("wAUC-ROC", "", mm[2]));
        list.add(new NumericalResult("wAUC-PR", "", mm[3]));
        list.add(new NumericalResult("Pearson correlation", "", -1.0));
        list.add(new NumericalResult("Spearman correlation", "", -1.0));
        rs[1] = new ResultSet(list);
        return rs;
    }

    public static ResultSet getEmptyResult(int order, int components) {
        LinkedList<NumericalResult> list = new LinkedList<NumericalResult>();
        list.add(new NumericalResult("Order", "", order));
        list.add(new NumericalResult("Components", "", components));
        list.add(new NumericalResult("LastScore", "", Double.NaN));
        list.add(new NumericalResult("AUC-ROC", "", Double.NaN));
        list.add(new NumericalResult("AUC-PR (Davis and Goadrich)", "", Double.NaN));
        list.add(new NumericalResult("AUC-PR (Integral)", "", Double.NaN));
        list.add(new NumericalResult("AUC-ROC (sampled)", "", Double.NaN));
        list.add(new NumericalResult("AUC-PR (Davis and Goadrich) (sampled)", "", Double.NaN));
        list.add(new NumericalResult("AUC-PR (Integral) (sampled)", "", Double.NaN));
        list.add(new NumericalResult("wAUC-ROC", "", Double.NaN));
        list.add(new NumericalResult("wAUC-PR", "", Double.NaN));
        list.add(new NumericalResult("Pearson correlation", "", Double.NaN));
        list.add(new NumericalResult("Spearman correlation", "", Double.NaN));
        return new ResultSet(list);
    }

    private static ResultSet getMeasures(double[] scores1, double[] scores2, String suffix, NumericalPerformanceMeasure ... measures) {
        Arrays.sort(scores1);
        Arrays.sort(scores2);
        LinkedList<NumericalResult> list = new LinkedList<NumericalResult>();
        int i = 0;
        while (i < measures.length) {
            NumericalResultSet nrs = measures[i].compute(scores1, scores2);
            int j = 0;
            while (j < nrs.getNumberOfResults()) {
                list.add(new NumericalResult(String.valueOf(nrs.getResultAt(j).getName()) + suffix, nrs.getResultAt(j).getComment(), (Double)nrs.getResultAt(j).getValue()));
                ++j;
            }
            ++i;
        }
        return new ResultSet(list);
    }

    private static double[] getMaxScores(DNADataSet data, GenDisMixClassifier cl) throws Exception {
        ThresholdedStrandChIPper chipper = (ThresholdedStrandChIPper)cl.getDifferentiableSequenceScore(0);
        DifferentiableStatisticalModel dsm = chipper.getFunction(0);
        double[] scs = new double[data.getNumberOfElements()];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            double sc;
            double max = Double.NEGATIVE_INFINITY;
            Sequence seq = data.getElementAt(i);
            int j = 0;
            while (j < seq.getLength() - dsm.getLength() + 1) {
                sc = dsm.getLogScoreFor(seq, j, j + dsm.getLength() - 1);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            seq = seq.reverseComplement();
            j = 0;
            while (j < seq.getLength() - dsm.getLength() + 1) {
                sc = dsm.getLogScoreFor(seq, j, j + dsm.getLength() - 1);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            scs[i] = max;
            ++i;
        }
        return scs;
    }

    public static ResultSet getMeasures(double[] sc, double[] allstat, double[] allw, double[] nallw, String suffix) throws Exception {
        double pears = ToolBox.pearsonCorrelation(sc, allstat);
        double spear = ToolBox.spearmanCorrelation(sc, allstat);
        AucROC aucroc = new AucROC();
        AucPR aucpr = new AucPR();
        ToolBox.sortAlongWith(sc, allw, nallw);
        NumericalResultSet roc = aucroc.compute(sc, allw, sc, nallw);
        NumericalResultSet pr = aucpr.compute(sc, allw, sc, nallw);
        return new ResultSet(new Result[][]{{new NumericalResult("wAUC-ROC" + suffix, "", (Double)roc.getResultAt(0).getValue()), new NumericalResult("wAUC-PR" + suffix, "", (Double)pr.getResultAt(0).getValue()), new NumericalResult("Pearson correlation" + suffix, "", pears), new NumericalResult("Spearman correlation" + suffix, "", spear)}});
    }

    public static double[] getMinMax(DNADataSet top, DNADataSet shuffled, DataSet sampled, DNADataSet all, double[] allw, double[] nallw) throws Exception {
        AucROC aucroc = new AucROC();
        AucPR aucpr = new AucPR();
        double[] sc = (double[])allw.clone();
        ToolBox.sortAlongWith(sc, allw, nallw);
        NumericalResultSet rocMax = aucroc.compute(sc, allw, sc, nallw);
        NumericalResultSet prMax = aucpr.compute(sc, allw, sc, nallw);
        int i = 0;
        while (i < sc.length) {
            int n = i++;
            sc[n] = sc[n] * -1.0;
        }
        ToolBox.sortAlongWith(sc, allw, nallw);
        NumericalResultSet rocMin = aucroc.compute(sc, allw, sc, nallw);
        NumericalResultSet prMin = aucpr.compute(sc, allw, sc, nallw);
        double[] zeros = new double[top.getNumberOfElements()];
        double[] ones = new double[shuffled.getNumberOfElements()];
        Arrays.fill(ones, 1.0);
        NumericalResultSet hPrMin = aucpr.compute(zeros, ones);
        ones = new double[sampled.getNumberOfElements()];
        Arrays.fill(ones, 1.0);
        NumericalResultSet hPrMin2 = aucpr.compute(zeros, ones);
        return new double[]{(Double)rocMax.getResultAt(0).getValue(), (Double)prMax.getResultAt(0).getValue(), (Double)rocMin.getResultAt(0).getValue(), (Double)prMin.getResultAt(0).getValue(), (Double)hPrMin.getResultAt(0).getValue(), (Double)hPrMin.getResultAt(1).getValue(), (Double)hPrMin2.getResultAt(0).getValue(), (Double)hPrMin2.getResultAt(1).getValue()};
    }
}

