/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.utils.ComparableElement;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MyHTSeqCountSE {
    static Pattern p = Pattern.compile("[0-9]+M");

    public static void main(String[] args) throws Exception {
        String file;
        boolean allOverlapping = Boolean.parseBoolean(args[1]);
        boolean unique = Boolean.parseBoolean(args[2]);
        BufferedReader read = null;
        if (args.length > 3) {
            read = new BufferedReader(new FileReader(args[3]));
            file = args[3];
        } else {
            read = new BufferedReader(new InputStreamReader(System.in));
            file = "stdin";
        }
        String str = null;
        HashMap frags = new HashMap();
        int multi = 0;
        HashMap multiMap = new HashMap();
        HashMap<String, Integer> uniqueChromCounts = new HashMap<String, Integer>();
        while ((str = read.readLine()) != null) {
            if (str.startsWith("@")) continue;
            String[] parts = str.split("\t");
            String id = parts[0];
            String chrom = parts[2];
            if (!"NH:i:1".equals(parts[13].trim())) {
                if (unique) {
                    ++multi;
                    continue;
                }
                if (multiMap.get(id) == null) {
                    multiMap.put(id, new LinkedList());
                }
                LinkedList li = (LinkedList)multiMap.get(id);
                li.add(chrom);
            } else if (uniqueChromCounts.containsKey(chrom)) {
                uniqueChromCounts.put(chrom, (Integer)uniqueChromCounts.get(chrom) + 1);
            } else {
                uniqueChromCounts.put(chrom, 1);
            }
            int flag = Integer.parseInt(parts[1]);
            int start = Integer.parseInt(parts[3]);
            int len = MyHTSeqCountSE.parseCIGAR(parts[5]);
            String mateChrom = parts[6];
            int mateStart = Integer.parseInt(parts[7]);
            int flen = Integer.parseInt(parts[8]);
            Read r = new Read(id, flag, chrom, start, len, mateChrom, mateStart, flen);
            Fragment f = new Fragment(r.id, r.chrom, r.start, r.start + r.len, r.strand());
            if (f == null) continue;
            if (!frags.containsKey(f.chrom)) {
                frags.put(f.chrom, new ArrayList());
            }
            ArrayList li = (ArrayList)frags.get(f.chrom);
            li.add(f);
        }
        read.close();
        PrintWriter wr = new PrintWriter(String.valueOf(file) + "_unique_counts.txt");
        for (String chr : uniqueChromCounts.keySet()) {
            wr.println(String.valueOf(chr) + "\t" + uniqueChromCounts.get(chr));
        }
        wr.close();
        wr = new PrintWriter(String.valueOf(file) + "_multi_counts.txt");
        String[] chroms = uniqueChromCounts.keySet().toArray(new String[0]);
        int i = 0;
        while (i < chroms.length) {
            wr.print("\t" + chroms[i]);
            ++i;
        }
        wr.println();
        for (String id : multiMap.keySet()) {
            LinkedList values = (LinkedList)multiMap.get(id);
            wr.print(id);
            int i2 = 0;
            while (i2 < chroms.length) {
                if (values.contains(chroms[i2])) {
                    wr.print("\t1");
                } else {
                    wr.print("\t0");
                }
                ++i2;
            }
            wr.println();
        }
        wr.close();
        System.err.println("multiple: " + multi);
        Iterator it = frags.keySet().iterator();
        HashMap<String, Object[]> fragArs = new HashMap<String, Object[]>();
        while (it.hasNext()) {
            String key = (String)it.next();
            ArrayList li = (ArrayList)frags.get(key);
            frags.put(key, null);
            Object[] frags2 = li.toArray(new Fragment[0]);
            li.clear();
            Arrays.sort(frags2);
            fragArs.put(key, frags2);
            System.err.println(String.valueOf(key) + " " + frags2.length);
        }
        BufferedReader gffread = new BufferedReader(new FileReader(args[0]));
        HashMap genes = new HashMap();
        while ((str = gffread.readLine()) != null) {
            String[] parts = str.split("\t");
            if (parts.length <= 2 || !"transcript".equals(parts[2])) continue;
            int start = Integer.parseInt(parts[3]);
            int end = Integer.parseInt(parts[4]);
            boolean strand = "+".equals(parts[6]);
            String chrom = parts[0];
            String id = parts[8].replaceAll(".*ID=", "").replaceAll("\\;.*", "");
            if (!genes.containsKey(chrom)) {
                genes.put(chrom, new ArrayList());
            }
            ArrayList li = (ArrayList)genes.get(chrom);
            li.add(new Gene(chrom, start, end, strand, id));
        }
        gffread.close();
        HashMap<String, Object[]> geneArs = new HashMap<String, Object[]>();
        for (String key : genes.keySet()) {
            ArrayList li = (ArrayList)genes.get(key);
            genes.put(key, null);
            Object[] li2 = li.toArray(new Gene[0]);
            li.clear();
            Arrays.sort(li2);
            geneArs.put(key, li2);
        }
        it = genes.keySet().iterator();
        int nofeat = 0;
        while (it.hasNext()) {
            String chrom = (String)it.next();
            Fragment[] fragAr = (Fragment[])fragArs.get(chrom);
            Gene[] geneAr = (Gene[])geneArs.get(chrom);
            int k = 0;
            int i3 = 0;
            while (fragAr != null && i3 < fragAr.length) {
                Fragment frag = fragAr[i3];
                int nfeat = 0;
                while (k < geneAr.length && geneAr[k].end < frag.start) {
                    ++k;
                }
                if (k == geneAr.length) {
                    ++nofeat;
                } else {
                    LinkedList<ComparableElement<Gene, Integer>> comps = null;
                    if (!allOverlapping) {
                        comps = new LinkedList<ComparableElement<Gene, Integer>>();
                    }
                    int j = k;
                    while (j < geneAr.length && geneAr[j].start < frag.end) {
                        Gene gene = geneAr[j];
                        if (allOverlapping) {
                            if (frag.overlap(gene) > 0) {
                                gene.plusplus();
                                ++nfeat;
                            }
                        } else {
                            int overlap = frag.overlap(gene);
                            if (overlap > 0) {
                                ++nfeat;
                                comps.add(new ComparableElement<Gene, Integer>(gene, overlap));
                            }
                        }
                        ++j;
                    }
                    if (!allOverlapping && comps.size() > 0) {
                        Object[] comps2 = comps.toArray(new ComparableElement[0]);
                        Arrays.sort(comps2);
                        ((Gene)((ComparableElement)comps2[comps2.length - 1]).getElement()).plusplus();
                    }
                    if (nfeat == 0) {
                        ++nofeat;
                    }
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < geneAr.length) {
                System.out.println(String.valueOf(geneAr[i3].id) + "\t" + geneAr[i3].getCount());
                ++i3;
            }
        }
        System.err.println("no features: " + nofeat);
    }

    private static int parseCIGAR(String string) {
        Matcher m = p.matcher(string);
        int l = 0;
        while (m.find()) {
            l += Integer.parseInt(string.substring(m.start(), m.end() - 1));
        }
        return l;
    }

    private static class Fragment
    implements Comparable<Fragment> {
        String id;
        String chrom;
        int start;
        int end;
        boolean strand;

        public Fragment(String id, String chrom, int start, int end, boolean strand) {
            this.id = id;
            this.chrom = chrom;
            this.start = start;
            this.end = end;
            this.strand = strand;
        }

        public int overlap(Gene gene) {
            if (gene.strand != this.strand) {
                return 0;
            }
            int maxstart = Math.max(this.start, gene.start - 1);
            int minend = Math.min(this.end, gene.end - 1);
            if (minend > maxstart) {
                return minend - maxstart;
            }
            return 0;
        }

        @Override
        public int compareTo(Fragment second) {
            int comp = this.chrom.compareTo(second.chrom);
            if (comp == 0) {
                return this.start > second.start ? 1 : (this.start < second.start ? -1 : 0);
            }
            return comp;
        }

        public String toString() {
            return String.valueOf(this.chrom) + " " + this.start + " " + this.end + " " + this.strand;
        }
    }

    private static class Gene
    implements Comparable<Gene> {
        String chrom;
        int start;
        int end;
        boolean strand;
        String id;
        int count = 0;

        public Gene(String chrom, int start, int end, boolean strand, String id) {
            this.chrom = chrom;
            this.start = start;
            this.end = end;
            this.strand = strand;
            this.id = id;
        }

        @Override
        public int compareTo(Gene second) {
            int comp = this.chrom.compareTo(second.chrom);
            if (comp == 0) {
                return this.start > second.start ? 1 : (this.start < second.start ? -1 : 0);
            }
            return comp;
        }

        public void plusplus() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class Read {
        String id;
        int flag;
        String chrom;
        int start;
        int len;
        String mateChrom;
        int mateStart;
        int flen;

        public Read(String id, int flag, String chrom, int start, int len, String mateChrom, int mateStart, int flen) {
            this.id = id;
            this.flag = flag;
            this.chrom = chrom;
            this.start = start;
            this.len = len;
            this.mateChrom = mateChrom;
            this.mateStart = mateStart;
            this.flen = flen;
        }

        public String toString() {
            return String.valueOf(this.id) + "\t" + this.flag + "\t" + this.chrom + "\t" + this.start + "\t" + this.len + "\t" + this.flen + "\t" + this.mateChrom + "\t" + this.mateStart;
        }

        public boolean matches(Read second) {
            return this.id.equals(second.id) && this.chrom.equals(second.chrom) && this.start == second.mateStart && this.mateStart == second.start && this.flen == -second.flen && this.inPair() && second.inPair();
        }

        public boolean strand() {
            return (this.flag & 0x10) != 16;
        }

        public boolean isFirst() {
            return (this.flag & 0x40) == 64;
        }

        public boolean inPair() {
            return (this.flag & 2) == 2;
        }
    }

    private static class ReadGroup {
        private String id;
        LinkedList<Read> unpaired;

        public ReadGroup(String id) {
            this.id = id;
        }

        public int size() {
            return this.unpaired == null ? 0 : this.unpaired.size();
        }

        public Fragment addRead(Read read) {
            if (!read.inPair()) {
                return new Fragment(read.id, read.chrom, read.start, read.start + read.len, read.isFirst() && read.strand());
            }
            if (this.unpaired == null) {
                this.unpaired = new LinkedList();
            }
            if (this.unpaired.size() > 0) {
                Iterator it = this.unpaired.iterator();
                while (it.hasNext()) {
                    Read second = (Read)it.next();
                    if (!second.matches(read)) continue;
                    it.remove();
                    int fstart = Math.min(read.start, second.start);
                    int end = (read.start > second.start ? read.start + read.len : second.start + second.len) - 1;
                    boolean strand = read.isFirst() ? read.strand() : second.strand();
                    return new Fragment(read.id, read.chrom, fstart, end, strand);
                }
            }
            this.unpaired.add(read);
            return null;
        }

        public String toString() {
            if (this.unpaired == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.unpaired.size()) {
                buf.append(this.unpaired.get(i));
                buf.append("\n");
                ++i;
            }
            return buf.toString();
        }
    }
}

