/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MyHTSeqOnlyCount {
    static Pattern p = Pattern.compile("[0-9]+M");

    public static void main(String[] args) throws Exception {
        int i;
        BufferedReader read = null;
        String file = args[0];
        String str = null;
        HashMap multiMapPaired = new HashMap();
        HashMap<String, Integer> uniqueChromCountsPaired = new HashMap<String, Integer>();
        HashMap multiMapUnpaired = new HashMap();
        HashMap<String, Integer> uniqueChromCountsUnpaired = new HashMap<String, Integer>();
        String lastId = "";
        read = new BufferedReader(new FileReader(args[0]));
        while ((str = read.readLine()) != null) {
            if (str.startsWith("@")) continue;
            String[] parts = str.split("\t");
            String id = parts[0];
            String chrom = parts[2];
            boolean isUnique = true;
            int flag = Integer.parseInt(parts[1]);
            int start = Integer.parseInt(parts[3]);
            int len = MyHTSeqOnlyCount.parseCIGAR(parts[5]);
            String mateChrom = parts[6];
            int mateStart = Integer.parseInt(parts[7]);
            int flen = Integer.parseInt(parts[8]);
            Read r = new Read(id, flag, chrom, start, len, mateChrom, mateStart, flen, isUnique);
            if (!"NH:i:1".equals(parts[13].trim()) || parts.length >= 20 && !"XQ:i:0".equals(parts[19])) continue;
            if (r.inPair()) {
                if (uniqueChromCountsPaired.containsKey(chrom)) {
                    uniqueChromCountsPaired.put(chrom, (Integer)uniqueChromCountsPaired.get(chrom) + 1);
                    continue;
                }
                uniqueChromCountsPaired.put(chrom, 1);
                continue;
            }
            if (uniqueChromCountsUnpaired.containsKey(chrom)) {
                uniqueChromCountsUnpaired.put(chrom, (Integer)uniqueChromCountsUnpaired.get(chrom) + 1);
                continue;
            }
            uniqueChromCountsUnpaired.put(chrom, 1);
        }
        read.close();
        HashMap pairedAndUnpaired = new HashMap();
        HashMap<String, String> chromOrgMap = new HashMap<String, String>();
        HashSet<String> set = new HashSet<String>();
        BufferedReader readMap = new BufferedReader(new FileReader(args[1]));
        while ((str = readMap.readLine()) != null) {
            String[] parts = str.split("\t");
            chromOrgMap.put(parts[0], parts[1]);
            set.add(parts[1]);
        }
        readMap.close();
        PrintWriter wr = new PrintWriter(String.valueOf(file) + "_multi_counts.txt");
        String[] chroms = set.toArray(new String[0]);
        int i2 = 0;
        while (i2 < chroms.length) {
            wr.print("\t" + chroms[i2]);
            ++i2;
        }
        wr.println();
        read = new BufferedReader(new FileReader(args[0]));
        while ((str = read.readLine()) != null) {
            LinkedList li;
            if (str.startsWith("@")) continue;
            String[] parts = str.split("\t");
            String currId = parts[0];
            String compId = currId.replaceAll("\\s.*", "");
            String chrom = parts[2];
            boolean isUnique = true;
            int flag = Integer.parseInt(parts[1]);
            int start = Integer.parseInt(parts[3]);
            int len = MyHTSeqOnlyCount.parseCIGAR(parts[5]);
            String mateChrom = parts[6];
            int mateStart = Integer.parseInt(parts[7]);
            int flen = Integer.parseInt(parts[8]);
            Read r = new Read(currId, flag, chrom, start, len, mateChrom, mateStart, flen, isUnique);
            if (!parts[13].startsWith("NH:i")) {
                System.err.println(str);
                System.exit(1);
            }
            if ("NH:i:1".equals(parts[13].trim()) || parts.length >= 20 && !"XQ:i:0".equals(parts[19])) continue;
            boolean cross = false;
            if (!compId.equals(lastId)) {
                int i3;
                if (multiMapPaired.keySet().size() > 0 && multiMapUnpaired.keySet().size() > 0) {
                    if (multiMapPaired.keySet().size() == 2) {
                        Iterator it = multiMapPaired.keySet().iterator();
                        while (it.hasNext()) {
                            LinkedList values = (LinkedList)multiMapPaired.get(it.next());
                            int i4 = 0;
                            while (i4 < values.size()) {
                                if (uniqueChromCountsPaired.containsKey(values.get(i4))) {
                                    uniqueChromCountsPaired.put((String)values.get(i4), (Integer)uniqueChromCountsPaired.get(values.get(i4)) + 1);
                                } else {
                                    uniqueChromCountsPaired.put((String)values.get(i4), 1);
                                }
                                ++i4;
                            }
                        }
                        multiMapPaired.clear();
                        multiMapUnpaired.clear();
                    } else {
                        for (String key : multiMapUnpaired.keySet()) {
                            LinkedList paired = (LinkedList)multiMapPaired.get(key);
                            if (paired == null) {
                                multiMapPaired.put(key, (LinkedList)multiMapUnpaired.get(key));
                                continue;
                            }
                            paired.addAll((Collection)multiMapUnpaired.get(key));
                        }
                        cross = true;
                    }
                }
                for (String id : multiMapPaired.keySet()) {
                    LinkedList values = (LinkedList)multiMapPaired.get(id);
                    if (cross) {
                        wr.print("x");
                    } else {
                        wr.print("p");
                    }
                    i3 = 0;
                    while (i3 < chroms.length) {
                        if (values.contains(chroms[i3])) {
                            wr.print("\t1");
                        } else {
                            wr.print("\t0");
                        }
                        ++i3;
                    }
                    wr.println();
                }
                for (String id : multiMapUnpaired.keySet()) {
                    LinkedList values = (LinkedList)multiMapUnpaired.get(id);
                    if (cross) {
                        wr.print("x");
                    } else {
                        wr.print("u");
                    }
                    i3 = 0;
                    while (i3 < chroms.length) {
                        if (values.contains(chroms[i3])) {
                            wr.print("\t1");
                        } else {
                            wr.print("\t0");
                        }
                        ++i3;
                    }
                    wr.println();
                }
                multiMapPaired.clear();
                multiMapUnpaired.clear();
            }
            if (r.inPair()) {
                if (multiMapPaired.get(currId) == null) {
                    multiMapPaired.put(currId, new LinkedList());
                }
                li = (LinkedList)multiMapPaired.get(currId);
                li.add((String)chromOrgMap.get(chrom));
            } else {
                if (multiMapUnpaired.get(currId) == null) {
                    multiMapUnpaired.put(currId, new LinkedList());
                }
                li = (LinkedList)multiMapUnpaired.get(currId);
                li.add((String)chromOrgMap.get(chrom));
            }
            lastId = compId;
        }
        read.close();
        for (String id : multiMapPaired.keySet()) {
            LinkedList values = (LinkedList)multiMapPaired.get(id);
            wr.print("p");
            i = 0;
            while (i < chroms.length) {
                if (values.contains(chroms[i])) {
                    wr.print("\t1");
                } else {
                    wr.print("\t0");
                }
                ++i;
            }
            wr.println();
        }
        for (String id : multiMapUnpaired.keySet()) {
            LinkedList values = (LinkedList)multiMapUnpaired.get(id);
            wr.print("u");
            i = 0;
            while (i < chroms.length) {
                if (values.contains(chroms[i])) {
                    wr.print("\t1");
                } else {
                    wr.print("\t0");
                }
                ++i;
            }
            wr.println();
        }
        wr.close();
        wr = new PrintWriter(String.valueOf(file) + "_unique_counts.txt");
        for (String chr : uniqueChromCountsPaired.keySet()) {
            wr.println(String.valueOf(chr) + "-paired\t" + uniqueChromCountsPaired.get(chr));
        }
        for (String chr : uniqueChromCountsUnpaired.keySet()) {
            wr.println(String.valueOf(chr) + "-unpaired\t" + uniqueChromCountsUnpaired.get(chr));
        }
        wr.close();
    }

    private static int parseCIGAR(String string) {
        Matcher m = p.matcher(string);
        int l = 0;
        while (m.find()) {
            l += Integer.parseInt(string.substring(m.start(), m.end() - 1));
        }
        return l;
    }

    private static class Fragment
    implements Comparable<Fragment> {
        String id;
        String chrom;
        int start;
        int end;
        boolean strand;
        boolean unique;

        public Fragment(String id, String chrom, int start, int end, boolean strand, boolean unique) {
            this.id = id;
            this.chrom = chrom;
            this.start = start;
            this.end = end;
            this.strand = strand;
            this.unique = unique;
        }

        public int overlap(Gene gene) {
            if (gene.strand != this.strand) {
                return 0;
            }
            int maxstart = Math.max(this.start, gene.start - 1);
            int minend = Math.min(this.end, gene.end - 1);
            if (minend > maxstart) {
                return minend - maxstart;
            }
            return 0;
        }

        @Override
        public int compareTo(Fragment second) {
            int comp = this.chrom.compareTo(second.chrom);
            if (comp == 0) {
                return this.start > second.start ? 1 : (this.start < second.start ? -1 : 0);
            }
            return comp;
        }

        public String toString() {
            return String.valueOf(this.chrom) + " " + this.start + " " + this.end + " " + this.strand;
        }
    }

    private static class Gene
    implements Comparable<Gene> {
        String chrom;
        int start;
        int end;
        boolean strand;
        String id;
        int count = 0;

        public Gene(String chrom, int start, int end, boolean strand, String id) {
            this.chrom = chrom;
            this.start = start;
            this.end = end;
            this.strand = strand;
            this.id = id;
        }

        @Override
        public int compareTo(Gene second) {
            int comp = this.chrom.compareTo(second.chrom);
            if (comp == 0) {
                return this.start > second.start ? 1 : (this.start < second.start ? -1 : 0);
            }
            return comp;
        }

        public void plusplus() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class Read {
        String id;
        int flag;
        String chrom;
        int start;
        int len;
        String mateChrom;
        int mateStart;
        int flen;
        boolean unique;

        public Read(String id, int flag, String chrom, int start, int len, String mateChrom, int mateStart, int flen, boolean unique) {
            this.id = id;
            this.flag = flag;
            this.chrom = chrom;
            this.start = start;
            this.len = len;
            this.mateChrom = mateChrom;
            this.mateStart = mateStart;
            this.flen = flen;
            this.unique = unique;
        }

        public String toString() {
            return String.valueOf(this.id) + "\t" + this.flag + "\t" + this.chrom + "\t" + this.start + "\t" + this.len + "\t" + this.flen + "\t" + this.mateChrom + "\t" + this.mateStart;
        }

        public boolean matches(Read second) {
            return this.id.equals(second.id) && this.chrom.equals(second.chrom) && this.start == second.mateStart && this.mateStart == second.start && this.flen == -second.flen && this.inPair() && second.inPair();
        }

        public boolean strand() {
            return (this.flag & 0x10) != 16;
        }

        public boolean isFirst() {
            return (this.flag & 0x40) == 64;
        }

        public boolean inPair() {
            return (this.flag & 2) == 2;
        }
    }

    private static class ReadGroup {
        private String id;
        LinkedList<Read> unpaired;

        public ReadGroup(String id) {
            this.id = id;
        }

        public int size() {
            return this.unpaired == null ? 0 : this.unpaired.size();
        }

        public Fragment addRead(Read read) {
            if (!read.inPair()) {
                return new Fragment(read.id, read.chrom, read.start, read.start + read.len, read.isFirst() && read.strand(), read.unique);
            }
            if (this.unpaired == null) {
                this.unpaired = new LinkedList();
            }
            if (this.unpaired.size() > 0) {
                Iterator it = this.unpaired.iterator();
                while (it.hasNext()) {
                    Read second = (Read)it.next();
                    if (!second.matches(read)) continue;
                    it.remove();
                    int fstart = Math.min(read.start, second.start);
                    int end = (read.start > second.start ? read.start + read.len : second.start + second.len) - 1;
                    boolean strand = read.isFirst() ? read.strand() : second.strand();
                    return new Fragment(read.id, read.chrom, fstart, end, strand, read.unique && second.unique);
                }
            }
            this.unpaired.add(read);
            return null;
        }

        public String toString() {
            if (this.unpaired == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.unpaired.size()) {
                buf.append(this.unpaired.get(i));
                buf.append("\n");
                ++i;
            }
            return buf.toString();
        }
    }
}

