/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.TwoPointEvaluater;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.PFMComparator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.LinkedList;

public class Randklatscher {
    public static void main(String[] args) throws Exception {
        BufferedReader read = new BufferedReader(new FileReader(args[0]));
        String str = read.readLine();
        LinkedList<ComparableElement<Sequence, Double>> seqs = new LinkedList<ComparableElement<Sequence, Double>>();
        while ((str = read.readLine()) != null) {
            String[] parts = str.split("\t");
            seqs.add(new ComparableElement<Sequence, Double>(Sequence.create(DNAAlphabetContainer.SINGLETON, parts[5]), Double.parseDouble(parts[3])));
        }
        Object[] els = seqs.toArray(new ComparableElement[0]);
        Arrays.sort(els);
        Sequence[] seqs2 = new Sequence[els.length];
        int i = 0;
        while (i < els.length) {
            seqs2[i] = (Sequence)((ComparableElement)els[i]).getElement();
            ++i;
        }
        DataSet data = new DataSet("", seqs2);
        double[][] pwm = PFMComparator.getPWM(data, 0, data.getNumberOfElements());
        double[] entropy = new double[pwm.length];
        double log2 = Math.log(2.0);
        double thresh = 1.0;
        int i2 = 0;
        while (i2 < pwm.length) {
            entropy[i2] = Math.log(pwm[i2].length) / log2;
            int j = 0;
            while (j < pwm[i2].length) {
                if (pwm[i2][j] > 0.0) {
                    int n = i2;
                    entropy[n] = entropy[n] + pwm[i2][j] * Math.log(pwm[i2][j]) / log2;
                }
                ++j;
            }
            ++i2;
        }
        double[][] mi = TwoPointEvaluater.getMIInBits(data, null);
        double[] maxMi = new double[mi.length];
        int i3 = 0;
        while (i3 < mi.length) {
            int j = 0;
            while (j < mi[i3].length) {
                if (i3 != j && mi[i3][j] > maxMi[i3]) {
                    maxMi[i3] = mi[i3][j];
                }
                ++j;
            }
            ++i3;
        }
        boolean l = entropy[0] >= thresh || maxMi[0] >= thresh;
        boolean r = entropy[entropy.length - 1] >= thresh || maxMi[maxMi.length - 1] >= thresh;
        String temp = args[0].substring(args[0].lastIndexOf("/") + 1);
        temp = temp.substring(0, temp.indexOf("-predictions"));
        String[] parts = temp.split("_");
        System.out.println(String.valueOf(parts[0]) + "\t" + parts[4].replaceAll("order", "") + "\t" + parts[5].replaceAll("comp", "") + "\t" + l + "\t" + r + "\t" + (r || l));
    }
}

