/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;
import java.util.Arrays;

public class TestMarz {
    public static void main(String[] args) throws Exception {
        DNADataSet bs = new DNADataSet("/Users/dev/Downloads/marzscaled/Hb.txt", '#');
        DNADataSet chip = new DNADataSet("/Users/dev/Downloads/marzscaled/all.txt", '#');
        Sequence[] shuffled = new Sequence[chip.getNumberOfElements() * 100];
        int i = 0;
        int k = 0;
        while (i < chip.getNumberOfElements()) {
            Sequence seq = chip.getElementAt(i);
            int j = 0;
            while (j < 100) {
                shuffled[k] = new PermutedSequence(seq);
                ++j;
                ++k;
            }
            ++i;
        }
        DataSet shuffledD = new DataSet("", shuffled);
        DNADataSet genome = new DNADataSet("/Users/dev/Downloads/marzscaled/entirechrom.txt", '#');
        FSDAGTrainSM pwm = TrainableStatisticalModelFactory.createInhomogeneousMarkovModel(DNAAlphabetContainer.SINGLETON, bs.getElementLength(), 4.0, (byte)0);
        HomogeneousMM bg = TrainableStatisticalModelFactory.createHomogeneousMarkovModel(DNAAlphabetContainer.SINGLETON, 4.0, (byte)0);
        pwm.train(bs);
        System.out.println(pwm);
        bg.train(genome);
        double[] scbg = new double[shuffledD.getNumberOfElements()];
        int i2 = 0;
        while (i2 < shuffledD.getNumberOfElements()) {
            Sequence seq = shuffledD.getElementAt(i2);
            double max = Double.NEGATIVE_INFINITY;
            int j = 0;
            while (j < seq.getLength() - pwm.getLength()) {
                double curr = pwm.getLogProbFor(seq, j, j + pwm.getLength() - 1) - bg.getLogProbFor(seq, j, j + pwm.getLength() - 1);
                if (curr > max) {
                    max = curr;
                }
                ++j;
            }
            scbg[i2] = max;
            ++i2;
        }
        double[] scfg = new double[chip.getNumberOfElements()];
        int i3 = 0;
        while (i3 < chip.getNumberOfElements()) {
            Sequence seq = chip.getElementAt(i3);
            double max = Double.NEGATIVE_INFINITY;
            int j = 0;
            while (j < seq.getLength() - pwm.getLength()) {
                double curr = pwm.getLogProbFor(seq, j, j + pwm.getLength() - 1) - bg.getLogScoreFor(seq, j, j + pwm.getLength() - 1);
                if (curr > max) {
                    max = curr;
                }
                ++j;
            }
            scfg[i3] = max;
            ++i3;
        }
        Arrays.sort(scfg);
        Arrays.sort(scbg);
        AucROC roc = new AucROC();
        System.out.println(roc.compute(scfg, scbg));
    }
}

