/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.mixture.motif.positionprior;

import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public abstract class PositionPrior
implements Storable,
Cloneable {
    protected int motifLength;

    protected PositionPrior() {
        this.motifLength = -1;
    }

    protected PositionPrior(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getInstanceName());
        this.extractAdditionalInformation(xml);
        this.setMotifLength(XMLParser.extractObjectForTags(xml, "motifLength", Integer.TYPE));
    }

    public PositionPrior clone() throws CloneNotSupportedException {
        return (PositionPrior)super.clone();
    }

    public abstract double getLogPriorForPositions(int var1, int ... var2) throws IllegalArgumentException;

    public abstract int getLength();

    public abstract String getInstanceName();

    public void setMotifLength(int motifLength) throws IllegalArgumentException {
        int l = this.getLength();
        if (motifLength <= 0 || l != 0 && motifLength > l) {
            throw new IllegalArgumentException("The motif length has to be positive and at most as big as the sequence length.");
        }
        this.motifLength = motifLength;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(1000);
        XMLParser.appendObjectWithTags(xml, this.motifLength, "motifLength");
        xml.append(this.getAdditionalInformation());
        XMLParser.addTags(xml, this.getInstanceName());
        return xml;
    }

    protected abstract StringBuffer getAdditionalInformation();

    protected abstract void extractAdditionalInformation(StringBuffer var1) throws NonParsableException;
}

