/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import cern.jet.stat.Gamma;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.btMeasures.BTExplainingAwayResidual;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.MixtureTrainSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import javax.imageio.ImageIO;

public class SeqLogoPlotter {
    private static Color getColor(double[] pwm, float ic) {
        float[] a = new float[]{0.0f, 1.0f, 0.0f};
        float[] c = new float[]{0.0f, 0.0f, 1.0f};
        float[] g = Color.ORANGE.getColorComponents(null);
        float[] t = new float[]{1.0f, 0.0f, 0.0f};
        float[] nc = new float[3];
        int i = 0;
        while (i < 3) {
            nc[i] = (float)(pwm[0] * (double)a[i] + pwm[1] * (double)c[i] + pwm[2] * (double)g[i] + pwm[3] * (double)t[i]);
            ++i;
        }
        return new Color(nc[0], nc[1], nc[2], ic);
    }

    public static double[][] getDeps(Sequence[] seqs, double[] w) {
        double[][][][] counts = new double[seqs[0].getLength()][seqs[0].getLength()][4][4];
        double sum = 0.0;
        int i = 0;
        while (i < seqs.length) {
            double weight = w == null ? 1.0 : w[i];
            sum += weight;
            int k = 0;
            while (k < seqs[i].getLength()) {
                int l = 0;
                while (l < seqs[i].getLength()) {
                    double[] dArray = counts[k][l][seqs[i].discreteVal(k)];
                    int n = seqs[i].discreteVal(l);
                    dArray[n] = dArray[n] + weight;
                    ++l;
                }
                ++k;
            }
            ++i;
        }
        double[][] mis = new double[seqs[0].getLength()][seqs[0].getLength()];
        int k = 1;
        while (k < seqs[0].getLength()) {
            int l = 0;
            while (l < k) {
                double mi = 0.0;
                int a = 0;
                while (a < 4) {
                    int b = 0;
                    while (b < 4) {
                        if (counts[k][l][a][b] > 0.0) {
                            mi += counts[k][l][a][b] * (Math.log(counts[k][l][a][b]) - Math.log(counts[k][k][a][a]) - Math.log(counts[l][l][b][b]) + Math.log(sum));
                        }
                        ++b;
                    }
                    ++a;
                }
                mis[k][l] = mi;
                mis[l][k] = mi;
                ++l;
            }
            ++k;
        }
        return mis;
    }

    public static int getHeightForColorLogo(int numSeqs, int numOne, int numPerChunk, int oneHeight, int blockSpacer) {
        return numSeqs / numOne * oneHeight + numSeqs / numPerChunk * blockSpacer;
    }

    public static int getHeightForDependencyLogo(int seqLength, int numSeqs, int[] numOne, int[] numPerChunk, int oneHeight, int width, int blockSpacer) {
        int height = SeqLogoPlotter.getHeightForColorLogo(numSeqs, numOne, numPerChunk, oneHeight, blockSpacer);
        int topMargin = width / 5;
        height = (int)((double)height + 1.5 * (double)topMargin);
        return height;
    }

    public static int getHeightForColorLogo(int numSeqs, int[] numOne, int[] numPerChunk, int oneHeight, int blockSpacer) {
        int height = 0;
        int i = 0;
        while (i < numPerChunk.length) {
            height += numPerChunk[i] / numOne[i] * oneHeight + blockSpacer;
            ++i;
        }
        return height;
    }

    private static void plotScale(Graphics g, int offx, int offy, int height) {
        g = g.create();
        g.setColor(Color.BLACK);
        Rectangle2D rect = g.getFontMetrics().getStringBounds("2", g);
        int w = (int)rect.getWidth();
        int h = -((int)rect.getCenterY());
        g.drawLine(offx, offy, offx, offy + height);
        g.drawString("2", offx - 2 * w, offy + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy, offx, offy);
        g.drawString("1", offx - 2 * w, (int)((double)offy + 0.5 * (double)height) + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy + (int)(0.5 * (double)height), offx, offy + (int)(0.5 * (double)height));
        g.drawString("0", offx - 2 * w, offy + height + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy + height, offx, offy + height);
    }

    public static int[] getBorders(DataSet data, int[][] minmax, int[] steps) throws Exception {
        int off = 0;
        int[] maxBords = new int[minmax.length];
        int i = 0;
        while (i < minmax.length) {
            double max = Double.NEGATIVE_INFINITY;
            int maxBord = -1;
            int j = minmax[i][0];
            while (j <= minmax[i][1] && off + j < data.getNumberOfElements()) {
                Sequence[] sub1 = new Sequence[j];
                System.arraycopy(data.getAllElements(), off, sub1, 0, sub1.length);
                Sequence[] sub2 = new Sequence[data.getNumberOfElements() - (off + j)];
                System.arraycopy(data.getAllElements(), off + j, sub2, 0, sub2.length);
                FSDAGTrainSM pwm1 = TrainableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, data.getElementLength(), 0.0);
                pwm1.train(new DataSet("", sub1));
                FSDAGTrainSM pwm2 = TrainableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, data.getElementLength(), 0.0);
                pwm2.train(new DataSet("", sub2));
                double[] weights = new double[]{(double)sub1.length / (double)(sub1.length + sub2.length), (double)sub2.length / (double)(sub1.length + sub2.length)};
                MixtureTrainSM mtsm = new MixtureTrainSM(pwm1.getLength(), new TrainableStatisticalModel[]{pwm1, pwm2}, weights, 1, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.THETA);
                double ll = 0.0;
                int k = off;
                while (k < data.getNumberOfElements()) {
                    ll += mtsm.getLogProbFor(data.getElementAt(k));
                    ++k;
                }
                if (ll > max) {
                    max = ll;
                    maxBord = j;
                }
                j += steps[i];
            }
            maxBords[i] = maxBord;
            off += maxBord;
            ++i;
        }
        return maxBords;
    }

    public static BufferedImage plotDefaultDependencyLogoToBufferedImage(DataSet data, double[] weights, int width) throws Exception {
        int[][] minmax = new int[][]{{Math.min(100, Math.max(20, data.getNumberOfElements() / 800 * 20)), Math.min(500, Math.max(20, data.getNumberOfElements() / 160 * 20))}, {Math.min(500, Math.max(25, data.getNumberOfElements() / 200 * 25)), Math.min(2000, Math.max(25, data.getNumberOfElements() / 50 * 25))}};
        int[] steps = new int[]{Math.max(20, minmax[0][0] / 100 * 20), Math.max(25, minmax[1][0] / 125 * 25)};
        int[] borders = SeqLogoPlotter.getBorders(data, minmax, steps);
        int[] rows = new int[]{20, 25, 50};
        int[] numPerChunk = new int[borders.length + 1];
        int[] numOne = new int[numPerChunk.length];
        int n = data.getNumberOfElements();
        int i = 0;
        while (i < borders.length) {
            numPerChunk[i] = borders[i];
            numOne[i] = numPerChunk[i] / rows[i];
            n -= borders[i];
            ++i;
        }
        int omit = n % rows[rows.length - 1];
        numPerChunk[numPerChunk.length - 1] = n -= omit;
        numOne[numOne.length - 1] = numPerChunk[numPerChunk.length - 1] / rows[rows.length - 1];
        System.out.println("BORDERS: ");
        System.out.println(data.getNumberOfElements());
        System.out.println(Arrays.toString(minmax[0]));
        System.out.println(Arrays.toString(minmax[1]));
        System.out.println(Arrays.toString(rows));
        System.out.println(Arrays.toString(numPerChunk));
        System.out.println(Arrays.toString(numOne));
        int oneHeight = (int)Math.round((double)width / 150.0);
        int logoHeight = (int)Math.round((double)width / 10.0);
        int height = SeqLogoPlotter.getHeightForDependencyLogo(data.getElementLength(), data.getNumberOfElements(), numOne, numPerChunk, oneHeight, width, logoHeight);
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D graph = (Graphics2D)img.getGraphics();
        graph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotDependencyLogo(data, null, weights, graph, width, 0, 0, numOne, numPerChunk, oneHeight, logoHeight, true, 3, false, false, false);
        return img;
    }

    public static int plotDependencyLogo(DataSet seqs, double[][] classProbs, double[] weights, Graphics2D graph, int width, int offx, int offy, int[] numOne, int[] numPerChunk, int oneHeight, int logoHeight, boolean highlightMaxDeps, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, boolean scaleByDeps) throws Exception {
        int h;
        int j;
        int totalWidth = width;
        graph = (Graphics2D)graph.create();
        int leftMargin = width / 15;
        int tempWidth = width - 2 * leftMargin;
        String[] labels = new String[seqs.getElementLength()];
        int i = 0;
        while (i < labels.length) {
            labels[i] = String.valueOf(i + 1);
            ++i;
        }
        int partWidth = (int)Math.floor((double)tempWidth / (double)(labels.length + 2));
        Font font = new Font(graph.getFont().getName(), 1, width / 40);
        graph.setFont(font);
        int fac = 40;
        if (graph.getFontMetrics().getStringBounds(labels[labels.length - 1], graph).getWidth() > (double)partWidth * 0.8) {
            fac = (int)((double)fac * (graph.getFontMetrics().getStringBounds(labels[labels.length - 1], graph).getWidth() / ((double)partWidth * 0.8)));
            font = new Font(graph.getFont().getName(), 1, width / fac);
            graph.setFont(font);
        }
        graph.setStroke(new BasicStroke((float)width / 300.0f));
        double symHeight = graph.getFontMetrics().getStringBounds(labels[labels.length - 1], graph).getHeight();
        int topMargin = width / 5;
        graph.setColor(Color.WHITE);
        graph.fillRect(offx, offy, width, SeqLogoPlotter.getHeightForColorLogo(seqs.getNumberOfElements(), numOne, numPerChunk, oneHeight, logoHeight) + topMargin * 2);
        double labWidth = graph.getFontMetrics().getStringBounds("0.000E000", graph).getWidth();
        Sequence[] seqs2 = seqs.getAllElements();
        int[] heights = SeqLogoPlotter.plotColorLogo(seqs2, weights, graph, width -= 2 * leftMargin, offx + leftMargin, offy + topMargin, numOne, numPerChunk, oneHeight, logoHeight, numBestForSorting, sortGlobally, sortByWeights);
        seqs = new DataSet("", seqs2);
        NumberFormat nf = DecimalFormat.getInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(3);
        int minFrac = 0;
        int off = 0;
        int i2 = 0;
        while (i2 < numPerChunk.length) {
            int idx;
            String temp;
            double start = weights[off];
            double end = weights[off + numPerChunk[i2] - 1];
            int len = 0;
            if (Math.abs(start) >= 0.01) {
                temp = nf.format(start);
                idx = temp.indexOf(".");
                len = temp.length() - idx - 1;
                if (len > minFrac) {
                    minFrac = len;
                }
            }
            if (Math.abs(end) >= 0.01) {
                temp = nf.format(end);
                idx = temp.indexOf(".");
                len = temp.length() - idx - 1;
                if (len > minFrac) {
                    minFrac = len;
                }
            }
            off += numPerChunk[i2];
            ++i2;
        }
        nf.setMinimumFractionDigits(minFrac);
        DecimalFormat dec = new DecimalFormat("0.###E0");
        String[][] startEndValues = new String[numPerChunk.length][2];
        off = 0;
        int i3 = 0;
        while (i3 < numPerChunk.length) {
            double start = weights[off];
            double end = weights[off + numPerChunk[i3] - 1];
            startEndValues[i3][0] = start != 0.0 && Math.abs(start) < 0.01 ? dec.format(start) : nf.format(start);
            startEndValues[i3][1] = end != 0.0 && Math.abs(end) < 0.01 ? dec.format(end) : nf.format(end);
            off += numPerChunk[i3];
            ++i3;
        }
        graph.setColor(Color.BLACK);
        off = topMargin;
        int offX = leftMargin + (labels.length + 1) * partWidth;
        int i4 = 0;
        while (i4 < heights.length) {
            int alt = totalWidth - (int)(graph.getFontMetrics().getStringBounds(startEndValues[i4][0], graph).getWidth() * 1.1);
            if (alt < offX) {
                offX = alt;
            }
            ++i4;
        }
        int alt = totalWidth - (int)(graph.getFontMetrics().getStringBounds(startEndValues[startEndValues.length - 1][1], graph).getWidth() * 1.1);
        if (alt < offX) {
            offX = alt;
        }
        int i5 = 0;
        while (i5 < heights.length) {
            graph.drawString(startEndValues[i5][0], offX, off - (int)symHeight / 2);
            off = heights[i5];
            ++i5;
        }
        graph.drawString(startEndValues[startEndValues.length - 1][1], offX, off - logoHeight + (int)symHeight);
        off = topMargin;
        i5 = 0;
        while (i5 < heights.length) {
            String lab = String.valueOf(numPerChunk[i5]);
            Rectangle2D rect = graph.getFontMetrics().getStringBounds(lab, graph);
            AffineTransform back = graph.getTransform();
            graph.rotate(-1.5707963267948966);
            graph.drawString(lab, -((int)((double)((heights[i5] + off - logoHeight) / 2) + rect.getCenterX())), (int)((double)leftMargin - rect.getHeight() / 2.0));
            graph.setTransform(back);
            off = heights[i5];
            ++i5;
        }
        off = partWidth / 2;
        graph.setColor(Color.BLACK);
        i5 = 0;
        while (i5 < labels.length) {
            int c = (int)graph.getFontMetrics().getStringBounds(labels[i5], graph).getCenterX();
            graph.drawString(labels[i5], offx + leftMargin + off + i5 * partWidth - c, offy + (int)((double)topMargin - symHeight / 2.0));
            graph.drawString(labels[i5], offx + leftMargin + off + i5 * partWidth - c, heights[heights.length - 1] + (int)(symHeight * 2.5));
            graph.drawLine(offx + leftMargin + off + i5 * partWidth, heights[heights.length - 1] + (int)symHeight, offx + leftMargin + off + i5 * partWidth, heights[heights.length - 1] + (int)(1.5 * symHeight));
            ++i5;
        }
        graph.drawLine(offx + leftMargin + off, heights[heights.length - 1] + (int)symHeight, offx + leftMargin + off + (labels.length - 1) * partWidth, heights[heights.length - 1] + (int)symHeight);
        double[][] deps = null;
        if (classProbs == null || classProbs.length == 1) {
            deps = SeqLogoPlotter.getDeps(seqs2, classProbs == null ? null : classProbs[0]);
        } else {
            BTExplainingAwayResidual ear = new BTExplainingAwayResidual(new double[]{0.0, 0.0});
            deps = ear.getEAR(new DataSet("", seqs2), new DataSet("", seqs2), classProbs[0], classProbs[1], seqs2[0].getLength());
        }
        boolean[][] isMax = new boolean[deps.length][deps.length];
        if (highlightMaxDeps) {
            int i6 = 0;
            while (i6 < deps.length) {
                double max = ToolBox.max(deps[i6]);
                int j2 = 0;
                while (j2 < deps[i6].length) {
                    if (deps[i6][j2] == max) {
                        isMax[i6][j2] = true;
                    }
                    ++j2;
                }
                ++i6;
            }
            i6 = 1;
            while (i6 < deps.length) {
                int j3 = 0;
                while (j3 < i6) {
                    isMax[i6][j3] = isMax[i6][j3] || isMax[j3][i6];
                    isMax[j3][i6] = isMax[i6][j3];
                    ++j3;
                }
                ++i6;
            }
        }
        double[][] ps = new double[deps.length][deps[0].length];
        double f = (double)(deps.length * (deps.length - 1)) / 2.0;
        double maxp = -Math.log10(1.0E-300 / f);
        double minp = -Math.log10(0.01 / f);
        int i7 = 1;
        while (i7 < deps.length) {
            j = 0;
            while (j < i7) {
                double p = -Math.log10(Gamma.incompleteGammaComplement(4.5, deps[i7][j] * 2.0 / 2.0));
                if (p > maxp) {
                    p = maxp;
                }
                ps[i7][j] = p;
                ++j;
            }
            ++i7;
        }
        if (scaleByDeps) {
            minp = 0.0;
            maxp = 0.0;
            i7 = 1;
            while (i7 < deps.length) {
                j = 0;
                while (j < i7) {
                    ps[i7][j] = deps[i7][j] / (classProbs == null ? (double)seqs2.length : ToolBox.sum(classProbs[0]));
                    if (ps[i7][j] > maxp) {
                        maxp = ps[i7][j];
                    }
                    ++j;
                }
                ++i7;
            }
        }
        graph.setColor(Color.BLACK);
        i7 = 1;
        while (i7 < deps.length) {
            j = 0;
            while (j < i7) {
                if (ps[i7][j] > minp && !isMax[i7][j]) {
                    Color c = new Color(0.0f, 0.0f, 0.0f, (float)((ps[i7][j] - minp) / (maxp - minp)));
                    graph.setColor(c);
                    h = (int)(((double)topMargin - symHeight * 1.5) * (double)(i7 - j) / (double)deps.length);
                    graph.drawArc(offx + leftMargin + off + j * partWidth, offy + (int)((double)topMargin - symHeight * 1.5) - h, (i7 - j) * partWidth, h * 2, 0, 180);
                }
                ++j;
            }
            ++i7;
        }
        i7 = 1;
        while (i7 < deps.length) {
            j = 0;
            while (j < i7) {
                if (ps[i7][j] > minp && isMax[i7][j]) {
                    Color c = new Color(1.0f, 0.0f, 0.0f, (float)((ps[i7][j] - minp) / (maxp - minp)));
                    graph.setColor(c);
                    h = (int)(((double)topMargin - symHeight * 1.5) * (double)(i7 - j) / (double)deps.length);
                    graph.drawArc(offx + leftMargin + off + j * partWidth, offy + (int)((double)topMargin - symHeight * 1.5) - h, (i7 - j) * partWidth, h * 2, 0, 180);
                }
                ++j;
            }
            ++i7;
        }
        off = 0;
        i7 = 0;
        while (i7 < heights.length) {
            double[][] pwm = PFMComparator.getPWM(seqs, off, off + numPerChunk[i7]);
            off += numPerChunk[i7];
            int j4 = 0;
            while (j4 < pwm.length) {
                SeqLogoPlotter.plotLogo(graph, (double)(offx + leftMargin + j4 * partWidth), heights[i7], partWidth, logoHeight, pwm[j4]);
                ++j4;
            }
            SeqLogoPlotter.plotScale(graph, offx + leftMargin, heights[i7] - logoHeight, logoHeight - 1);
            ++i7;
        }
        return heights[heights.length - 1];
    }

    public static int plotColorLogo(Sequence[] seqs, double[] weights, Graphics2D graph, int width, int offx, int offy, int numOne, int numPerChunk, int oneHeight, int blockSpacer, int numBestForSorting, boolean sortGlobally, boolean sortByWeights) throws Exception {
        int[] nums = new int[(int)Math.ceil((double)seqs.length / (double)numPerChunk)];
        int[] oneNums = new int[nums.length];
        int i = 0;
        int k = 0;
        while (i < seqs.length) {
            int numCurr;
            nums[k] = i + numPerChunk <= seqs.length ? numPerChunk : (numCurr = (int)Math.floor((seqs.length - i) / numOne) * numOne);
            oneNums[k] = numOne;
            i += numPerChunk;
            ++k;
        }
        int[] offs = SeqLogoPlotter.plotColorLogo(seqs, weights, graph, width, offx, offy, oneNums, nums, oneHeight, blockSpacer, numBestForSorting, sortGlobally, sortByWeights);
        return offs[offs.length - 1];
    }

    public static int[] plotColorLogo(Sequence[] seqs, double[] weights, Graphics2D graph, int width, int offx, int offy, int[] numOne, int[] numPerChunk, int oneHeight, int blockSpacer, int numBestForSorting, boolean sortGlobally, boolean sortByWeights) throws Exception {
        int i;
        int[] offs = new int[numPerChunk.length];
        if (weights == null) {
            weights = new double[seqs.length];
            Arrays.fill(weights, 1.0);
        } else {
            Object[] els = new ComparableElement[seqs.length];
            i = 0;
            while (i < els.length) {
                els[i] = new ComparableElement<Sequence, Double>(seqs[i], weights[i]);
                ++i;
            }
            Arrays.sort(els);
            i = 0;
            while (i < els.length) {
                seqs[i] = (Sequence)((ComparableElement)els[els.length - 1 - i]).getElement();
                weights[i] = (Double)((ComparableElement)els[els.length - 1 - i]).getWeight();
                ++i;
            }
        }
        int off = 0;
        i = 0;
        while (i < numPerChunk.length) {
            SeqLogoPlotter.plotColorLogo(graph, seqs, weights, off, off + numPerChunk[i], width, offx, offy, numOne[i], oneHeight, numBestForSorting, sortGlobally, sortByWeights);
            Color back = graph.getColor();
            graph.setColor(Color.WHITE);
            graph.fillRect(offx, (offy += numPerChunk[i] / numOne[i] * oneHeight + blockSpacer) - blockSpacer, width, blockSpacer);
            graph.setColor(back);
            off += numPerChunk[i];
            offs[i] = offy;
            ++i;
        }
        return offs;
    }

    public static int plotColorLogo(Graphics2D graph, Sequence[] seqs, double[] weights, int start, int end, int width, int offx, int offy, int numOne, int oneHeight, int numBestForSorting, boolean sortGlobally, boolean sortByWeights) throws Exception {
        if ((end - start) % numOne != 0) {
            System.out.println(String.valueOf(start) + " " + end + " " + numOne);
            throw new Exception();
        }
        double mi = ToolBox.min(weights);
        double ma = ToolBox.max(weights);
        if (ma == (mi -= (ma - mi) * 1.0E-6)) {
            mi = 0.0;
        }
        graph = (Graphics2D)graph.create();
        Sequence[] temp = new Sequence[end - start];
        System.arraycopy(seqs, start, temp, 0, end - start);
        Pair[] sortTemp = new Pair[end - start];
        int i = 0;
        while (i < sortTemp.length) {
            sortTemp[i] = new Pair<Sequence, Double>(seqs[start + i], weights[start + i]);
            ++i;
        }
        if (sortGlobally) {
            final int[] ord = SeqLogoPlotter.getOrder(temp, numBestForSorting, 6);
            final double[][] fullPwm = PFMComparator.getPFM(new DataSet("", temp));
            Comparator<Pair<Sequence, Double>> comp = new Comparator<Pair<Sequence, Double>>(){

                @Override
                public int compare(Pair<Sequence, Double> o1, Pair<Sequence, Double> o2) {
                    int i = 0;
                    while (i < ord.length) {
                        double sym2;
                        double sym1 = fullPwm[ord[i]][o1.getFirstElement().discreteVal(ord[i])];
                        if (sym1 > (sym2 = fullPwm[ord[i]][o2.getFirstElement().discreteVal(ord[i])])) {
                            return -1;
                        }
                        if (sym2 > sym1) {
                            return 1;
                        }
                        ++i;
                    }
                    return 0;
                }
            };
            Arrays.sort(sortTemp, comp);
        } else {
            double[][] fullPFM = PFMComparator.getPFM(new DataSet("", temp));
            SeqLogoPlotter.sortLocal2(sortTemp, numBestForSorting, 6, new boolean[temp[0].getLength()], numOne, sortByWeights, fullPFM);
        }
        double[] tempW = new double[temp.length];
        int i2 = 0;
        while (i2 < temp.length) {
            temp[i2] = (Sequence)sortTemp[i2].getFirstElement();
            tempW[i2] = (Double)sortTemp[i2].getSecondElement();
            ++i2;
        }
        double[][] pwm = new double[seqs[0].getLength()][4];
        int i3 = 0;
        while (i3 < temp.length) {
            int j = 0;
            while (j < pwm.length) {
                Arrays.fill(pwm[j], 0.0);
                int k = 0;
                while (k < numOne && i3 + k < temp.length) {
                    double[] dArray = pwm[j];
                    int n = temp[i3 + k].discreteVal(j);
                    dArray[n] = dArray[n] + 1.0;
                    ++k;
                }
                Normalisation.sumNormalisation(pwm[j]);
                ++j;
            }
            SeqLogoPlotter.plotColorLogo(graph, pwm, (ToolBox.mean(i3, i3 + numOne, tempW) - mi) / (ma - mi), true, true, oneHeight, width, offx, offy);
            offy += oneHeight;
            i3 += numOne;
        }
        return offx;
    }

    private static Pair<Sequence, Double>[] sortLocal3(Pair<Sequence, Double>[] sortTemp, int numBestForSorting, int maxNum, boolean[] exclude, int minElements, boolean sortByWeights, double[] prevInf) {
        if (maxNum == 0 || sortTemp.length < minElements * 4) {
            return sortTemp;
        }
        Sequence[] temp = new Sequence[sortTemp.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = sortTemp[i].getFirstElement();
            ++i;
        }
        Pair<double[], double[][]> pair = SeqLogoPlotter.getInformation(temp, numBestForSorting, exclude);
        double[] inf = pair.getFirstElement();
        int best = ToolBox.getMaxIndex(inf);
        int bestPrev = ToolBox.getMaxIndex(prevInf);
        if (inf[best] / (double)temp.length / (double)numBestForSorting < 0.1 && (ToolBox.sum(exclude) == 0 || prevInf[bestPrev] / (double)temp.length / (double)ToolBox.sum(exclude) < 0.1)) {
            return sortTemp;
        }
        if (inf[best] / (double)temp.length / (double)numBestForSorting < 0.1) {
            best = bestPrev;
        }
        double[] mis = pair.getSecondElement()[best];
        exclude[best] = true;
        LinkedList[] partSort = new LinkedList[4];
        int i2 = 0;
        while (i2 < partSort.length) {
            partSort[i2] = new LinkedList();
            ++i2;
        }
        double[] freq = new double[4];
        double[] ws = new double[4];
        int i3 = 0;
        while (i3 < temp.length) {
            Sequence seq = temp[i3];
            int idx = seq.discreteVal(best);
            partSort[idx].add(sortTemp[i3]);
            int n = idx;
            freq[n] = freq[n] + 1.0;
            int n2 = idx;
            ws[n2] = ws[n2] + sortTemp[i3].getSecondElement();
            ++i3;
        }
        if (sortByWeights) {
            i3 = 0;
            while (i3 < freq.length) {
                freq[i3] = ws[i3] / freq[i3];
                ++i3;
            }
        }
        int[] ord = ToolBox.order(freq, true);
        int off = 0;
        int i4 = 0;
        while (i4 < ord.length) {
            if (freq[ord[i4]] > 0.0) {
                double[] tempPrev = (double[])prevInf.clone();
                int j = 0;
                while (j < tempPrev.length) {
                    if (exclude[j]) {
                        tempPrev[j] = 0.0;
                    } else {
                        int n = j;
                        tempPrev[n] = tempPrev[n] + mis[j];
                    }
                    ++j;
                }
                Pair<Sequence, Double>[] part = SeqLogoPlotter.sortLocal3(partSort[ord[i4]].toArray(new Pair[0]), numBestForSorting, maxNum - 1, (boolean[])exclude.clone(), minElements, sortByWeights, tempPrev);
                int j2 = 0;
                while (j2 < part.length) {
                    sortTemp[off] = part[j2];
                    ++j2;
                    ++off;
                }
            }
            ++i4;
        }
        return sortTemp;
    }

    private static Pair<Sequence, Double>[] sortLocal2(Pair<Sequence, Double>[] sortTemp, int numBestForSorting, int maxNum, boolean[] exclude, int minElements, boolean sortByWeights, double[][] fullPFM) throws Exception {
        System.out.println("maxNum: " + maxNum);
        if (maxNum == 0 || sortTemp.length < 4 * minElements) {
            return sortTemp;
        }
        Sequence[] temp = new Sequence[sortTemp.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = sortTemp[i].getFirstElement();
            ++i;
        }
        Pair<double[], double[][]> pair = SeqLogoPlotter.getInformation(temp, numBestForSorting, exclude);
        double[] inf = pair.getFirstElement();
        int best = ToolBox.getMaxIndex(inf);
        System.out.println(Arrays.toString(exclude));
        System.out.println(String.valueOf(best) + " " + inf[best] + " " + temp.length + " " + numBestForSorting);
        if (inf[best] / (double)temp.length / (double)numBestForSorting < 0.05) {
            LinkedList<Sequence> seqTemp = new LinkedList<Sequence>();
            int i2 = 0;
            while (i2 < sortTemp.length) {
                seqTemp.add(sortTemp[i2].getFirstElement());
                ++i2;
            }
            final double[][] partPFM = PFMComparator.getPFM(new DataSet("", seqTemp));
            double[] kls = SeqLogoPlotter.getKLDivergence(partPFM, (double[][])ArrayHandler.clone((Cloneable[])fullPFM));
            System.out.println("kls: " + Arrays.toString(kls));
            int[] o = ToolBox.order(kls, true);
            IntList orderPos = new IntList();
            int i3 = 0;
            int k = 0;
            while (i3 < o.length && k < maxNum) {
                if (!exclude[o[i3]]) {
                    if (!(kls[o[i3]] > 0.1)) break;
                    orderPos.add(o[i3]);
                    ++k;
                }
                ++i3;
            }
            if (orderPos.length() == 0) {
                return sortTemp;
            }
            final int[] ord = orderPos.toArray();
            System.out.println(Arrays.toString(ord));
            Comparator<Pair<Sequence, Double>> comp = new Comparator<Pair<Sequence, Double>>(){

                @Override
                public int compare(Pair<Sequence, Double> o1, Pair<Sequence, Double> o2) {
                    int i = 0;
                    while (i < ord.length) {
                        double sym2;
                        double sym1 = partPFM[ord[i]][o1.getFirstElement().discreteVal(ord[i])];
                        if (sym1 > (sym2 = partPFM[ord[i]][o2.getFirstElement().discreteVal(ord[i])])) {
                            return -1;
                        }
                        if (sym2 > sym1) {
                            return 1;
                        }
                        ++i;
                    }
                    return 0;
                }
            };
            Arrays.sort(sortTemp, comp);
            return sortTemp;
        }
        double[] mis = pair.getSecondElement()[best];
        exclude[best] = true;
        LinkedList[] partSort = new LinkedList[4];
        int i4 = 0;
        while (i4 < partSort.length) {
            partSort[i4] = new LinkedList();
            ++i4;
        }
        double[] freq = new double[4];
        double[] ws = new double[4];
        int i5 = 0;
        while (i5 < temp.length) {
            Sequence seq = temp[i5];
            int idx = seq.discreteVal(best);
            partSort[idx].add(sortTemp[i5]);
            int n = idx;
            freq[n] = freq[n] + 1.0;
            int n2 = idx;
            ws[n2] = ws[n2] + sortTemp[i5].getSecondElement();
            ++i5;
        }
        if (sortByWeights) {
            i5 = 0;
            while (i5 < freq.length) {
                freq[i5] = ws[i5] / freq[i5];
                ++i5;
            }
        }
        int[] ord = ToolBox.order(freq, true);
        int off = 0;
        int i6 = 0;
        while (i6 < ord.length) {
            if (freq[ord[i6]] > 0.0) {
                Pair<Sequence, Double>[] part = SeqLogoPlotter.sortLocal2(partSort[ord[i6]].toArray(new Pair[0]), numBestForSorting, maxNum - 1, (boolean[])exclude.clone(), minElements, sortByWeights, fullPFM);
                int j = 0;
                while (j < part.length) {
                    sortTemp[off] = part[j];
                    ++j;
                    ++off;
                }
            }
            ++i6;
        }
        return sortTemp;
    }

    private static double[] getKLDivergence(double[][] partPFM, double[][] fullPFM) {
        double full = ToolBox.sum(fullPFM[0]);
        double part = ToolBox.sum(partPFM[0]);
        double[] kls = new double[partPFM.length];
        int i = 0;
        while (i < fullPFM.length) {
            Normalisation.sumNormalisation(fullPFM[i]);
            Normalisation.sumNormalisation(partPFM[i]);
            int j = 0;
            while (j < fullPFM[i].length) {
                if (partPFM[i][j] > 0.0) {
                    int n = i;
                    kls[n] = kls[n] + partPFM[i][j] * Math.log(partPFM[i][j] / fullPFM[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return kls;
    }

    public static int[] getOrder(Sequence[] temp, int numBestForSorting, int numSortingPositions) {
        IntList sortPos = new IntList();
        boolean[] exclude = new boolean[temp[0].getLength()];
        double[] inf = SeqLogoPlotter.getInformation(temp, numBestForSorting, exclude).getFirstElement();
        int best = ToolBox.getMaxIndex(inf);
        exclude[best] = true;
        if (inf[best] / (double)temp.length / (double)numBestForSorting > 0.1) {
            sortPos.add(best);
        }
        int i = 1;
        while (i < numSortingPositions) {
            inf = SeqLogoPlotter.getInformation(temp, numBestForSorting, exclude).getFirstElement();
            best = ToolBox.getMaxIndex(inf);
            exclude[best] = true;
            if (inf[best] / (double)temp.length / (double)numBestForSorting > 0.1) {
                sortPos.add(best);
            }
            ++i;
        }
        return sortPos.toArray();
    }

    public static LinkedList<Sequence>[] getPartitions(Sequence[] temp, IntList sortPos) {
        LinkedList[] lists = new LinkedList[(int)Math.pow(4.0, sortPos.length())];
        int i = 0;
        while (i < lists.length) {
            lists[i] = new LinkedList();
            ++i;
        }
        int[] pows = new int[sortPos.length()];
        int i2 = 0;
        while (i2 < pows.length) {
            pows[i2] = (int)Math.pow(4.0, i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < temp.length) {
            int idx = 0;
            int j = 0;
            while (j < sortPos.length()) {
                idx += pows[j] * temp[i2].discreteVal(sortPos.get(j));
                ++j;
            }
            lists[idx].add(temp[i2]);
            ++i2;
        }
        return lists;
    }

    public static Pair<double[], double[][]> getInformation(Sequence[] seqs, int numBest, boolean[] exclude) {
        double[][] mis = SeqLogoPlotter.getDeps(seqs, null);
        double[] vals = new double[seqs[0].getLength()];
        int i = 0;
        while (i < vals.length) {
            int[] o = ToolBox.order(mis[i], true);
            vals[i] = 0.0;
            if (exclude == null || !exclude[i]) {
                int j = 0;
                int k = 0;
                while (k < numBest && j < mis[i].length) {
                    if (exclude == null || !exclude[o[j]]) {
                        int n = i;
                        vals[n] = vals[n] + mis[i][o[j]];
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return new Pair<double[], double[][]>(vals, mis);
    }

    public static void plotColorLogo(Graphics2D graph, double[][] pwm, double weight, boolean mix, boolean icscale, int height, int width, int offx, int offy) {
        graph = (Graphics2D)graph.create();
        Color back = graph.getColor();
        graph.setColor(Color.WHITE);
        graph.fillRect(offx, offy, width, height);
        graph.setColor(back);
        int partWidth = (int)Math.floor((double)width / (double)(pwm.length + 2));
        double[] temp = new double[4];
        int i = 0;
        while (i < pwm.length) {
            if (mix) {
                Color c = SeqLogoPlotter.getColor(pwm[i], icscale ? (float)Math.sqrt(SeqLogoPlotter.getICScale(pwm[i])) : 1.0f);
                back = graph.getColor();
                graph.setColor(c);
                graph.fillRect(offx, offy, partWidth, height);
                graph.setColor(back);
            } else {
                int off2 = 0;
                float ic = icscale ? (float)Math.sqrt(SeqLogoPlotter.getICScale(pwm[i])) : 1.0f;
                int j = 0;
                while (j < pwm[i].length) {
                    Arrays.fill(temp, 0.0);
                    temp[j] = 1.0;
                    Color c = SeqLogoPlotter.getColor(temp, ic);
                    back = graph.getColor();
                    graph.setColor(c);
                    int partHeight = (int)Math.round((double)height * pwm[i][j]);
                    graph.fillRect(offx, offy + off2, partWidth, j < pwm[i].length - 1 ? partHeight : height - off2);
                    off2 += partHeight;
                    graph.setColor(back);
                    ++j;
                }
            }
            offx += partWidth;
            ++i;
        }
        Color c = new Color(1.0f, (float)weight, 0.0f);
        back = graph.getColor();
        graph.setColor(c);
        graph.fillRect(offx += partWidth, offy, partWidth, height);
        graph.setColor(back);
    }

    public static void plotLogoToPNG(String path, int height, double[][] ps) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotLogo(g, height, ps);
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotLogoToBufferedImage(int height, double[][] ps) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter.plotLogo(g, height, ps);
        return pair.getFirstElement();
    }

    public static Pair<BufferedImage, Graphics2D> getBufferedImageAndGraphics(int height, double[][] ps) {
        int w = SeqLogoPlotter.getWidth(height, ps);
        BufferedImage img = new BufferedImage(w, height, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        return new Pair<BufferedImage, Graphics2D>(img, g);
    }

    public static void plotLogo(Graphics2D g, int h, double[][] ps) {
        SeqLogoPlotter.plotLogo(g, h, ps, null, "Position", "bits");
    }

    public static void plotLogo(Graphics2D g, int height, double[][] ps, String[] labels, String labX, String labY) {
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotLogo(g, w, height, ps, labels, labX, labY);
    }

    public static int getWidth(int height, double[][] ps) {
        return (int)((double)height / 6.0 * ((double)ps.length + 1.5));
    }

    public static int getHeight(int width, double[][] ps) {
        return (int)((double)width * 6.0 / ((double)ps.length + 1.5));
    }

    public static void plotLogo(Graphics2D g, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        SeqLogoPlotter.plotLogo(g, 0, h, w, h, ps, labels, labX, labY);
    }

    public static void plotLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        Rectangle2D rect;
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 10);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            int i = 0;
            while (i < ps.length) {
                labels[i] = String.valueOf(i + 1);
                ++i;
            }
        }
        double wl = (double)h * 0.4;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = wl * 0.9;
        double h2 = (double)h * 0.65;
        double y2 = (double)y - (double)h * 0.3;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke((float)h / 100.0f));
        g.drawLine(x + (int)x2, (int)(y2 + 0.05 * (double)h), x + (int)(x2 + w2 * (double)ps.length), (int)(y2 + 0.05 * (double)h));
        g.drawLine(x + (int)(x2 * 0.94), (int)y2, x + (int)(x2 * 0.94), (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        int i = 0;
        while (i <= 4) {
            g.drawLine(x + (int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), x + (int)(x2 * 0.94), (int)(y2 - (double)i * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.drawString(labs[i], x + (int)(x2 * 0.6 - rect.getWidth()), (int)(y2 - (double)i * h2 / 4.0 - rect.getCenterY()));
            ++i;
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getWidth() / 2.0));
        g.setTransform(back);
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, x + (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.2 * rect.getHeight()));
        int i2 = 0;
        while (i2 < ps.length) {
            SeqLogoPlotter.plotLogo(g, (double)x + x2, y2, w2, h2, ps[i2]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i2], g);
            g.drawString(labels[i2], (float)x + (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 1.5 * rect.getHeight()));
            x2 += w2;
            ++i2;
        }
    }

    public static void plotTALgetterLogoToPNG(String path, int height, double[][] ps, double[] imp, String[] lab) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotTALgetterLogoToBufferedImage(int height, double[][] ps, double[] imp, String[] lab) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter.getWidth(height, ps);
        SeqLogoPlotter.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        return pair.getFirstElement();
    }

    public static void plotTALgetterLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, double[] imp, String[] labels, String labX, String labY, String labY2) {
        Rectangle2D rect;
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 17);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            int i = 0;
            while (i < ps.length) {
                labels[i] = String.valueOf(i + 1);
                ++i;
            }
        }
        double wl = (double)h * 0.5;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = (double)x + wl * 0.45;
        double h2 = (double)h * 0.7;
        double y2 = (double)y * 0.75;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(h / 400 + 1));
        g.drawLine((int)x2, (int)(y2 * 1.04) + 1, (int)(x2 + w2 * (double)ps.length), (int)(y2 * 1.04) + 1);
        g.drawLine((int)(x2 * 0.94) - 1, (int)y2, (int)(x2 * 0.94) - 1, (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        int i = 0;
        while (i <= 4) {
            g.drawLine((int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), (int)(x2 * 0.94) - 1, (int)(y2 - (double)i * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.drawString(labs[i], (int)(x2 * 0.6 - rect.getWidth() - 2.0), (int)(y2 - (double)i * h2 / 4.0 - rect.getCenterY()));
            ++i;
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getHeight()));
        g.setTransform(back);
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.3 * rect.getHeight()));
        int i2 = 0;
        while (i2 < ps.length) {
            SeqLogoPlotter.plotLogo(g, x2, y2, w2, h2, ps[i2]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i2], g);
            g.drawString(labels[i2], (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 2.0 * rect.getHeight()));
            x2 += w2;
            ++i2;
        }
        g.drawLine((int)(x2 + w2 * 0.1) + 1, (int)y2, (int)(x2 + w2 * 0.1) + 1, (int)(y2 - h2));
        labs = new String[]{"0", "0.5", "1"};
        Rectangle2D rect2 = g.getFontMetrics().getStringBounds("0.5", g);
        int i3 = 0;
        while (i3 <= 2) {
            g.drawLine((int)(x2 + w2 * 0.34) + 2, (int)(y2 - (double)i3 * h2 / 2.0), (int)(x2 + w2 * 0.1) + 1, (int)(y2 - (double)i3 * h2 / 2.0));
            g.drawString(labs[i3], (int)(x2 + w2 * 0.5 + 2.0), (int)(y2 - (double)i3 * h2 / 2.0 - rect.getCenterY()));
            ++i3;
        }
        back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY2, g);
        g.drawString(labY2, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)w - rect.getHeight() / 2.0));
        g.setTransform(back);
        x2 = (double)x + wl * 0.45 + 2.0 * w2;
        g.setColor(Color.GRAY);
        i3 = 1;
        while (i3 < imp.length) {
            g.drawLine((int)(x2 - w2 / 2.0 + w2 / 20.0), (int)(y2 - h2 * imp[i3 - 1] + w2 / 20.0), (int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i3] + w2 / 20.0));
            x2 += w2;
            ++i3;
        }
        x2 = (double)x + wl * 0.45 + w2;
        g.setColor(Color.BLUE);
        i3 = 0;
        while (i3 < imp.length) {
            g.fillRect((int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i3]), (int)(w2 / 10.0), (int)(w2 / 10.0));
            x2 += w2;
            ++i3;
        }
    }

    protected static void plotLogo(Graphics2D g, double x, double y, double w, double h, double[] p) {
        double ic = SeqLogoPlotter.getICScale(p);
        h *= ic;
        double[] mp = (double[])p.clone();
        int i = 0;
        while (i < mp.length) {
            int n = i++;
            mp[n] = mp[n] * -1.0;
        }
        int[] r = ToolBox.rank(mp, false);
        int[] order = new int[r.length];
        int i2 = 0;
        while (i2 < r.length) {
            order[r[i2]] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < order.length) {
            double curr = p[order[i2]];
            if (order[i2] == 0) {
                g.setColor(Color.GREEN);
                g.fill(SeqLogoPlotter.getA(x, y, w, h * curr));
            } else if (order[i2] == 1) {
                g.setColor(Color.BLUE);
                g.fill(SeqLogoPlotter.getC(x, y, w, h * curr));
            } else if (order[i2] == 2) {
                g.setColor(Color.ORANGE);
                g.fill(SeqLogoPlotter.getG(x, y, w, h * curr));
            } else {
                g.setColor(Color.RED);
                g.fill(SeqLogoPlotter.getT(x, y, w, h * curr));
            }
            y -= h * curr;
            ++i2;
        }
    }

    public static double getICScale(double[] p) {
        double ic = Math.log(4.0) / Math.log(2.0);
        int i = 0;
        while (i < p.length) {
            if (p[i] > 0.0) {
                ic += p[i] * Math.log(p[i]) / Math.log(2.0);
            }
            ++i;
        }
        return ic /= 2.0;
    }

    private static Area getC(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        AffineTransform t = new AffineTransform();
        t.scale(0.011363636363636364, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getT(double x, double y, double w, double h) {
        Rectangle2D.Double s = new Rectangle2D.Double(37.5, -100.0, 15.0, 100.0);
        Area a1 = new Area(s);
        Rectangle2D.Double s2 = new Rectangle2D.Double(0.0, -100.0, 90.0, 15.0);
        Area a2 = new Area(s2);
        a1.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getG(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        Rectangle2D.Double s4 = new Rectangle2D.Double(55.0, -40.0, 35.0, 15.0);
        Area a4 = new Area(s4);
        a1.add(a4);
        Rectangle2D.Double s5 = new Rectangle2D.Double(80.0, -40.0, 10.0, 40.0);
        Area a5 = new Area(s5);
        a1.add(a5);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getA(double x, double y, double w, double h) {
        int[] nArray = new int[9];
        nArray[1] = 40;
        nArray[2] = 50;
        nArray[3] = 90;
        nArray[4] = 75;
        nArray[5] = 45;
        nArray[6] = 45;
        nArray[7] = 15;
        int[] nArray2 = new int[9];
        nArray2[1] = -100;
        nArray2[2] = -100;
        nArray2[5] = -80;
        nArray2[6] = -80;
        Polygon s = new Polygon(nArray, nArray2, 9);
        Area a = new Area(s);
        Polygon s2 = new Polygon(new int[]{20, 70, 70, 20}, new int[]{-35, -35, -50, -50}, 4);
        Area a2 = new Area(s2);
        a.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a.transform(t);
        return a;
    }
}

