/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import cern.jet.stat.Gamma;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.btMeasures.BTExplainingAwayResidual;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.AbstractMixtureTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.mixture.MixtureTrainSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class SeqLogoPlotter2 {
    private static Color getColor(double[] pwm, float ic) {
        float[] a = new float[]{0.0f, 1.0f, 0.0f};
        float[] c = new float[]{0.0f, 0.0f, 1.0f};
        float[] g = Color.ORANGE.getColorComponents(null);
        float[] t = new float[]{1.0f, 0.0f, 0.0f};
        float[] nc = new float[3];
        int i = 0;
        while (i < 3) {
            nc[i] = (float)(pwm[0] * (double)a[i] + pwm[1] * (double)c[i] + pwm[2] * (double)g[i] + pwm[3] * (double)t[i]);
            ++i;
        }
        return new Color(nc[0], nc[1], nc[2], ic);
    }

    public static double[][] getDeps(Sequence[] seqs, double[] w) {
        double[][][][] counts = new double[seqs[0].getLength()][seqs[0].getLength()][4][4];
        double sum = 0.0;
        int i = 0;
        while (i < seqs.length) {
            double weight = w == null ? 1.0 : w[i];
            sum += weight;
            int k = 0;
            while (k < seqs[i].getLength()) {
                int l = 0;
                while (l < seqs[i].getLength()) {
                    double[] dArray = counts[k][l][seqs[i].discreteVal(k)];
                    int n = seqs[i].discreteVal(l);
                    dArray[n] = dArray[n] + weight;
                    ++l;
                }
                ++k;
            }
            ++i;
        }
        double[][] mis = new double[seqs[0].getLength()][seqs[0].getLength()];
        int k = 1;
        while (k < seqs[0].getLength()) {
            int l = 0;
            while (l < k) {
                double mi = 0.0;
                int a = 0;
                while (a < 4) {
                    int b = 0;
                    while (b < 4) {
                        if (counts[k][l][a][b] > 0.0) {
                            mi += counts[k][l][a][b] * (Math.log(counts[k][l][a][b]) - Math.log(counts[k][k][a][a]) - Math.log(counts[l][l][b][b]) + Math.log(sum));
                        }
                        ++b;
                    }
                    ++a;
                }
                mis[k][l] = mi;
                mis[l][k] = mi;
                ++l;
            }
            ++k;
        }
        return mis;
    }

    public static int getHeightForColorLogo(int numSeqs, int numOne, int numPerChunk, int oneHeight, int blockSpacer) {
        return numSeqs / numOne * oneHeight + numSeqs / numPerChunk * blockSpacer;
    }

    public static int getHeightForDependencyLogo(int seqLength, int numSeqs, int[] chunkHeights, int width, int blockSpacer) {
        int height = SeqLogoPlotter2.getHeightForColorLogo(numSeqs, chunkHeights, blockSpacer);
        int topMargin = width / 5;
        height = (int)((double)height + 1.5 * (double)topMargin);
        return height;
    }

    public static int getHeightForColorLogo(int numSeqs, int[] chunkHeights, int blockSpacer) {
        int height = 0;
        int i = 0;
        while (i < chunkHeights.length) {
            height += chunkHeights[i] + blockSpacer;
            ++i;
        }
        return height;
    }

    private static void plotScale(Graphics g, int offx, int offy, int height) {
        g = g.create();
        g.setColor(Color.BLACK);
        Rectangle2D rect = g.getFontMetrics().getStringBounds("2", g);
        int w = (int)rect.getWidth();
        int h = -((int)rect.getCenterY());
        g.drawLine(offx, offy, offx, offy + height);
        g.drawString("2", offx - 2 * w, offy + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy, offx, offy);
        g.drawString("1", offx - 2 * w, (int)((double)offy + 0.5 * (double)height) + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy + (int)(0.5 * (double)height), offx, offy + (int)(0.5 * (double)height));
        g.drawString("0", offx - 2 * w, offy + height + h);
        g.drawLine(offx - (int)(0.8 * (double)w), offy + height, offx, offy + height);
    }

    public static int[] getBorders(DataSet data, int[][] minmax, int[] steps) throws Exception {
        int off = 0;
        int[] maxBords = new int[minmax.length];
        int i = 0;
        while (i < minmax.length) {
            double max = Double.NEGATIVE_INFINITY;
            int maxBord = -1;
            int j = minmax[i][0];
            while (j <= minmax[i][1] && off + j < data.getNumberOfElements()) {
                Sequence[] sub1 = new Sequence[j];
                System.arraycopy(data.getAllElements(), off, sub1, 0, sub1.length);
                Sequence[] sub2 = new Sequence[data.getNumberOfElements() - (off + j)];
                System.arraycopy(data.getAllElements(), off + j, sub2, 0, sub2.length);
                FSDAGTrainSM pwm1 = TrainableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, data.getElementLength(), 0.0);
                pwm1.train(new DataSet("", sub1));
                FSDAGTrainSM pwm2 = TrainableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, data.getElementLength(), 0.0);
                pwm2.train(new DataSet("", sub2));
                double[] weights = new double[]{(double)sub1.length / (double)(sub1.length + sub2.length), (double)sub2.length / (double)(sub1.length + sub2.length)};
                MixtureTrainSM mtsm = new MixtureTrainSM(pwm1.getLength(), new TrainableStatisticalModel[]{pwm1, pwm2}, weights, 1, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureTrainSM.Parameterization.THETA);
                double ll = 0.0;
                int k = off;
                while (k < data.getNumberOfElements()) {
                    ll += mtsm.getLogProbFor(data.getElementAt(k));
                    ++k;
                }
                if (ll > max) {
                    max = ll;
                    maxBord = j;
                }
                j += steps[i];
            }
            maxBords[i] = maxBord;
            off += maxBord;
            ++i;
        }
        return maxBords;
    }

    public static BufferedImage plotDefaultDependencyLogoToBufferedImage(DataSet data, double[] weights, int width) throws Exception {
        int[] nArray = new int[3];
        nArray[0] = Math.min(250, (int)Math.round((double)data.getNumberOfElements() * 0.1));
        nArray[1] = Math.min(1250, (int)Math.round((double)data.getNumberOfElements() * 0.3));
        int[] numPerChunk = nArray;
        numPerChunk[2] = data.getNumberOfElements() - numPerChunk[0] - numPerChunk[1];
        int logoHeight = (int)Math.round((double)width / 10.0);
        int[] chunkHeights = new int[]{60, 75, 150};
        int height = SeqLogoPlotter2.getHeightForDependencyLogo(data.getElementLength(), data.getNumberOfElements(), chunkHeights, width, logoHeight);
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D graph = (Graphics2D)img.getGraphics();
        graph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter2.plotDependencyLogo(data, null, weights, graph, width, 0, 0, numPerChunk, chunkHeights, 0.03, logoHeight, false, 3, false, true, true, 0.1);
        return img;
    }

    public static int plotDependencyLogo(DataSet seqs, double[][] classProbs, double[] weights, Graphics2D graph, int width, int offx, int offy, int[] numPerChunk, int[] chunkHeights, double minPercent, int logoHeight, boolean highlightMaxDeps, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, boolean scaleByDeps, double threshold) throws Exception {
        int h;
        int j;
        int totalWidth = width;
        graph = (Graphics2D)graph.create();
        int leftMargin = width / 15;
        int tempWidth = width - 2 * leftMargin;
        String[] labels = new String[seqs.getElementLength()];
        int i = 0;
        while (i < labels.length) {
            labels[i] = String.valueOf(i + 1);
            ++i;
        }
        int partWidth = (int)Math.floor((double)tempWidth / (double)labels.length);
        Font font = new Font(graph.getFont().getName(), 1, width / 40);
        graph.setFont(font);
        int fac = 40;
        if (graph.getFontMetrics().getStringBounds(labels[labels.length - 1], graph).getWidth() > (double)partWidth * 0.8) {
            fac = (int)((double)fac * (graph.getFontMetrics().getStringBounds(labels[labels.length - 1], graph).getWidth() / ((double)partWidth * 0.8)));
            font = new Font(graph.getFont().getName(), 1, width / fac);
            graph.setFont(font);
        }
        graph.setStroke(new BasicStroke((float)width / 300.0f));
        double symHeight = graph.getFontMetrics().getStringBounds(labels[labels.length - 1], graph).getHeight();
        int topMargin = width / 5;
        graph.setColor(Color.WHITE);
        graph.fillRect(offx, offy, width, SeqLogoPlotter2.getHeightForColorLogo(seqs.getNumberOfElements(), chunkHeights, logoHeight) + topMargin * 2);
        double labWidth = graph.getFontMetrics().getStringBounds("0.000E000", graph).getWidth();
        Sequence[] seqs2 = seqs.getAllElements();
        int[] heights = SeqLogoPlotter2.plotColorLogo(seqs2, weights, graph, width -= 2 * leftMargin, offx + leftMargin, offy + topMargin, numPerChunk, chunkHeights, minPercent, logoHeight, numBestForSorting, sortGlobally, sortByWeights, threshold);
        seqs = new DataSet("", seqs2);
        graph.setColor(Color.BLACK);
        int off = topMargin;
        int i2 = 0;
        while (i2 < heights.length) {
            String lab = String.valueOf(numPerChunk[i2]);
            Rectangle2D rect = graph.getFontMetrics().getStringBounds(lab, graph);
            AffineTransform back = graph.getTransform();
            graph.rotate(-1.5707963267948966);
            graph.drawString(lab, -((int)((double)((heights[i2] + off - logoHeight) / 2) + rect.getCenterX())), (int)((double)leftMargin - rect.getHeight() / 2.0));
            graph.setTransform(back);
            off = heights[i2];
            ++i2;
        }
        off = partWidth / 2;
        graph.setColor(Color.BLACK);
        i2 = 0;
        while (i2 < labels.length) {
            int c = (int)graph.getFontMetrics().getStringBounds(labels[i2], graph).getCenterX();
            graph.drawString(labels[i2], offx + leftMargin + off + i2 * partWidth - c, offy + (int)((double)topMargin - symHeight / 2.0));
            graph.drawString(labels[i2], offx + leftMargin + off + i2 * partWidth - c, heights[heights.length - 1] + (int)(symHeight * 2.5));
            graph.drawLine(offx + leftMargin + off + i2 * partWidth, heights[heights.length - 1] + (int)symHeight, offx + leftMargin + off + i2 * partWidth, heights[heights.length - 1] + (int)(1.5 * symHeight));
            ++i2;
        }
        graph.drawLine(offx + leftMargin + off, heights[heights.length - 1] + (int)symHeight, offx + leftMargin + off + (labels.length - 1) * partWidth, heights[heights.length - 1] + (int)symHeight);
        double[][] deps = null;
        if (classProbs == null || classProbs.length == 1) {
            deps = SeqLogoPlotter2.getDeps(seqs2, classProbs == null ? null : classProbs[0]);
        } else {
            BTExplainingAwayResidual ear = new BTExplainingAwayResidual(new double[]{0.0, 0.0});
            deps = ear.getEAR(new DataSet("", seqs2), new DataSet("", seqs2), classProbs[0], classProbs[1], seqs2[0].getLength());
        }
        boolean[][] isMax = new boolean[deps.length][deps.length];
        if (highlightMaxDeps) {
            int i3 = 0;
            while (i3 < deps.length) {
                double max = ToolBox.max(deps[i3]);
                int j2 = 0;
                while (j2 < deps[i3].length) {
                    if (deps[i3][j2] == max) {
                        isMax[i3][j2] = true;
                    }
                    ++j2;
                }
                ++i3;
            }
            i3 = 1;
            while (i3 < deps.length) {
                int j3 = 0;
                while (j3 < i3) {
                    isMax[i3][j3] = isMax[i3][j3] || isMax[j3][i3];
                    isMax[j3][i3] = isMax[i3][j3];
                    ++j3;
                }
                ++i3;
            }
        }
        double[][] ps = new double[deps.length][deps[0].length];
        double f = (double)(deps.length * (deps.length - 1)) / 2.0;
        double maxp = -Math.log10(1.0E-300 / f);
        double minp = -Math.log10(0.01 / f);
        int i4 = 1;
        while (i4 < deps.length) {
            j = 0;
            while (j < i4) {
                double p = -Math.log10(Gamma.incompleteGammaComplement(4.5, deps[i4][j] * 2.0 / 2.0));
                if (p > maxp) {
                    p = maxp;
                }
                ps[i4][j] = p;
                ++j;
            }
            ++i4;
        }
        if (scaleByDeps) {
            i4 = 1;
            while (i4 < deps.length) {
                j = 0;
                while (j < i4) {
                    ps[i4][j] = ps[i4][j] > minp ? Math.log(deps[i4][j] / (classProbs == null ? (double)seqs2.length : ToolBox.sum(classProbs[0]))) : Double.NEGATIVE_INFINITY;
                    ++j;
                }
                ++i4;
            }
            minp = Math.log(0.01);
            maxp = Math.log(Math.log(4.0));
        }
        graph.setColor(Color.BLACK);
        i4 = 1;
        while (i4 < deps.length) {
            j = 0;
            while (j < i4) {
                if (ps[i4][j] > minp && !isMax[i4][j]) {
                    Color c = new Color(0.0f, 0.0f, 0.0f, (float)((ps[i4][j] - minp) / (maxp - minp)));
                    graph.setColor(c);
                    h = (int)(((double)topMargin - symHeight * 1.5) * (double)(i4 - j) / (double)deps.length);
                    graph.drawArc(offx + leftMargin + off + j * partWidth, offy + (int)((double)topMargin - symHeight * 1.5) - h, (i4 - j) * partWidth, h * 2, 0, 180);
                }
                ++j;
            }
            ++i4;
        }
        i4 = 1;
        while (i4 < deps.length) {
            j = 0;
            while (j < i4) {
                if (ps[i4][j] > minp && isMax[i4][j]) {
                    Color c = new Color(1.0f, 0.0f, 0.0f, (float)((ps[i4][j] - minp) / (maxp - minp)));
                    graph.setColor(c);
                    h = (int)(((double)topMargin - symHeight * 1.5) * (double)(i4 - j) / (double)deps.length);
                    graph.drawArc(offx + leftMargin + off + j * partWidth, offy + (int)((double)topMargin - symHeight * 1.5) - h, (i4 - j) * partWidth, h * 2, 0, 180);
                }
                ++j;
            }
            ++i4;
        }
        off = 0;
        i4 = 0;
        while (i4 < heights.length) {
            double[][] pwm = PFMComparator.getPWM(seqs, off, off + numPerChunk[i4]);
            off += numPerChunk[i4];
            int j4 = 0;
            while (j4 < pwm.length) {
                SeqLogoPlotter2.plotLogo(graph, (double)(offx + leftMargin + j4 * partWidth), heights[i4], partWidth, logoHeight, pwm[j4]);
                ++j4;
            }
            SeqLogoPlotter2.plotScale(graph, offx + leftMargin, heights[i4] - logoHeight, logoHeight - 1);
            ++i4;
        }
        return heights[heights.length - 1];
    }

    public static int plotColorLogo(Sequence[] seqs, double[] weights, Graphics2D graph, int width, int offx, int offy, int numOne, int numPerChunk, int oneHeight, int blockSpacer, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, double threshold) throws Exception {
        int[] nums = new int[(int)Math.ceil((double)seqs.length / (double)numPerChunk)];
        int[] oneNums = new int[nums.length];
        int i = 0;
        int k = 0;
        while (i < seqs.length) {
            int numCurr;
            nums[k] = i + numPerChunk <= seqs.length ? numPerChunk : (numCurr = (int)Math.floor((seqs.length - i) / numOne) * numOne);
            oneNums[k] = numOne;
            i += numPerChunk;
            ++k;
        }
        int[] offs = SeqLogoPlotter2.plotColorLogo(seqs, weights, graph, width, offx, offy, oneNums, nums, (double)oneHeight, blockSpacer, numBestForSorting, sortGlobally, sortByWeights, threshold);
        return offs[offs.length - 1];
    }

    public static int[] plotColorLogo(Sequence[] seqs, double[] weights, Graphics2D graph, int width, int offx, int offy, int[] numPerChunk, int[] chunkHeights, double minPercent, int blockSpacer, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, double threshold) throws Exception {
        int i;
        int[] offs = new int[numPerChunk.length];
        if (weights == null) {
            weights = new double[seqs.length];
            Arrays.fill(weights, 1.0);
        } else {
            Object[] els = new ComparableElement[seqs.length];
            i = 0;
            while (i < els.length) {
                els[i] = new ComparableElement<Sequence, Double>(seqs[i], weights[i]);
                ++i;
            }
            Arrays.sort(els);
            i = 0;
            while (i < els.length) {
                seqs[i] = (Sequence)((ComparableElement)els[els.length - 1 - i]).getElement();
                weights[i] = (Double)((ComparableElement)els[els.length - 1 - i]).getWeight();
                ++i;
            }
        }
        int off = 0;
        i = 0;
        while (i < numPerChunk.length) {
            SeqLogoPlotter2.plotColorLogo(graph, seqs, weights, off, off + numPerChunk[i], width, offx, offy, chunkHeights[i], minPercent, numBestForSorting, sortGlobally, sortByWeights, threshold);
            Color back = graph.getColor();
            graph.setColor(Color.WHITE);
            graph.fillRect(offx, (offy += chunkHeights[i] + blockSpacer) - blockSpacer, width, blockSpacer);
            graph.setColor(back);
            off += numPerChunk[i];
            offs[i] = offy;
            ++i;
        }
        return offs;
    }

    public static int plotColorLogo(Graphics2D graph, Sequence[] seqs, double[] weights, int start, int end, int width, int offx, int offy, int chunkHeight, double minPercent, int numBestForSorting, boolean sortGlobally, boolean sortByWeights, double threshold) throws Exception {
        double mi = ToolBox.min(weights);
        double ma = ToolBox.max(weights);
        if (ma == (mi -= (ma - mi) * 1.0E-6)) {
            mi = 0.0;
        }
        graph = (Graphics2D)graph.create();
        Sequence[] temp = new Sequence[end - start];
        System.arraycopy(seqs, start, temp, 0, end - start);
        Pair[] sortTemp = new Pair[end - start];
        int i = 0;
        while (i < sortTemp.length) {
            sortTemp[i] = new Pair<Sequence, Double>(seqs[start + i], weights[start + i]);
            ++i;
        }
        double[][] fullPFM = PFMComparator.getPFM(new DataSet("", temp));
        int numSort = 6;
        LinkedList<ComparableElement<Integer, Double>> pivots = new LinkedList<ComparableElement<Integer, Double>>();
        Pair<Sequence, Double>[][] sorted = SeqLogoPlotter2.sortLocal2(sortTemp, numBestForSorting, numSort, new boolean[temp[0].getLength()], (int)(minPercent * (double)sortTemp.length), sortByWeights, fullPFM, threshold, pivots);
        if (sortGlobally) {
            Object[] pivAr = pivots.toArray(new ComparableElement[0]);
            Arrays.sort(pivAr);
            IntList sortPos = new IntList();
            DoubleList sortVals = new DoubleList();
            int off = 0;
            boolean[] exclude = new boolean[temp[0].getLength()];
            double[] vals = new double[exclude.length];
            int i2 = pivAr.length - 1;
            while (i2 >= 0 && off < numSort) {
                int idx = (Integer)((ComparableElement)pivAr[i2]).getElement();
                double val = (Double)((ComparableElement)pivAr[i2]).getWeight();
                int n = idx;
                vals[n] = vals[n] + val;
                --i2;
            }
            int[] o = ToolBox.order(vals, true);
            int i3 = 0;
            while (i3 < o.length) {
                sortPos.add(o[i3]);
                sortVals.add(vals[o[i3]]);
                ++i3;
            }
            sorted = SeqLogoPlotter2.partition(sortTemp, (int)(minPercent * (double)sortTemp.length), sortPos.toArray(), sortVals.toArray(), 0, sortByWeights, null);
        }
        int totalHeight = chunkHeight;
        double[][] pwm = new double[seqs[0].getLength()][4];
        int i4 = 0;
        while (i4 < sorted.length) {
            int numCurr = sorted[i4].length;
            int heightCurr = totalHeight * numCurr / sortTemp.length;
            double meanW = 0.0;
            int k = 0;
            while (k < numCurr) {
                meanW += sorted[i4][k].getSecondElement().doubleValue();
                ++k;
            }
            meanW /= (double)numCurr;
            int j = 0;
            while (j < pwm.length) {
                Arrays.fill(pwm[j], 0.0);
                int k2 = 0;
                while (k2 < numCurr) {
                    double[] dArray = pwm[j];
                    int n = sorted[i4][k2].getFirstElement().discreteVal(j);
                    dArray[n] = dArray[n] + 1.0;
                    ++k2;
                }
                Normalisation.sumNormalisation(pwm[j]);
                ++j;
            }
            SeqLogoPlotter2.plotColorLogo(graph, pwm, (meanW - mi) / (ma - mi), true, true, heightCurr, width, offx, offy);
            offy += heightCurr;
            ++i4;
        }
        return offx;
    }

    private static Pair<Sequence, Double>[] sortLocal3(Pair<Sequence, Double>[] sortTemp, int numBestForSorting, int maxNum, boolean[] exclude, int minElements, boolean sortByWeights, double[] prevInf) {
        if (maxNum == 0 || sortTemp.length < minElements * 4) {
            return sortTemp;
        }
        Sequence[] temp = new Sequence[sortTemp.length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = sortTemp[i].getFirstElement();
            ++i;
        }
        Pair<double[], double[][]> pair = SeqLogoPlotter2.getInformation(temp, numBestForSorting, exclude);
        double[] inf = pair.getFirstElement();
        int best = ToolBox.getMaxIndex(inf);
        int bestPrev = ToolBox.getMaxIndex(prevInf);
        if (inf[best] / (double)temp.length / (double)numBestForSorting < 0.1 && (ToolBox.sum(exclude) == 0 || prevInf[bestPrev] / (double)temp.length / (double)ToolBox.sum(exclude) < 0.1)) {
            return sortTemp;
        }
        if (inf[best] / (double)temp.length / (double)numBestForSorting < 0.1) {
            best = bestPrev;
        }
        double[] mis = pair.getSecondElement()[best];
        exclude[best] = true;
        LinkedList[] partSort = new LinkedList[4];
        int i2 = 0;
        while (i2 < partSort.length) {
            partSort[i2] = new LinkedList();
            ++i2;
        }
        double[] freq = new double[4];
        double[] ws = new double[4];
        int i3 = 0;
        while (i3 < temp.length) {
            Sequence seq = temp[i3];
            int idx = seq.discreteVal(best);
            partSort[idx].add(sortTemp[i3]);
            int n = idx;
            freq[n] = freq[n] + 1.0;
            int n2 = idx;
            ws[n2] = ws[n2] + sortTemp[i3].getSecondElement();
            ++i3;
        }
        if (sortByWeights) {
            i3 = 0;
            while (i3 < freq.length) {
                freq[i3] = ws[i3] / freq[i3];
                ++i3;
            }
        }
        int[] ord = ToolBox.order(freq, true);
        int off = 0;
        int i4 = 0;
        while (i4 < ord.length) {
            if (freq[ord[i4]] > 0.0) {
                double[] tempPrev = (double[])prevInf.clone();
                int j = 0;
                while (j < tempPrev.length) {
                    if (exclude[j]) {
                        tempPrev[j] = 0.0;
                    } else {
                        int n = j;
                        tempPrev[n] = tempPrev[n] + mis[j];
                    }
                    ++j;
                }
                Pair<Sequence, Double>[] part = SeqLogoPlotter2.sortLocal3(partSort[ord[i4]].toArray(new Pair[0]), numBestForSorting, maxNum - 1, (boolean[])exclude.clone(), minElements, sortByWeights, tempPrev);
                int j2 = 0;
                while (j2 < part.length) {
                    sortTemp[off] = part[j2];
                    ++j2;
                    ++off;
                }
            }
            ++i4;
        }
        return sortTemp;
    }

    private static Pair<Sequence, Double>[][] sortLocal2(Pair<Sequence, Double>[] sortTemp, int numBestForSorting, int maxNum, boolean[] exclude, int minElements, boolean sortByWeights, double[][] fullPFM, double threshold, LinkedList<ComparableElement<Integer, Double>> pivots) throws Exception {
        int j;
        int i;
        if (maxNum == 0 || sortTemp.length < minElements) {
            return new Pair[][]{sortTemp};
        }
        Sequence[] temp = new Sequence[sortTemp.length];
        int i2 = 0;
        while (i2 < temp.length) {
            temp[i2] = sortTemp[i2].getFirstElement();
            ++i2;
        }
        Pair<double[], double[][]> pair = SeqLogoPlotter2.getInformation(temp, numBestForSorting, exclude);
        double[] inf = pair.getFirstElement();
        double[][] deps = pair.getSecondElement();
        int best = ToolBox.getMaxIndex(inf);
        if (inf[best] / (double)temp.length / (double)numBestForSorting < threshold) {
            return new Pair[][]{sortTemp};
        }
        exclude[best] = true;
        Pair<Sequence, Double>[][] partSort = SeqLogoPlotter2.partition(sortTemp, minElements, best, inf[best] / (double)temp.length / (double)numBestForSorting, sortByWeights, pivots);
        double[] kls = deps[best];
        int i3 = 0;
        while (i3 < kls.length) {
            int n = i3++;
            kls[n] = kls[n] / (double)temp.length;
        }
        int[] o2 = ToolBox.order(kls, true);
        int secpos = -1;
        int i4 = 0;
        while (i4 < o2.length) {
            if (!exclude[o2[i4]] && kls[o2[i4]] > threshold) {
                secpos = o2[i4];
                break;
            }
            ++i4;
        }
        if (secpos > -1) {
            LinkedList<Pair<Sequence, Double>[]> list = new LinkedList<Pair<Sequence, Double>[]>();
            i = 0;
            while (i < partSort.length) {
                if (partSort[i] != null) {
                    Pair<Sequence, Double>[][] temp2 = SeqLogoPlotter2.partition(partSort[i], minElements, secpos, kls[secpos], sortByWeights, pivots);
                    temp2 = SeqLogoPlotter2.joinSmall(temp2, minElements, sortByWeights);
                    j = 0;
                    while (j < temp2.length) {
                        list.add(temp2[j]);
                        ++j;
                    }
                }
                ++i;
            }
            partSort = (Pair[][])list.toArray((T[])new Pair[0][0]);
            --maxNum;
            exclude[secpos] = true;
        }
        partSort = SeqLogoPlotter2.joinSmall(partSort, minElements, false);
        LinkedList<Pair<Sequence, Double>[]> partitions = new LinkedList<Pair<Sequence, Double>[]>();
        i = 0;
        while (i < partSort.length) {
            if (partSort[i] != null) {
                Pair<Sequence, Double>[][] part = SeqLogoPlotter2.sortLocal2(partSort[i], numBestForSorting, maxNum - 1, (boolean[])exclude.clone(), minElements, sortByWeights, fullPFM, threshold, pivots);
                j = 0;
                while (j < part.length) {
                    partitions.add(part[j]);
                    ++j;
                }
            }
            ++i;
        }
        return (Pair[][])partitions.toArray((T[])new Pair[0][0]);
    }

    private static Pair<Sequence, Double>[][] joinSmall(Pair<Sequence, Double>[][] partSort, int minElements, boolean sortByWeights) {
        int i;
        if (partSort.length == 1) {
            return partSort;
        }
        boolean[] out = new boolean[partSort.length];
        int minAbove = Integer.MAX_VALUE;
        int idx = -1;
        int nout = 0;
        int i2 = 0;
        while (i2 < partSort.length) {
            if (partSort[i2] != null) {
                if (partSort[i2].length < minElements) {
                    out[i2] = true;
                    nout += partSort[i2].length;
                } else if (partSort[i2].length < minAbove) {
                    minAbove = partSort[i2].length;
                    idx = i2;
                }
            }
            ++i2;
        }
        if (nout == 0 && idx == -1) {
            return partSort;
        }
        if (idx == -1) {
            minAbove = 0;
        }
        Pair[] joined = new Pair[minAbove + nout];
        int off = 0;
        if (idx > -1) {
            System.arraycopy(partSort[idx], 0, joined, 0, partSort[idx].length);
            off = partSort[idx].length;
        } else {
            i = 0;
            while (i < out.length) {
                if (out[i]) {
                    idx = i;
                    break;
                }
                ++i;
            }
        }
        i = 0;
        while (i < partSort.length) {
            if (partSort[i] != null && out[i]) {
                System.arraycopy(partSort[i], 0, joined, off, partSort[i].length);
                off += partSort[i].length;
                partSort[i] = null;
            }
            ++i;
        }
        partSort[idx] = joined;
        if (sortByWeights) {
            double[] meanw = new double[partSort.length];
            int i3 = 0;
            while (i3 < partSort.length) {
                if (partSort[i3] == null) {
                    meanw[i3] = Double.NEGATIVE_INFINITY;
                } else {
                    int j = 0;
                    while (j < partSort[i3].length) {
                        int n = i3;
                        meanw[n] = meanw[n] + partSort[i3][j].getSecondElement();
                        ++j;
                    }
                    int n = i3;
                    meanw[n] = meanw[n] / (double)partSort[i3].length;
                }
                ++i3;
            }
            int[] o = ToolBox.order(meanw, true);
            Pair[][] temp = new Pair[partSort.length][];
            int i4 = 0;
            while (i4 < o.length) {
                temp[i4] = partSort[o[i4]];
                ++i4;
            }
            partSort = temp;
        }
        return partSort;
    }

    private static double[] getAvgKLs(Pair<Sequence, Double>[] sortTemp, Pair<Sequence, Double>[][] partSort) throws EmptyDataSetException, WrongAlphabetException, CloneNotSupportedException {
        double[][] all = SeqLogoPlotter2.getPFM(sortTemp);
        double n = sortTemp.length;
        double[] allAvgKLs = new double[sortTemp[0].getFirstElement().getLength()];
        int i = 0;
        while (i < partSort.length) {
            if (partSort[i] != null) {
                double[][] curr = SeqLogoPlotter2.getPFM(partSort[i]);
                double m = partSort[i].length;
                double[] kls = SeqLogoPlotter2.getKLDivergence(curr, (double[][])ArrayHandler.clone((Cloneable[])all));
                int j = 0;
                while (j < kls.length) {
                    int n2 = j;
                    allAvgKLs[n2] = allAvgKLs[n2] + m / n * kls[j];
                    ++j;
                }
            }
            ++i;
        }
        return allAvgKLs;
    }

    private static double[][] getPFM(Pair<Sequence, Double>[] sortTemp) throws EmptyDataSetException, WrongAlphabetException {
        LinkedList<Sequence> seqTemp = new LinkedList<Sequence>();
        int i = 0;
        while (i < sortTemp.length) {
            seqTemp.add(sortTemp[i].getFirstElement());
            ++i;
        }
        double[][] partPFM = PFMComparator.getPFM(new DataSet("", seqTemp));
        return partPFM;
    }

    private static Pair<Sequence, Double>[][] partition(Pair<Sequence, Double>[] sortTemp, int minElements, int[] ord, double[] values, int idx, boolean sortByWeights, LinkedList<ComparableElement<Integer, Double>> pivots) {
        if (idx == ord.length) {
            return new Pair[][]{sortTemp};
        }
        Pair<Sequence, Double>[][] partitions = SeqLogoPlotter2.partition(sortTemp, minElements, ord[idx], values[idx], sortByWeights, pivots);
        LinkedList<Pair<Sequence, Double>[]> pairs = new LinkedList<Pair<Sequence, Double>[]>();
        int i = 0;
        while (i < partitions.length) {
            if (partitions[i] != null) {
                Pair<Sequence, Double>[][] part2 = SeqLogoPlotter2.partition(partitions[i], minElements, ord, values, idx + 1, sortByWeights, pivots);
                int j = 0;
                while (j < part2.length) {
                    pairs.add(part2[j]);
                    ++j;
                }
            }
            ++i;
        }
        return (Pair[][])pairs.toArray((T[])new Pair[0][0]);
    }

    private static Pair<Sequence, Double>[][] partition(Pair<Sequence, Double>[] sortTemp, int minElements, int curr, double value, boolean sortByWeights, LinkedList<ComparableElement<Integer, Double>> pivots) {
        if (sortTemp.length < minElements) {
            return new Pair[][]{sortTemp};
        }
        if (pivots != null) {
            pivots.add(new ComparableElement<Integer, Double>(curr, value * (double)sortTemp.length));
        }
        LinkedList[] partSort = new LinkedList[4];
        int i = 0;
        while (i < partSort.length) {
            partSort[i] = new LinkedList();
            ++i;
        }
        double[] freq = new double[4];
        double[] ws = new double[4];
        int i2 = 0;
        while (i2 < sortTemp.length) {
            Sequence seq = sortTemp[i2].getFirstElement();
            int idx = seq.discreteVal(curr);
            partSort[idx].add(sortTemp[i2]);
            int n = idx;
            freq[n] = freq[n] + 1.0;
            int n2 = idx;
            ws[n2] = ws[n2] + sortTemp[i2].getSecondElement();
            ++i2;
        }
        if (sortByWeights) {
            i2 = 0;
            while (i2 < freq.length) {
                freq[i2] = ws[i2] / freq[i2];
                ++i2;
            }
        }
        int[] ord = ToolBox.order(freq, true);
        boolean off = false;
        Pair[][] partitions = new Pair[4][];
        int i3 = 0;
        while (i3 < ord.length) {
            if (partSort[ord[i3]].size() > 0) {
                partitions[i3] = partSort[ord[i3]].toArray(new Pair[0]);
            }
            ++i3;
        }
        return partitions;
    }

    private static double[] getKLDivergence(double[][] partPFM, double[][] fullPFM) {
        double full = ToolBox.sum(fullPFM[0]);
        double part = ToolBox.sum(partPFM[0]);
        double[] kls = new double[partPFM.length];
        int i = 0;
        while (i < fullPFM.length) {
            Normalisation.sumNormalisation(fullPFM[i]);
            Normalisation.sumNormalisation(partPFM[i]);
            int j = 0;
            while (j < fullPFM[i].length) {
                if (partPFM[i][j] > 0.0) {
                    int n = i;
                    kls[n] = kls[n] + partPFM[i][j] * Math.log(partPFM[i][j] / fullPFM[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return kls;
    }

    public static int[] getOrder(Sequence[] temp, int numBestForSorting, int numSortingPositions) {
        IntList sortPos = new IntList();
        boolean[] exclude = new boolean[temp[0].getLength()];
        double[] inf = SeqLogoPlotter2.getInformation(temp, numBestForSorting, exclude).getFirstElement();
        int best = ToolBox.getMaxIndex(inf);
        exclude[best] = true;
        if (inf[best] / (double)temp.length / (double)numBestForSorting > 0.1) {
            sortPos.add(best);
        }
        int i = 1;
        while (i < numSortingPositions) {
            inf = SeqLogoPlotter2.getInformation(temp, numBestForSorting, exclude).getFirstElement();
            best = ToolBox.getMaxIndex(inf);
            exclude[best] = true;
            if (inf[best] / (double)temp.length / (double)numBestForSorting > 0.1) {
                sortPos.add(best);
            }
            ++i;
        }
        return sortPos.toArray();
    }

    public static LinkedList<Sequence>[] getPartitions(Sequence[] temp, IntList sortPos) {
        LinkedList[] lists = new LinkedList[(int)Math.pow(4.0, sortPos.length())];
        int i = 0;
        while (i < lists.length) {
            lists[i] = new LinkedList();
            ++i;
        }
        int[] pows = new int[sortPos.length()];
        int i2 = 0;
        while (i2 < pows.length) {
            pows[i2] = (int)Math.pow(4.0, i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < temp.length) {
            int idx = 0;
            int j = 0;
            while (j < sortPos.length()) {
                idx += pows[j] * temp[i2].discreteVal(sortPos.get(j));
                ++j;
            }
            lists[idx].add(temp[i2]);
            ++i2;
        }
        return lists;
    }

    public static Pair<double[], double[][]> getInformation(Sequence[] seqs, int numBest, boolean[] exclude) {
        double[][] mis = SeqLogoPlotter2.getDeps(seqs, null);
        double[] vals = new double[seqs[0].getLength()];
        int i = 0;
        while (i < vals.length) {
            int[] o = ToolBox.order(mis[i], true);
            vals[i] = 0.0;
            if (exclude == null || !exclude[i]) {
                int j = 0;
                int k = 0;
                while (k < numBest && j < mis[i].length) {
                    int n = i;
                    vals[n] = vals[n] + mis[i][o[j]];
                    ++k;
                    ++j;
                }
            }
            ++i;
        }
        return new Pair<double[], double[][]>(vals, mis);
    }

    public static void plotColorLogo(Graphics2D graph, double[][] pwm, double weight, boolean mix, boolean icscale, int height, int width, int offx, int offy) {
        graph = (Graphics2D)graph.create();
        Color back = graph.getColor();
        graph.setColor(Color.WHITE);
        graph.fillRect(offx, offy, width, height);
        graph.setColor(back);
        int partWidth = (int)Math.floor((double)width / (double)pwm.length);
        double[] temp = new double[4];
        int i = 0;
        while (i < pwm.length) {
            if (mix) {
                Color c = SeqLogoPlotter2.getColor(pwm[i], icscale ? (float)Math.sqrt(SeqLogoPlotter2.getICScale(pwm[i])) : 1.0f);
                back = graph.getColor();
                graph.setColor(c);
                graph.fillRect(offx, offy, partWidth, height);
                graph.setColor(back);
            } else {
                int off2 = 0;
                float ic = icscale ? (float)Math.sqrt(SeqLogoPlotter2.getICScale(pwm[i])) : 1.0f;
                int j = 0;
                while (j < pwm[i].length) {
                    Arrays.fill(temp, 0.0);
                    temp[j] = 1.0;
                    Color c = SeqLogoPlotter2.getColor(temp, ic);
                    back = graph.getColor();
                    graph.setColor(c);
                    int partHeight = (int)Math.round((double)height * pwm[i][j]);
                    graph.fillRect(offx, offy + off2, partWidth, j < pwm[i].length - 1 ? partHeight : height - off2);
                    off2 += partHeight;
                    graph.setColor(back);
                    ++j;
                }
            }
            offx += partWidth;
            ++i;
        }
        graph.setColor(back);
    }

    public static void plotLogoToPNG(String path, int height, double[][] ps) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter2.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter2.plotLogo(g, height, ps);
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotLogoToBufferedImage(int height, double[][] ps) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter2.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        SeqLogoPlotter2.plotLogo(g, height, ps);
        return pair.getFirstElement();
    }

    public static Pair<BufferedImage, Graphics2D> getBufferedImageAndGraphics(int height, double[][] ps) {
        int w = SeqLogoPlotter2.getWidth(height, ps);
        BufferedImage img = new BufferedImage(w, height, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        return new Pair<BufferedImage, Graphics2D>(img, g);
    }

    public static void plotLogo(Graphics2D g, int h, double[][] ps) {
        SeqLogoPlotter2.plotLogo(g, h, ps, null, "Position", "bits");
    }

    public static void plotLogo(Graphics2D g, int height, double[][] ps, String[] labels, String labX, String labY) {
        int w = SeqLogoPlotter2.getWidth(height, ps);
        SeqLogoPlotter2.plotLogo(g, w, height, ps, labels, labX, labY);
    }

    public static int getWidth(int height, double[][] ps) {
        return (int)((double)height / 6.0 * ((double)ps.length + 1.5));
    }

    public static int getHeight(int width, double[][] ps) {
        return (int)((double)width * 6.0 / ((double)ps.length + 1.5));
    }

    public static void plotLogo(Graphics2D g, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        SeqLogoPlotter2.plotLogo(g, 0, h, w, h, ps, labels, labX, labY);
    }

    public static void plotLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, String[] labels, String labX, String labY) {
        Rectangle2D rect;
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 17);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            int i = 0;
            while (i < ps.length) {
                labels[i] = String.valueOf(i + 1);
                ++i;
            }
        }
        double wl = (double)h * 0.25;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = wl * 0.9;
        double h2 = (double)h * 0.7;
        double y2 = (double)y - (double)h * 0.25;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke((float)h / 100.0f));
        g.drawLine(x + (int)x2, (int)(y2 + 0.05 * (double)h), x + (int)(x2 + w2 * (double)ps.length), (int)(y2 + 0.05 * (double)h));
        g.drawLine(x + (int)(x2 * 0.94), (int)y2, x + (int)(x2 * 0.94), (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        int i = 0;
        while (i <= 4) {
            g.drawLine(x + (int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), x + (int)(x2 * 0.94), (int)(y2 - (double)i * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.drawString(labs[i], x + (int)(x2 * 0.6 - rect.getWidth()), (int)(y2 - (double)i * h2 / 4.0 - rect.getCenterY()));
            ++i;
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getWidth() / 2.0));
        g.setTransform(back);
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, x + (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.3 * rect.getHeight()));
        int i2 = 0;
        while (i2 < ps.length) {
            SeqLogoPlotter2.plotLogo(g, (double)x + x2, y2, w2, h2, ps[i2]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i2], g);
            g.drawString(labels[i2], (float)x + (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 2.0 * rect.getHeight()));
            x2 += w2;
            ++i2;
        }
    }

    public static void plotTALgetterLogoToPNG(String path, int height, double[][] ps, double[] imp, String[] lab) throws IOException {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter2.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter2.getWidth(height, ps);
        SeqLogoPlotter2.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        ImageIO.write((RenderedImage)pair.getFirstElement(), "png", new File(path));
    }

    public static BufferedImage plotTALgetterLogoToBufferedImage(int height, double[][] ps, double[] imp, String[] lab) {
        Pair<BufferedImage, Graphics2D> pair = SeqLogoPlotter2.getBufferedImageAndGraphics(height, ps);
        Graphics2D g = pair.getSecondElement();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = SeqLogoPlotter2.getWidth(height, ps);
        SeqLogoPlotter2.plotTALgetterLogo(g, 0, height, w, height, ps, imp, lab, "RVD", "bits", "Importance");
        return pair.getFirstElement();
    }

    public static void plotTALgetterLogo(Graphics2D g, int x, int y, int w, int h, double[][] ps, double[] imp, String[] labels, String labX, String labY, String labY2) {
        Rectangle2D rect;
        g = (Graphics2D)g.create();
        g.setColor(Color.WHITE);
        g.fillRect(x, y - h, w, h);
        Font font = new Font(g.getFont().getName(), 1, h / 17);
        g.setFont(font);
        if (labels == null) {
            labels = new String[ps.length];
            int i = 0;
            while (i < ps.length) {
                labels[i] = String.valueOf(i + 1);
                ++i;
            }
        }
        double wl = (double)h * 0.5;
        double w2 = ((double)w - wl) / (double)ps.length;
        double x2 = (double)x + wl * 0.45;
        double h2 = (double)h * 0.7;
        double y2 = (double)y * 0.75;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(h / 400 + 1));
        g.drawLine((int)x2, (int)(y2 * 1.04) + 1, (int)(x2 + w2 * (double)ps.length), (int)(y2 * 1.04) + 1);
        g.drawLine((int)(x2 * 0.94) - 1, (int)y2, (int)(x2 * 0.94) - 1, (int)(y2 - h2));
        String[] labs = new String[]{"0", "0.5", "1", "1.5", "2"};
        int i = 0;
        while (i <= 4) {
            g.drawLine((int)(x2 * 0.7), (int)(y2 - (double)i * h2 / 4.0), (int)(x2 * 0.94) - 1, (int)(y2 - (double)i * h2 / 4.0));
            rect = g.getFontMetrics().getStringBounds(labs[i], g);
            g.drawString(labs[i], (int)(x2 * 0.6 - rect.getWidth() - 2.0), (int)(y2 - (double)i * h2 / 4.0 - rect.getCenterY()));
            ++i;
        }
        AffineTransform back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY, g);
        g.drawString(labY, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)x + rect.getHeight()));
        g.setTransform(back);
        rect = g.getFontMetrics().getStringBounds(labX, g);
        g.drawString(labX, (int)(x2 + w2 * (double)ps.length / 2.0 - rect.getCenterX()), (int)((double)y - 0.3 * rect.getHeight()));
        int i2 = 0;
        while (i2 < ps.length) {
            SeqLogoPlotter2.plotLogo(g, x2, y2, w2, h2, ps[i2]);
            g.setColor(Color.BLACK);
            rect = g.getFontMetrics().getStringBounds(labels[i2], g);
            g.drawString(labels[i2], (float)(x2 + w2 / 2.0 - rect.getCenterX()), (float)(y2 + 2.0 * rect.getHeight()));
            x2 += w2;
            ++i2;
        }
        g.drawLine((int)(x2 + w2 * 0.1) + 1, (int)y2, (int)(x2 + w2 * 0.1) + 1, (int)(y2 - h2));
        labs = new String[]{"0", "0.5", "1"};
        Rectangle2D rect2 = g.getFontMetrics().getStringBounds("0.5", g);
        int i3 = 0;
        while (i3 <= 2) {
            g.drawLine((int)(x2 + w2 * 0.34) + 2, (int)(y2 - (double)i3 * h2 / 2.0), (int)(x2 + w2 * 0.1) + 1, (int)(y2 - (double)i3 * h2 / 2.0));
            g.drawString(labs[i3], (int)(x2 + w2 * 0.5 + 2.0), (int)(y2 - (double)i3 * h2 / 2.0 - rect.getCenterY()));
            ++i3;
        }
        back = g.getTransform();
        g.rotate(-1.5707963267948966);
        rect = g.getFontMetrics().getStringBounds(labY2, g);
        g.drawString(labY2, -((int)(y2 - 2.0 * h2 / 4.0 + rect.getCenterX())), (int)((double)w - rect.getHeight() / 2.0));
        g.setTransform(back);
        x2 = (double)x + wl * 0.45 + 2.0 * w2;
        g.setColor(Color.GRAY);
        i3 = 1;
        while (i3 < imp.length) {
            g.drawLine((int)(x2 - w2 / 2.0 + w2 / 20.0), (int)(y2 - h2 * imp[i3 - 1] + w2 / 20.0), (int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i3] + w2 / 20.0));
            x2 += w2;
            ++i3;
        }
        x2 = (double)x + wl * 0.45 + w2;
        g.setColor(Color.BLUE);
        i3 = 0;
        while (i3 < imp.length) {
            g.fillRect((int)(x2 + w2 / 2.0 - w2 / 20.0), (int)(y2 - h2 * imp[i3]), (int)(w2 / 10.0), (int)(w2 / 10.0));
            x2 += w2;
            ++i3;
        }
    }

    protected static void plotLogo(Graphics2D g, double x, double y, double w, double h, double[] p) {
        double ic = SeqLogoPlotter2.getICScale(p);
        h *= ic;
        double[] mp = (double[])p.clone();
        int i = 0;
        while (i < mp.length) {
            int n = i++;
            mp[n] = mp[n] * -1.0;
        }
        int[] r = ToolBox.rank(mp, false);
        int[] order = new int[r.length];
        int i2 = 0;
        while (i2 < r.length) {
            order[r[i2]] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < order.length) {
            double curr = p[order[i2]];
            if (order[i2] == 0) {
                g.setColor(Color.GREEN);
                g.fill(SeqLogoPlotter2.getA(x, y, w, h * curr));
            } else if (order[i2] == 1) {
                g.setColor(Color.BLUE);
                g.fill(SeqLogoPlotter2.getC(x, y, w, h * curr));
            } else if (order[i2] == 2) {
                g.setColor(Color.ORANGE);
                g.fill(SeqLogoPlotter2.getG(x, y, w, h * curr));
            } else {
                g.setColor(Color.RED);
                g.fill(SeqLogoPlotter2.getT(x, y, w, h * curr));
            }
            y -= h * curr;
            ++i2;
        }
    }

    public static double getICScale(double[] p) {
        double ic = Math.log(4.0) / Math.log(2.0);
        int i = 0;
        while (i < p.length) {
            if (p[i] > 0.0) {
                ic += p[i] * Math.log(p[i]) / Math.log(2.0);
            }
            ++i;
        }
        return ic /= 2.0;
    }

    private static Area getC(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        AffineTransform t = new AffineTransform();
        t.scale(0.011363636363636364, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getT(double x, double y, double w, double h) {
        Rectangle2D.Double s = new Rectangle2D.Double(37.5, -100.0, 15.0, 100.0);
        Area a1 = new Area(s);
        Rectangle2D.Double s2 = new Rectangle2D.Double(0.0, -100.0, 90.0, 15.0);
        Area a2 = new Area(s2);
        a1.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getG(double x, double y, double w, double h) {
        Ellipse2D.Double s = new Ellipse2D.Double(0.0, -90.0, 90.0, 90.0);
        Area a1 = new Area(s);
        Ellipse2D.Double s2 = new Ellipse2D.Double(15.0, -75.0, 60.0, 60.0);
        Area a2 = new Area(s2);
        a1.subtract(a2);
        Rectangle2D.Double s3 = new Rectangle2D.Double(65.0, -60.0, 30.0, 30.0);
        Area a3 = new Area(s3);
        a1.subtract(a3);
        Rectangle2D.Double s4 = new Rectangle2D.Double(55.0, -40.0, 35.0, 15.0);
        Area a4 = new Area(s4);
        a1.add(a4);
        Rectangle2D.Double s5 = new Rectangle2D.Double(80.0, -40.0, 10.0, 40.0);
        Area a5 = new Area(s5);
        a1.add(a5);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.011111111111111112);
        t.scale(w, h);
        a1.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a1.transform(t);
        return a1;
    }

    private static Area getA(double x, double y, double w, double h) {
        int[] nArray = new int[9];
        nArray[1] = 40;
        nArray[2] = 50;
        nArray[3] = 90;
        nArray[4] = 75;
        nArray[5] = 45;
        nArray[6] = 45;
        nArray[7] = 15;
        int[] nArray2 = new int[9];
        nArray2[1] = -100;
        nArray2[2] = -100;
        nArray2[5] = -80;
        nArray2[6] = -80;
        Polygon s = new Polygon(nArray, nArray2, 9);
        Area a = new Area(s);
        Polygon s2 = new Polygon(new int[]{20, 70, 70, 20}, new int[]{-35, -35, -50, -50}, 4);
        Area a2 = new Area(s2);
        a.add(a2);
        AffineTransform t = new AffineTransform();
        t.scale(0.011111111111111112, 0.01);
        t.scale(w, h);
        a.transform(t);
        t = new AffineTransform();
        t.translate(x, y);
        a.transform(t);
        return a;
    }
}

