/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.galaxy;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.ParameterValidator;
import de.jstacs.utils.galaxy.GalaxyAdaptor;
import java.io.PrintWriter;

public class DataColumnParameter
extends SimpleParameter {
    private String dataRef;

    public DataColumnParameter(String dataRef, String name, String comment, boolean required, Integer defaultVal) throws SimpleParameter.DatatypeNotValidException, SimpleParameter.IllegalValueException {
        super(DataType.INT, name, comment, required, defaultVal);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(String dataRef, String name, String comment, boolean required, ParameterValidator validator, Integer defaultVal) throws ParameterException {
        super(DataType.INT, name, comment, required, validator, defaultVal);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(String dataRef, String name, String comment, boolean required, ParameterValidator validator) throws SimpleParameter.DatatypeNotValidException {
        super(DataType.INT, name, comment, required, validator);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(String dataRef, String name, String comment, boolean required) throws SimpleParameter.DatatypeNotValidException {
        super(DataType.INT, name, comment, required);
        this.dataRef = dataRef;
    }

    public DataColumnParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected String dataTypeToGalaxy() {
        return "data_column";
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine) throws Exception {
        String refPrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.dataRef);
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer buf = new StringBuffer();
        if (this.validator != null && this.validator instanceof GalaxyConvertible) {
            ((GalaxyConvertible)((Object)this.validator)).toGalaxy(String.valueOf(namePrefix) + "_valid", null, depth, buf, null, false);
        }
        String line = "";
        if (addLine) {
            line = "&lt;hr /&gt;";
        }
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"" + this.dataTypeToGalaxy() + "\" name=\"" + namePrefix + "\" data_ref=\"" + refPrefix + "\" force_select=\"" + this.isRequired() + "\"  label=\"" + line + this.getName() + "\" help=\"" + this.getComment() + "\" value=\"" + (this.defaultValue == null ? "" : this.defaultValue) + "\" optional=\"" + !this.isRequired() + "\"");
        descBuffer.append(buf);
        buf = new StringBuffer();
        buf.append("${" + configPrefix + namePrefix + "}");
        XMLParser.addTags(buf, namePrefix);
        configBuffer.append(buf);
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        PrintWriter wr = new PrintWriter("/Users/dev/Downloads/" + namePrefix + ".txt");
        wr.println(command);
        wr.close();
        try {
            String val = XMLParser.extractForTag(command, namePrefix).toString();
            if (!"None".equals(val)) {
                this.setValue(val);
            }
        }
        catch (NullPointerException e) {
            throw new NullPointerException(String.valueOf(this.getName()) + " " + command + " " + namePrefix);
        }
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.dataRef, "dataRef");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        super.extractFurtherInfos(representation);
        this.dataRef = (String)XMLParser.extractObjectForTags(representation, "dataRef");
    }
}

