/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import projects.crispr.PositionPrior;

public class LogisticPositionPrior3
implements PositionPrior {
    private double a;
    private double b;
    private double d;
    private double dp;
    private boolean fixA;
    private boolean fixB;
    private boolean fixD;

    public LogisticPositionPrior3(Double a, Double b, Double c) {
        if (a == null) {
            this.fixA = false;
        } else {
            this.a = a;
            this.fixA = true;
        }
        if (b == null) {
            this.fixB = false;
        } else {
            this.b = b;
            this.fixB = true;
        }
        if (c == null) {
            this.fixD = false;
        } else {
            this.d = c;
            this.dp = Math.log(this.d) - Math.log1p(-this.d);
            this.fixD = true;
        }
    }

    @Override
    public LogisticPositionPrior3 clone() throws CloneNotSupportedException {
        return (LogisticPositionPrior3)super.clone();
    }

    @Override
    public double getLogScore(int position) {
        double temp = Math.exp(-Math.exp(this.a) * ((double)position - this.b));
        if (Double.isInfinite(temp)) {
            return Math.log(this.d);
        }
        return Math.log1p(this.d * temp) - Math.log1p(temp);
    }

    @Override
    public double getLogScoreAndPartialDerivation(int position, IntList indices, DoubleList partialDer) {
        double t;
        double temp = Math.exp(-Math.exp(this.a) * ((double)position - this.b));
        int off = partialDer.length();
        double sc = Double.isInfinite(temp) ? Math.log(this.d) : Math.log1p(this.d * temp) - Math.log1p(temp);
        double v = 1.0 / (1.0 + this.d * temp) * temp;
        double w = 1.0 / (1.0 + temp) * temp;
        if (Double.isInfinite(temp)) {
            v = 1.0 / this.d;
            w = 1.0;
        }
        int i = 0;
        if (!this.fixA) {
            indices.add(i);
            t = -Math.exp(this.a) * ((double)position - this.b);
            partialDer.add(v * this.d * t - w * t);
            ++i;
        }
        if (!this.fixB) {
            indices.add(i);
            t = Math.exp(this.a);
            partialDer.add(v * this.d * t - w * t);
            ++i;
        }
        if (!this.fixD) {
            indices.add(i);
            partialDer.add(v * this.d * this.d * Math.exp(-this.dp));
        }
        i = off;
        while (i < partialDer.length()) {
            double d = partialDer.get(i);
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                System.out.println(String.valueOf(i - off) + " " + d + " " + temp + " " + sc + " " + v + " " + w + " [" + this.a + ", " + this.b + ", " + this.d + "]");
                System.exit(1);
            }
            ++i;
        }
        return sc;
    }

    @Override
    public int getNumberOfParameters() {
        return (this.fixA ? 0 : 1) + (this.fixB ? 0 : 1) + (this.fixD ? 0 : 1);
    }

    @Override
    public void setParameters(double[] pars, int off) {
        if (!this.fixA) {
            this.a = pars[off];
            ++off;
        }
        if (!this.fixB) {
            this.b = pars[off];
            ++off;
        }
        if (!this.fixD) {
            this.dp = pars[off];
            this.d = 1.0 / (1.0 + Math.exp(-this.dp));
        }
    }

    @Override
    public double[] getCurrentParameterValues() {
        DoubleList list = new DoubleList();
        if (!this.fixA) {
            list.add(this.a);
        }
        if (!this.fixB) {
            list.add(this.b);
        }
        if (!this.fixD) {
            list.add(this.dp);
        }
        return list.toArray();
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int off) {
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) {
        if (!this.fixA) {
            this.a = Math.log(0.5);
        }
        if (!this.fixB) {
            this.b = 10.0;
        }
        if (!this.fixD) {
            this.d = 0.5;
            this.dp = Math.log(this.d) - Math.log1p(-this.d);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[" + this.a + "," + this.b + ", " + this.d + "]\n");
        int i = 0;
        while (i < 20) {
            buf.append(String.valueOf(Math.exp(this.getLogScore(i))) + ", ");
            ++i;
        }
        return buf.toString();
    }
}

