/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractVariableLengthDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;

public class MatchModel
extends AbstractVariableLengthDiffSM {
    private double ess;

    public MatchModel(double ess) {
        super(DNAAlphabetContainer.SINGLETON);
        this.ess = ess;
    }

    @Override
    public MatchModel clone() throws CloneNotSupportedException {
        MatchModel clone = (MatchModel)super.clone();
        return clone;
    }

    @Override
    public double getLogNormalizationConstant(int length) {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex, int length) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setStatisticForHyperparameters(int[] length, double[] weight) throws Exception {
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    @Override
    public void setParameters(double[] params, int start) {
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String toString(NumberFormat nf) {
        return this.getInstanceName();
    }

    @Override
    public StringBuffer toXML() {
        return null;
    }

    private int getGRNASymbol(Sequence seq, int position) {
        Sequence grna = ((ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
        return grna.discreteVal(position);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int startpos, int endpos) {
        double ls = 0.0;
        int i = startpos;
        while (i <= endpos) {
            int grna = this.getGRNASymbol(seq, i);
            ls = grna != seq.discreteVal(i) ? (ls += -100.0) : (ls += 0.0);
            ++i;
        }
        return ls;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int startpos, int endpos, IntList indices, DoubleList partialDer) {
        return this.getLogScoreFor(seq, startpos, endpos);
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
    }
}

