/*
 * Decompiled with CFR 0.152.
 */
package projects.properties;

import de.jstacs.NotTrainedException;
import de.jstacs.data.DataSet;
import de.jstacs.data.DinucleotideProperty;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.IndependentProductDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.UniformDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.SingleGaussianDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.MixtureDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import java.util.Arrays;

public class PropertyWrapperDiffSM
extends AbstractDifferentiableStatisticalModel
implements Mutable {
    private IndependentProductDiffSM model;
    private DinucleotideProperty[] props;

    public PropertyWrapperDiffSM(DinucleotideProperty[] props, int length, double ess) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException, WrongSequenceTypeException {
        super(DNAAlphabetContainer.SINGLETON, length);
        DifferentiableStatisticalModel mix = this.getElement(props, ess);
        Object[] array = new DifferentiableStatisticalModel[length];
        Arrays.fill(array, mix);
        array[0] = new UniformDiffSM(DNAAlphabetContainer.SINGLETON, 1, ess);
        int[] len = new int[length];
        Arrays.fill(len, 1);
        this.props = props;
        this.model = new IndependentProductDiffSM(ess, true, (DifferentiableStatisticalModel[])array, len);
    }

    private DifferentiableStatisticalModel getElement(DinucleotideProperty[] prop, double ess) throws CloneNotSupportedException, WrongSequenceTypeException {
        double[][] vals = new double[prop.length][(int)(this.alphabets.getAlphabetLengthAt(0) * this.alphabets.getAlphabetLengthAt(0))];
        double[] priorMeans = new double[prop.length];
        double[] priorPrecs = new double[prop.length];
        DiscreteSequenceEnumerator dse = new DiscreteSequenceEnumerator(this.alphabets, 2, false);
        int i = 0;
        while (i < prop.length) {
            dse.reset();
            int j = 0;
            while (dse.hasMoreElements()) {
                Object seq = dse.nextElement();
                vals[i][j] = prop[i].getProperty((Sequence)seq)[0];
            }
            priorMeans[i] = ToolBox.mean(0, vals[i].length, vals[i]);
            priorPrecs[i] = ToolBox.sd(0, vals[i].length, vals[i]);
            priorPrecs[i] = priorPrecs[i] == 0.0 ? 0.01 : 1.0 / (priorPrecs[i] * priorPrecs[i]);
            ++i;
        }
        int dim = prop.length;
        DifferentiableStatisticalModel[] gaussArray = new SingleGaussianDiffSM[dim];
        int i2 = 0;
        while (i2 < gaussArray.length) {
            gaussArray[i2] = new SingleGaussianDiffSM(DNAAlphabetContainer.SINGLETON, ess / (double)dim, priorMeans[i2], priorPrecs[i2], priorPrecs[i2] / 2.0, false);
            ((SingleGaussianDiffSM)gaussArray[i2]).setDinucleotideProperty(prop[i2]);
            ++i2;
        }
        MixtureDiffSM mix = new MixtureDiffSM(1, true, gaussArray);
        return mix;
    }

    @Override
    public int getLength() {
        return this.model.getLength();
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int startpos, int endpos, IntList indices, DoubleList partialDer) throws WrongLengthException {
        return this.model.getLogScoreAndPartialDerivation(seq, startpos, endpos, indices, partialDer);
    }

    @Override
    public void getLogScoreFor(DataSet data, double[] res) throws Exception {
        this.model.getLogScoreFor(data, res);
    }

    @Override
    public ResultSet getCharacteristics() throws Exception {
        return this.model.getCharacteristics();
    }

    @Override
    public PropertyWrapperDiffSM clone() throws CloneNotSupportedException {
        PropertyWrapperDiffSM clone = (PropertyWrapperDiffSM)super.clone();
        clone.model = this.model.clone();
        return clone;
    }

    @Override
    public double getLogNormalizationConstant() {
        return this.model.getLogNormalizationConstant();
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return this.model.getLogPartialNormalizationConstant(parameterIndex);
    }

    @Override
    public double getESS() {
        return this.model.getESS();
    }

    @Override
    public String getInstanceName() {
        return this.model.getInstanceName();
    }

    @Override
    public double getLogPriorTerm() {
        return this.model.getLogPriorTerm();
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        this.model.addGradientOfLogPriorTerm(grad, start);
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return this.model.getCurrentParameterValues();
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        return this.model.getLogScoreAndPartialDerivation(seq, start, indices, partialDer);
    }

    @Override
    public DataSet emitDataSet(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        return this.model.emitDataSet(numberOfSequences, seqLength);
    }

    public boolean equals(Object obj) {
        return this.model.equals(obj);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int startpos, int endpos) throws WrongLengthException {
        return this.model.getLogScoreFor(seq, startpos, endpos);
    }

    @Override
    public double[] getLogScoreFor(DataSet data) throws Exception {
        return this.model.getLogScoreFor(data);
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return this.model.getNumericalCharacteristics();
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return this.model.getSizeOfEventSpaceForRandomVariablesOfParameter(index);
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.model.initializeFunction(index, freeParams, data, weights);
    }

    @Override
    public int getNumberOfParameters() {
        return this.model.getNumberOfParameters();
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return this.model.getNumberOfRecommendedStarts();
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.model.setParameters(params, start);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        return this.model.getLogScoreFor(seq, start);
    }

    @Override
    public String toString(NumberFormat nf) {
        return this.model.toString(nf);
    }

    public int getMotifLength(int motif) {
        return this.model.getMotifLength(motif);
    }

    @Override
    public boolean isInitialized() {
        return this.model.isInitialized();
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.model.initializeFunctionRandomly(freeParams);
    }

    @Override
    public boolean isNormalized() {
        return this.model.isNormalized();
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        return this.model.getMaximalMarkovOrder();
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.model, "model");
        XMLParser.appendObjectWithTags(sb, this.props, "props");
        XMLParser.addTags(sb, this.getClass().getSimpleName());
        return sb;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.model = (IndependentProductDiffSM)XMLParser.extractObjectForTags(xml, "model");
        this.props = (DinucleotideProperty[])XMLParser.extractObjectForTags(xml, "props");
        this.length = this.model.getLength();
        this.alphabets = DNAAlphabetContainer.SINGLETON;
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        int add = offsetRight - offsetLeft;
        try {
            DifferentiableStatisticalModel[] models = ArrayHandler.cast(DifferentiableStatisticalModel.class, this.model.getFunctions());
            DifferentiableStatisticalModel[] models2 = new DifferentiableStatisticalModel[models.length + add];
            int i = 0;
            while (i < models2.length) {
                models2[i] = i + offsetLeft <= 0 || i + offsetLeft >= models.length ? this.getElement(this.props, models[0].getESS()) : models[i + offsetLeft];
                ++i;
            }
            models2[0] = models[0];
            int[] len = new int[models2.length];
            Arrays.fill(len, 1);
            this.model = new IndependentProductDiffSM(models[0].getESS(), true, models2, len);
            System.out.println(this.model.getLength());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.flush();
            return false;
        }
    }
}

