/*
 * Decompiled with CFR 0.152.
 */
package projects.taleningner;

import cern.jet.stat.Gamma;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import java.util.Random;

public class BinomialDiffSS
extends AbstractDifferentiableSequenceScore {
    private double p;
    private double logP;
    private double log1mP;
    private double n;
    private boolean isInitialized;

    public BinomialDiffSS(AlphabetContainer cont, double n) {
        super(cont, 1);
        this.n = n;
    }

    @Override
    public BinomialDiffSS clone() throws CloneNotSupportedException {
        BinomialDiffSS clone = (BinomialDiffSS)super.clone();
        return clone;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.p = 0.0;
        int i = 0;
        while (i < data[index].getNumberOfElements()) {
            this.p += data[index].getElementAt(i).continuousVal(0) * weights[index][i];
            ++i;
        }
        this.p /= this.n;
        this.p /= ToolBox.sum(weights[index]);
        System.out.println(String.valueOf(index) + " " + this.p);
        this.logP = Math.log(this.p);
        this.log1mP = Math.log1p(-this.p);
        this.isInitialized = true;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        Random r = new Random();
        this.p = r.nextDouble();
        this.logP = Math.log(this.p);
        this.log1mP = Math.log1p(-this.p);
        this.isInitialized = true;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double v = seq.continuousVal(start);
        indices.add(0);
        partialDer.add(v / this.p - (this.n - v) / (1.0 - this.p));
        return Gamma.logGamma(this.n + 1.0) - Gamma.logGamma(v + 1.0) - Gamma.logGamma(this.n - v + 1.0) + v * this.logP + (this.n - v) * this.log1mP;
    }

    @Override
    public int getNumberOfParameters() {
        return 1;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[]{this.logP};
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.logP = params[start];
        this.p = Math.exp(this.logP);
        this.log1mP = Math.log1p(-this.p);
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double v = seq.continuousVal(start);
        return Gamma.logGamma(this.n + 1.0) - Gamma.logGamma(v + 1.0) - Gamma.logGamma(this.n - v + 1.0) + v * this.logP + (this.n - v) * this.log1mP;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public String toString(NumberFormat nf) {
        return "Binom(" + this.n + ", " + this.p + ")";
    }

    @Override
    public StringBuffer toXML() {
        return null;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
    }
}

