/*
 * Decompiled with CFR 0.152.
 */
package projects.taleningner;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;

public class TALENDiffSM
extends AbstractDifferentiableSequenceScore {
    private DifferentiableSequenceScore monomerScore;
    private DifferentiableSequenceScore spacerScore;
    private int monomerScoreLength;
    private double[][] featureSupport;
    private boolean filter;

    public TALENDiffSM(DifferentiableSequenceScore monomerScore, DifferentiableSequenceScore spacerScore, int monomerScoreLength, boolean filter) {
        super(new AlphabetContainer((Alphabet)new ContinuousAlphabet(true)), monomerScoreLength * 2 + 1);
        this.monomerScore = monomerScore;
        this.spacerScore = spacerScore;
        this.monomerScoreLength = monomerScoreLength;
        this.featureSupport = null;
        this.filter = filter;
    }

    private void adjustFeatureSupport(Sequence seq, int start) {
        if (this.featureSupport == null) {
            this.featureSupport = new double[2][this.monomerScoreLength + 1];
            Arrays.fill(this.featureSupport[0], Double.POSITIVE_INFINITY);
            Arrays.fill(this.featureSupport[1], Double.NEGATIVE_INFINITY);
        }
        int i = 0;
        while (i < this.monomerScoreLength) {
            double min = Math.min(seq.continuousVal(i + start), seq.continuousVal(i + this.monomerScoreLength + start));
            double max = Math.max(seq.continuousVal(i + start), seq.continuousVal(i + this.monomerScoreLength + start));
            if (min < this.featureSupport[0][i]) {
                this.featureSupport[0][i] = min;
            }
            if (max > this.featureSupport[1][i]) {
                this.featureSupport[1][i] = max;
            }
            ++i;
        }
        if (seq.continuousVal(start + this.monomerScoreLength * 2) < this.featureSupport[0][this.monomerScoreLength]) {
            this.featureSupport[0][this.monomerScoreLength] = seq.continuousVal(start + this.monomerScoreLength * 2);
        }
        if (seq.continuousVal(start + this.monomerScoreLength * 2) > this.featureSupport[1][this.monomerScoreLength]) {
            this.featureSupport[1][this.monomerScoreLength] = seq.continuousVal(start + this.monomerScoreLength * 2);
        }
    }

    private Sequence filterBySupport(Sequence seq, int start) throws WrongAlphabetException, WrongSequenceTypeException {
        double[] temp = null;
        int i = 0;
        while (i < this.monomerScoreLength) {
            if (seq.continuousVal(i + start) < this.featureSupport[0][i] || seq.continuousVal(i + start) > this.featureSupport[1][i] || seq.continuousVal(i + start + this.monomerScoreLength) < this.featureSupport[0][i] || seq.continuousVal(i + start + this.monomerScoreLength) > this.featureSupport[1][i]) {
                temp = new double[seq.getLength()];
                int j = 0;
                while (j < this.monomerScoreLength) {
                    double val = seq.continuousVal(j + start);
                    temp[j] = val < this.featureSupport[0][j] ? this.featureSupport[0][j] : (val > this.featureSupport[1][j] ? this.featureSupport[1][j] : val);
                    val = seq.continuousVal(j + start + this.monomerScoreLength);
                    temp[j + this.monomerScoreLength] = val < this.featureSupport[0][j] ? this.featureSupport[0][j] : (val > this.featureSupport[1][j] ? this.featureSupport[1][j] : val);
                    ++j;
                }
                temp[2 * this.monomerScoreLength] = seq.continuousVal(start + 2 * this.monomerScoreLength);
                return new ArbitrarySequence(seq.getAlphabetContainer(), temp);
            }
            ++i;
        }
        return seq;
    }

    public TALENDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public DifferentiableSequenceScore getMonomerScore() {
        return this.monomerScore;
    }

    @Override
    public TALENDiffSM clone() throws CloneNotSupportedException {
        TALENDiffSM clone = (TALENDiffSM)super.clone();
        clone.monomerScore = this.monomerScore.clone();
        clone.spacerScore = this.spacerScore.clone();
        return clone;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        DataSet[] alls = new DataSet[data.length];
        double[][] allws = new double[data.length][];
        DataSet[] spacers = new DataSet[data.length];
        double[][] spacerws = new double[data.length][];
        boolean isnull = false;
        int j = 0;
        while (j < alls.length) {
            DataSet left = data[j].getInfixDataSet(0, this.monomerScoreLength);
            DataSet right = data[j].getInfixDataSet(this.monomerScoreLength, this.monomerScoreLength);
            DataSet all = DataSet.union(left, right);
            double[] allw = new double[all.getNumberOfElements()];
            if (weights != null) {
                System.arraycopy(weights[j], 0, allw, 0, weights[j].length);
                System.arraycopy(weights[j], 0, allw, weights[j].length, weights[j].length);
            } else {
                Arrays.fill(allw, 1.0);
            }
            DataSet spacer = data[j].getInfixDataSet(this.monomerScoreLength * 2, 1);
            LinkedList<Sequence> spacerl = new LinkedList<Sequence>();
            DoubleList spacerw = new DoubleList();
            int i = 0;
            while (i < spacer.getNumberOfElements()) {
                if (!Double.isNaN(spacer.getElementAt(i).continuousVal(0))) {
                    spacerl.add(spacer.getElementAt(i));
                    spacerw.add(weights[j][i]);
                }
                ++i;
            }
            alls[j] = all;
            allws[j] = allw;
            if (spacerl.size() > 0) {
                spacers[j] = new DataSet("", spacerl);
                spacerws[j] = spacerw.toArray();
            } else {
                isnull = true;
            }
            ++j;
        }
        this.monomerScore.initializeFunction(index, freeParams, alls, allws);
        if (!isnull) {
            System.out.println(spacers[index]);
            System.out.println(Arrays.toString(spacerws[index]));
            this.spacerScore.initializeFunction(index, freeParams, spacers, spacerws);
            System.out.println(this.spacerScore);
        } else {
            this.spacerScore.initializeFunctionRandomly(freeParams);
        }
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.monomerScore.initializeFunctionRandomly(freeParams);
        this.spacerScore.initializeFunctionRandomly(freeParams);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        if (this.filter) {
            this.adjustFeatureSupport(seq, start);
        }
        double score = 0.0;
        score = this.monomerScore.getLogScoreAndPartialDerivation(seq, start, indices, partialDer);
        score += this.monomerScore.getLogScoreAndPartialDerivation(seq, start + this.monomerScoreLength, indices, partialDer);
        IntList temp = new IntList();
        if (!Double.isNaN(seq.continuousVal(this.monomerScoreLength * 2 + start))) {
            score += this.spacerScore.getLogScoreAndPartialDerivation(seq, start + 2 * this.monomerScoreLength, temp, partialDer);
        }
        int off = this.monomerScore.getNumberOfParameters();
        int i = 0;
        while (i < temp.length()) {
            indices.add(temp.get(i) + off);
            ++i;
        }
        return score;
    }

    @Override
    public int getNumberOfParameters() {
        return this.monomerScore.getNumberOfParameters() + this.spacerScore.getNumberOfParameters();
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] temp = new double[this.getNumberOfParameters()];
        System.arraycopy(this.monomerScore.getCurrentParameterValues(), 0, temp, 0, this.monomerScore.getNumberOfParameters());
        System.arraycopy(this.spacerScore.getCurrentParameterValues(), 0, temp, this.monomerScore.getNumberOfParameters(), this.spacerScore.getNumberOfParameters());
        return temp;
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.monomerScore.setParameters(params, start);
        this.spacerScore.setParameters(params, start += this.monomerScore.getNumberOfParameters());
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 1;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        if (this.featureSupport != null) {
            try {
                seq = this.filterBySupport(seq, start);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            start = 0;
        }
        double scorel = this.monomerScore.getLogScoreFor(seq, start);
        double scorer = this.monomerScore.getLogScoreFor(seq, start + this.monomerScoreLength);
        double score = 0.0;
        score = scorel + scorer;
        if (!Double.isNaN(seq.continuousVal(this.monomerScoreLength * 2 + start))) {
            score += this.spacerScore.getLogScoreFor(seq, start + 2 * this.monomerScoreLength);
        }
        return score;
    }

    @Override
    public boolean isInitialized() {
        return this.monomerScore.isInitialized() && this.spacerScore.isInitialized();
    }

    @Override
    public String toString(NumberFormat nf) {
        return String.valueOf(this.monomerScore.toString()) + "\n" + this.spacerScore.toString() + "\n" + (this.featureSupport == null ? "" : String.valueOf(Arrays.toString(this.featureSupport[0])) + "\n" + Arrays.toString(this.featureSupport[1]));
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, this.monomerScore, "monomerScore");
        XMLParser.appendObjectWithTags(sb, this.spacerScore, "spacerScore");
        XMLParser.appendObjectWithTags(sb, this.monomerScoreLength, "monomerScoreLength");
        XMLParser.appendObjectWithTags(sb, this.featureSupport, "featureSupport");
        XMLParser.appendObjectWithTags(sb, this.filter, "filter");
        XMLParser.addTags(sb, "TALENDiffSM");
        return sb;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "TALENDiffSM");
        this.monomerScore = (DifferentiableSequenceScore)XMLParser.extractObjectForTags(xml, "monomerScore");
        this.spacerScore = (DifferentiableSequenceScore)XMLParser.extractObjectForTags(xml, "spacerScore");
        this.monomerScoreLength = (Integer)XMLParser.extractObjectForTags(xml, "monomerScoreLength");
        this.featureSupport = (double[][])XMLParser.extractObjectForTags(xml, "featureSupport");
        this.filter = (Boolean)XMLParser.extractObjectForTags(xml, "filter");
        this.alphabets = new AlphabetContainer((Alphabet)new ContinuousAlphabet(true));
        this.length = this.monomerScoreLength * 2 + 1;
    }
}

