/*
 * Decompiled with CFR 0.152.
 */
package projects.taleningner;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;

public class WeightedWrapperDiffSS
extends AbstractDifferentiableSequenceScore {
    private DifferentiableSequenceScore internal;
    private double w;

    public WeightedWrapperDiffSS(DifferentiableSequenceScore internal) {
        super(internal.getAlphabetContainer(), internal.getLength());
        this.internal = internal;
        this.w = 1.0;
    }

    @Override
    public WeightedWrapperDiffSS clone() throws CloneNotSupportedException {
        WeightedWrapperDiffSS clone = (WeightedWrapperDiffSS)super.clone();
        clone.internal = this.internal.clone();
        return clone;
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.internal.initializeFunction(index, freeParams, data, weights);
        this.w = 1.0;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.internal.initializeFunctionRandomly(freeParams);
        this.w = 1.0;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int off = partialDer.length();
        double sc = this.internal.getLogScoreAndPartialDerivation(seq, start, indices, partialDer);
        partialDer.multiply(off, partialDer.length(), this.w);
        indices.add(this.internal.getNumberOfParameters());
        partialDer.add(this.w * sc);
        return this.w * sc;
    }

    @Override
    public int getNumberOfParameters() {
        return this.internal.getNumberOfParameters() + 1;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] temp = new double[this.getNumberOfParameters()];
        System.arraycopy(this.internal.getCurrentParameterValues(), 0, temp, 0, this.internal.getNumberOfParameters());
        temp[temp.length - 1] = Math.log(this.w);
        return temp;
    }

    @Override
    public void setParameters(double[] params, int start) {
        this.internal.setParameters(params, start);
        this.w = Math.exp(params[start + this.internal.getNumberOfParameters()]);
    }

    @Override
    public String getInstanceName() {
        return "Wrapper(" + this.internal.getInstanceName() + ")";
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        return this.w * this.internal.getLogScoreFor(seq, start);
    }

    @Override
    public boolean isInitialized() {
        return this.internal.isInitialized();
    }

    @Override
    public String toString(NumberFormat nf) {
        return String.valueOf(nf.format(this.w)) + "\n" + this.internal.toString(nf);
    }

    @Override
    public StringBuffer toXML() {
        return null;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
    }
}

