/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.SubclassFinder;
import de.jstacs.utils.Time;

public class MultipleIterationsCondition
extends AbstractTerminationCondition {
    private int thresh;
    private int number;
    private AbstractTerminationCondition test;

    public MultipleIterationsCondition(int threshold, AbstractTerminationCondition condition) throws Exception {
        this(new MultipleIterationsConditionParameterSet(threshold, condition));
    }

    public MultipleIterationsCondition(MultipleIterationsConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    public MultipleIterationsCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        this.number = this.test.doNextIteration(iteration, f_last, f_current, gradient, direction, alpha, t) ? 0 : ++this.number;
        return this.number < this.thresh;
    }

    @Override
    public boolean isSimple() {
        return this.test.isSimple();
    }

    @Override
    protected String getXmlTag() {
        return "MultipleIterationsCondition";
    }

    @Override
    protected void set() {
        try {
            this.thresh = (Integer)this.parameter.getParameterAt(0).getValue();
            this.test = (AbstractTerminationCondition)((AbstractTerminationCondition.AbstractTerminationConditionParameterSet)this.parameter.getParameterAt(1).getValue()).getInstance();
        }
        catch (ParameterSetParser.NotInstantiableException e) {
            RuntimeException ex = new RuntimeException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public static class MultipleIterationsConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public MultipleIterationsConditionParameterSet() throws Exception {
            super((Class<? extends AbstractTerminationCondition>)MultipleIterationsCondition.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "threshold", "the number of iterations the provided condition must fail to stop the optimization", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE))});
            this.parameters.add(new Parameter[]{SubclassFinder.getSelectionParameter(AbstractTerminationCondition.AbstractTerminationConditionParameterSet.class, AbstractTerminationCondition.AbstractTerminationConditionParameterSet.class.getPackage().getName(), "Termination condition", "Select a termination condition.", true)});
        }

        public MultipleIterationsConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public MultipleIterationsConditionParameterSet(int threshold, AbstractTerminationCondition condition) throws Exception {
            this();
            this.getParameterAt(0).setValue(threshold);
            this.getParameterAt(1).setValue(condition.parameter);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the MultipleIterationsCondition";
        }

        @Override
        public String getInstanceName() {
            return "MultipleIterationsConditionParameterSet";
        }
    }
}

