/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.io.File;
import java.io.FileFilter;

public class CombinedFileFilter
implements FileFilter {
    private int anz;
    private FileFilter[] filter;

    public CombinedFileFilter(int minAccepted, FileFilter ... filter) {
        if (minAccepted < 0 || minAccepted > filter.length) {
            throw new IllegalArgumentException("Check the value for the parameter anz");
        }
        this.anz = minAccepted;
        this.filter = (FileFilter[])filter.clone();
    }

    @Override
    public boolean accept(File pathname) {
        int accepted = 0;
        int i = 0;
        while (i < this.filter.length) {
            accepted += this.filter[i].accept(pathname) ? 1 : 0;
            ++i;
        }
        return accepted >= this.anz;
    }

    public String toString() {
        String desc = "filter (to be accepted: " + this.anz + "):\n";
        int i = 0;
        while (i < this.filter.length) {
            desc = String.valueOf(desc) + this.filter[i].toString() + "\n";
            ++i;
        }
        return desc;
    }
}

