/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.btMeasures;

import de.jstacs.DataType;
import de.jstacs.algorithms.graphs.MST;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.Measure;

public class BTExplainingAwayResidual
extends Measure {
    public BTExplainingAwayResidual(double[] ess) throws Exception {
        this(new BTExplainingAwayResidualParameterSet(ess));
    }

    public BTExplainingAwayResidual(BTExplainingAwayResidualParameterSet parameters) throws CloneNotSupportedException {
        super(parameters);
    }

    public BTExplainingAwayResidual(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    @Override
    public String getInstanceName() {
        return "Bayesian tree with explaining away residual";
    }

    @Override
    public int[][] getParents(DataSet fg, DataSet bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        double[] ess = ((BTExplainingAwayResidualParameterSet)this.parameters).getEss();
        double[][][][] statFg = BTExplainingAwayResidual.getStatistics(fg, weightsFg, length, ess[0]);
        double[][][][] statBg = BTExplainingAwayResidual.getStatistics(bg, weightsBg, length, ess[1]);
        double nFg = BTExplainingAwayResidual.sum(weightsFg) + ess[0];
        double nBg = BTExplainingAwayResidual.sum(weightsBg) + ess[1];
        double[][] ear = BTExplainingAwayResidual.getEAR(statFg, statBg, nFg, nBg);
        int[][] p = MST.kruskal(ear);
        int[][] parents = new int[length][1];
        int i = 0;
        while (i < parents.length) {
            parents[i][0] = i;
            ++i;
        }
        i = 0;
        while (i < p.length) {
            int idx = p[i][1];
            parents[idx] = new int[2];
            parents[idx][0] = p[i][0];
            parents[idx][1] = idx;
            ++i;
        }
        return parents;
    }

    @Override
    public String getXMLTag() {
        return "btExplainingAwayResidual";
    }

    public static class BTExplainingAwayResidualParameterSet
    extends Measure.MeasureParameterSet {
        public BTExplainingAwayResidualParameterSet() throws SimpleParameter.DatatypeNotValidException {
            super((Class<? extends Measure>)BTExplainingAwayResidual.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true)});
        }

        public BTExplainingAwayResidualParameterSet(double[] ess) throws Exception {
            this();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
        }

        public BTExplainingAwayResidualParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        @Override
        public String getInstanceComment() {
            return "Bayesian tree - explaining away residual";
        }

        @Override
        public String getInstanceName() {
            return "Build a Bayesian tree using explaining away residual as structure measure.";
        }
    }
}

