/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.AbstractMixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.DurationDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.PositionDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.UniformDurationDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.Arrays;

public class ExtendedZOOPSDiffSM
extends AbstractMixtureDiffSM
implements MutableMotifDiscoverer {
    public static final boolean CONTAINS_ALWAYS_A_MOTIF = true;
    public static final boolean CONTAINS_SOMETIMES_A_MOTIF = false;
    private double[][] simpleScore;
    private double[] bgHelp;
    private int[] anz;
    private int[] currentPos;
    private double ess;
    private int bgIndex;
    private boolean type;
    private boolean plugInBg;
    private HomogeneousDiffSM bg;

    private static DifferentiableStatisticalModel[] getDifferentiableStatisticalModels(int length, HomogeneousDiffSM bg, DifferentiableStatisticalModel[] motif, DurationDiffSM[] posPrior) {
        int m = motif.length;
        if (m == 0) {
            throw new IllegalArgumentException("Please insert at least one DifferentiableSequenceScore for a motif.");
        }
        DifferentiableStatisticalModel[] erg = new DifferentiableStatisticalModel[2 * m + 1];
        if (posPrior == null) {
            posPrior = new DurationDiffSM[m];
        } else if (m != posPrior.length) {
            throw new IllegalArgumentException("The number of motifs and durations has to be the same.");
        }
        int i = 0;
        int l = -1;
        AlphabetContainer seqABC = bg.getAlphabetContainer();
        if (!seqABC.isSimple()) {
            throw new IllegalArgumentException("The AlphabetContainer of the motif and background models has to be simple.");
        }
        AlphabetContainer posABC = null;
        while (i < m) {
            if (!seqABC.checkConsistency(motif[i].getAlphabetContainer())) {
                throw new IllegalArgumentException("The " + i + "-th motif model is not correct. Check the AlphabetContainer.");
            }
            erg[2 * i] = motif[i];
            if (posPrior[i] != null) {
                if (posPrior[i].getMin() < 0 || posPrior[i].getMax() > length - motif[i].getLength()) {
                    throw new IllegalArgumentException("The " + i + "-th model for the positional information is not correct. Check the AlphabetContainer.");
                }
                erg[2 * i + 1] = posPrior[i];
            } else {
                if (posABC == null || motif[i].getLength() != l) {
                    posABC = new AlphabetContainer((Alphabet)new DiscreteAlphabet(0, length - motif[i].getLength()));
                }
                erg[2 * i + 1] = new UniformDurationDiffSM(0, length - motif[i].getLength());
                l = motif[i].getLength();
            }
            ++i;
        }
        if (!seqABC.checkConsistency(bg.getAlphabetContainer())) {
            throw new IllegalArgumentException("The background model is not correct. Check the AlphabetContainer.");
        }
        erg[2 * i] = bg;
        return erg;
    }

    public ExtendedZOOPSDiffSM(boolean type, int length, int starts, boolean plugIn, HomogeneousDiffSM bg, DifferentiableStatisticalModel motif, DurationDiffSM posPrior, boolean plugInBg) throws Exception {
        this(type, length, starts, plugIn, bg, new DifferentiableStatisticalModel[]{motif}, new DurationDiffSM[]{posPrior}, plugInBg);
    }

    public ExtendedZOOPSDiffSM(boolean type, int length, int starts, boolean plugIn, HomogeneousDiffSM bg, DifferentiableStatisticalModel[] motif, DurationDiffSM[] posPrior, boolean plugInBg) throws Exception {
        super(length, starts, motif.length + (type ? 0 : 1), true, plugIn, ExtendedZOOPSDiffSM.getDifferentiableStatisticalModels(length, bg, motif, posPrior));
        if (!this.alphabets.isSimple()) {
            throw new IllegalArgumentException("The AlphabetContainer has to be simple.");
        }
        this.type = type;
        this.plugInBg = plugInBg;
        this.initObject();
        this.setHyperParametersOfBackgroundModel();
        this.computeLogGammaSum();
    }

    public ExtendedZOOPSDiffSM(StringBuffer source) throws NonParsableException {
        super(source);
        this.initObject();
    }

    private void initObject() {
        this.bgIndex = this.function.length - 1;
        this.bg = (HomogeneousDiffSM)this.function[this.bgIndex];
        this.simpleScore = new double[(this.function.length - 1) / 2][];
        this.ess = this.type ? 0.0 : this.bg.getESS();
        int i = 0;
        while (i < this.bgIndex) {
            this.ess += this.function[i].getESS();
            i += 2;
        }
        this.createSimpleScore();
        this.initBgHelp();
        this.anz = new int[this.componentScore.length + 1];
        this.currentPos = new int[1];
    }

    private void createSimpleScore() {
        int i = 0;
        while (i < this.bgIndex) {
            this.simpleScore[i / 2] = new double[(int)this.function[i + 1].getAlphabetContainer().getAlphabetLengthAt(0)];
            i += 2;
        }
    }

    private void setHyperParametersOfBackgroundModel() throws Exception {
        int[] len = new int[this.length + 1];
        int[] l = new int[1];
        int i = 0;
        while (i <= this.length) {
            len[i] = i;
            ++i;
        }
        double[] weight = new double[len.length];
        i = 0;
        while (i < this.bgIndex) {
            boolean okay;
            int m = this.length - this.function[i].getLength();
            DurationDiffSM dur = (DurationDiffSM)this.function[i + 1];
            int anz = 0;
            dur.reset();
            do {
                dur.getInternalPosition(l);
                if (l[0] <= m) {
                    ++anz;
                    okay = dur.next();
                    continue;
                }
                okay = false;
            } while (okay);
            double w = this.function[i].getESS() / (double)anz;
            dur.reset();
            do {
                dur.getInternalPosition(l);
                if (l[0] <= m) {
                    int n = l[0];
                    weight[n] = weight[n] + w;
                    int n2 = m - l[0];
                    weight[n2] = weight[n2] + w;
                    okay = dur.next();
                    continue;
                }
                okay = false;
            } while (okay);
            i += 2;
        }
        if (!this.type) {
            int n = this.length;
            weight[n] = weight[n] + this.bg.getESS();
        }
        this.bg.setStatisticForHyperparameters(len, weight);
    }

    @Override
    public ExtendedZOOPSDiffSM clone() throws CloneNotSupportedException {
        ExtendedZOOPSDiffSM clone = (ExtendedZOOPSDiffSM)super.clone();
        clone.simpleScore = new double[this.simpleScore.length][];
        int i = 0;
        while (i < this.simpleScore.length) {
            clone.simpleScore[i] = new double[this.simpleScore[i].length];
            ++i;
        }
        clone.bg = (HomogeneousDiffSM)clone.function[this.bgIndex];
        clone.bgHelp = (double[])this.bgHelp.clone();
        clone.anz = (int[])this.anz.clone();
        clone.currentPos = (int[])this.currentPos.clone();
        return clone;
    }

    @Override
    public double getHyperparameterForHiddenParameter(int index) {
        return this.function[2 * index].getESS();
    }

    @Override
    protected double getLogNormalizationConstantForComponent(int i) {
        if ((i *= 2) >= 0 && i < this.bgIndex) {
            int l = this.length - this.function[i].getLength();
            return this.function[i].getLogNormalizationConstant() + this.function[i + 1].getLogNormalizationConstant() + this.bg.getLogNormalizationConstant(l);
        }
        if (i == this.bgIndex) {
            return this.bg.getLogNormalizationConstant();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        double res;
        int[] ind;
        if (this.isNormalized()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        if ((ind = this.getIndices(parameterIndex))[0] == this.function.length) {
            res = this.partNorm[ind[1]];
        } else if (ind[0] == this.bgIndex) {
            res = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.bgIndex) {
                int l = this.length - this.function[i].getLength();
                res = Normalisation.getLogSum(res, this.logHiddenPotential[i / 2] + this.function[i].getLogNormalizationConstant() + this.function[i + 1].getLogNormalizationConstant() + this.bg.getLogPartialNormalizationConstant(ind[1], l));
                i += 2;
            }
            if (!this.type) {
                res = Normalisation.getLogSum(res, this.logHiddenPotential[this.bgIndex / 2] + this.bg.getLogPartialNormalizationConstant(ind[1]));
            }
        } else if (ind[0] % 2 == 0) {
            int l = this.length - this.function[ind[0]].getLength();
            res = this.logHiddenPotential[ind[0] / 2] + this.function[ind[0]].getLogPartialNormalizationConstant(ind[1]) + this.function[ind[0] + 1].getLogNormalizationConstant() + this.bg.getLogNormalizationConstant(l);
        } else {
            int l = this.length - this.function[ind[0] - 1].getLength();
            res = this.logHiddenPotential[ind[0] / 2] + this.function[ind[0] - 1].getLogNormalizationConstant() + this.function[ind[0]].getLogPartialNormalizationConstant(ind[1]) + this.bg.getLogNormalizationConstant(l);
        }
        return res;
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int n = this.function.length - 1;
        int i = 0;
        while (i < n) {
            this.function[i].initializeFunctionRandomly(freeParams);
            ++i;
        }
        if (!this.plugInBg) {
            this.bg.initializeFunctionRandomly(freeParams);
        }
        if (this.optimizeHidden) {
            this.initializeHiddenPotentialRandomly();
        }
        this.init(freeParams);
        this.initBgHelp();
    }

    private void initBgHelp() {
        int n = this.bg.getNumberOfParameters();
        if (n == -1) {
            this.bgHelp = new double[0];
        } else if (this.bgHelp == null || this.bgHelp.length != n) {
            this.bgHelp = new double[n];
        }
    }

    @Override
    public String getInstanceName() {
        String erg = "hiddenMotifsMixture(" + (this.type ? "contains always a motif" : "contains sometimes a motif") + "; bg = " + this.bg.getInstanceName();
        int i = 0;
        while (i < this.function.length - 1) {
            erg = String.valueOf(erg) + "; (" + this.function[i].getInstanceName() + ", " + this.function[i + 1].getInstanceName() + ")";
            i += 2;
        }
        return String.valueOf(erg) + ")";
    }

    protected int fillComponentScoreOf(int i, Sequence seq, int start) {
        int j = 2 * i;
        int m = this.function[j].getLength();
        int l = 0;
        byte bgOrder = this.bg.getMaximalMarkovOrder();
        PositionDiffSM pos = (PositionDiffSM)this.function[j + 1];
        pos.reset();
        do {
            pos.getInternalPosition(this.currentPos);
            int homSt = Math.max(0, this.currentPos[0] - bgOrder);
            int homE = Math.min(this.length, this.currentPos[0] + m + bgOrder) - 1;
            this.simpleScore[i][l++] = pos.getLogScoreForInternal() + this.function[j].getLogScoreFor(seq, start + this.currentPos[0]) - this.bg.getLogScoreFor(seq, start + homSt, homE) + this.bg.getLogScoreFor(seq, start + homSt, this.currentPos[0] - 1) + this.bg.getLogScoreFor(seq, start + this.currentPos[0] + m, homE);
        } while (pos.next());
        return l;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        int i = 0;
        while (i < this.bgIndex / 2) {
            int j = this.fillComponentScoreOf(i, seq, start);
            this.componentScore[i] = this.logHiddenPotential[i] + Normalisation.getLogSum(0, j, this.simpleScore[i]);
            ++i;
        }
        if (!this.type) {
            this.componentScore[i] = this.logHiddenPotential[i];
        }
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        this.fillComponentScores(seq, start);
        return this.bg.getLogScoreFor(seq, start, start + this.length - 1) + Normalisation.getLogSum(this.componentScore);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        i = 0;
        j = 0;
        bgOrder = this.bg.getMaximalMarkovOrder();
        this.anz[0] = partialDer.length();
        end = new int[4][];
        while (j < this.bgIndex) {
            m = this.function[j].getLength();
            stop = this.length - m + 1;
            this.iList[j].clear();
            this.dList[j].clear();
            end[0] = new int[stop];
            this.iList[j + 1].clear();
            this.dList[j + 1].clear();
            pos = (PositionDiffSM)this.function[j + 1];
            pos.reset();
            end[1] = new int[stop];
            this.iList[this.bgIndex].clear();
            this.dList[this.bgIndex].clear();
            end[2] = new int[stop];
            end[3] = new int[stop];
            stop = 0;
            do {
                pos.getInternalPosition(this.currentPos);
                homSt = Math.max(0, this.currentPos[0] - bgOrder);
                homE = Math.min(this.length, this.currentPos[0] + m + bgOrder) - 1;
                this.simpleScore[i][stop] = pos.getLogScoreAndPartialDerivationForInternal(this.iList[j + 1], this.dList[j + 1]) + this.function[j].getLogScoreAndPartialDerivation(seq, start + this.currentPos[0], this.iList[j], this.dList[j]) - this.bg.getLogScoreAndPartialDerivation(seq, start + homSt, homE, this.iList[this.bgIndex], this.dList[this.bgIndex]);
                end[0][stop] = this.iList[j].length();
                end[1][stop] = this.iList[j + 1].length();
                end[2][stop] = this.iList[this.bgIndex].length();
                v0 = this.simpleScore[i];
                v1 = stop;
                v0[v1] = v0[v1] + (this.bg.getLogScoreAndPartialDerivation(seq, start + homSt, this.currentPos[0] - 1, this.iList[this.bgIndex], this.dList[this.bgIndex]) + this.bg.getLogScoreAndPartialDerivation(seq, start + this.currentPos[0] + m, homE, this.iList[this.bgIndex], this.dList[this.bgIndex]));
                end[3][stop++] = this.iList[this.bgIndex].length();
            } while (pos.next());
            this.componentScore[i] = this.logHiddenPotential[i] + Normalisation.logSumNormalisation(this.simpleScore[i], 0, stop, this.simpleScore[i], 0);
            m = 0;
            while (m < 2) {
                l = 0;
                counter = 0;
                ** GOTO lbl46
                {
                    indices.add(this.iList[j + m].get(counter) + this.paramRef[j + m]);
                    partialDer.add(this.dList[j + m].get(counter++) * this.simpleScore[i][l]);
                    do {
                        if (counter < end[m][l]) continue block3;
                        ++l;
lbl46:
                        // 2 sources

                    } while (l < stop);
                }
                ++m;
            }
            Arrays.fill(this.bgHelp, 0.0);
            l = 0;
            counter = 0;
            ** GOTO lbl64
            {
                v2 = this.iList[this.bgIndex].get(counter);
                this.bgHelp[v2] = this.bgHelp[v2] - this.dList[this.bgIndex].get(counter) * this.simpleScore[i][l];
                ++counter;
                do {
                    if (counter < end[2][l]) continue block5;
                    while (counter < end[3][l]) {
                        v3 = this.iList[this.bgIndex].get(counter);
                        this.bgHelp[v3] = this.bgHelp[v3] + this.dList[this.bgIndex].get(counter) * this.simpleScore[i][l];
                        ++counter;
                    }
                    ++l;
lbl64:
                    // 2 sources

                } while (l < stop);
            }
            counter = 0;
            while (counter < this.bgHelp.length) {
                indices.add(this.paramRef[this.bgIndex] + counter);
                partialDer.add(this.bgHelp[counter]);
                ++counter;
            }
            this.anz[i + 1] = partialDer.length();
            j = 2 * ++i;
        }
        if (!this.type) {
            this.componentScore[this.bgIndex / 2] = this.logHiddenPotential[this.bgIndex / 2];
        }
        logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        if (this.componentScore.length > 1) {
            i = 0;
            while (i < this.hiddenPotential.length) {
                partialDer.multiply(this.anz[i], this.anz[i + 1], this.componentScore[i]);
                ++i;
            }
        }
        this.iList[this.bgIndex].clear();
        this.dList[this.bgIndex].clear();
        logScore += this.bg.getLogScoreAndPartialDerivation(seq, start, start + this.length - 1, this.iList[this.bgIndex], this.dList[this.bgIndex]);
        i = 0;
        while (i < this.iList[this.bgIndex].length()) {
            indices.add(this.paramRef[this.bgIndex] + this.iList[this.bgIndex].get(i));
            partialDer.add(this.dList[this.bgIndex].get(i));
            ++i;
        }
        n = this.bgIndex + 1;
        i = this.paramRef[n + 1] - this.paramRef[n];
        j = 0;
        while (j < i) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() != false ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore;
    }

    @Override
    public String toString(NumberFormat nf) {
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        StringBuffer erg = new StringBuffer(this.function.length * 1000);
        erg.append("bg:\n" + this.bg.toString(nf) + "\n");
        if (!this.type) {
            erg.append("\nno motif: " + nf.format(Math.exp(this.partNorm[this.bgIndex / 2]) - this.norm) + "\texp(" + this.partNorm[this.bgIndex / 2] + " - " + this.norm + ")\t" + this.logHiddenPotential[this.bgIndex / 2] + "\n");
        }
        int i = 0;
        while (i < this.bgIndex) {
            erg.append("\nmotif " + i / 2 + ": ");
            if (this.hiddenPotential.length > 1) {
                nf.format(erg.append(Math.exp(this.partNorm[i / 2] - this.norm)) + "\texp(" + this.partNorm[i / 2] + " - " + this.norm + ")\t" + this.logHiddenPotential[i / 2]);
            }
            erg.append("\n" + this.function[i].toString(nf) + "\n" + this.function[i + 1].toString(nf) + "\n");
            i += 2;
        }
        return erg.toString();
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer erg = new StringBuffer(200);
        XMLParser.appendObjectWithTags(erg, this.type, "type");
        XMLParser.appendObjectWithTags(erg, this.plugInBg, "plugInBg");
        return erg;
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.type = XMLParser.extractObjectForTags(xml, "type", Boolean.TYPE);
        this.plugInBg = XMLParser.extractObjectForTags(xml, "plugInBg", Boolean.TYPE);
    }

    @Override
    public boolean modifyMotif(int motif, int offsetLeft, int offsetRight) throws Exception {
        int c = this.getNumberOfComponents() - 1;
        if ((motif < c || motif == c && this.type) && this.function[2 * motif] instanceof Mutable) {
            double norm_old = this.function[2 * motif].getLogNormalizationConstant();
            boolean res = ((Mutable)((Object)this.function[2 * motif])).modify(offsetLeft, offsetRight);
            if (res) {
                this.setHyperParametersOfBackgroundModel();
                this.init(this.freeParams);
                ((DurationDiffSM)this.function[2 * motif + 1]).modify(offsetLeft - offsetRight);
                this.simpleScore[motif] = new double[(int)this.function[2 * motif + 1].getAlphabetContainer().getAlphabetLengthAt(0)];
                double norm_new = this.function[2 * motif].getLogNormalizationConstant();
                int n = motif;
                this.hiddenParameter[n] = this.hiddenParameter[n] + (norm_old - norm_new);
                this.norm = Double.NaN;
                this.setHiddenParameters(this.hiddenParameter, 0);
            }
            return res;
        }
        return false;
    }

    @Override
    public void initializeMotif(int motif, DataSet data, double[] weights) throws Exception {
        double[][] dArrayArray;
        DataSet[] dataSetArray;
        DifferentiableStatisticalModel differentiableStatisticalModel;
        int c = this.getNumberOfComponents() - 1;
        if (motif < c || motif == c && this.type) {
            differentiableStatisticalModel = this.function[2 * motif];
            dataSetArray = new DataSet[]{data};
            if (weights == null) {
                dArrayArray = null;
            } else {
                double[][] dArrayArray2 = new double[1][];
                dArrayArray = dArrayArray2;
                dArrayArray2[0] = weights;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        differentiableStatisticalModel.initializeFunction(0, this.freeParams, dataSetArray, dArrayArray);
        this.init(this.freeParams);
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        int c = this.getNumberOfComponents() - 1;
        if (!(motif < c || motif == c && this.type)) {
            throw new IndexOutOfBoundsException();
        }
        this.function[2 * motif].initializeFunctionRandomly(this.freeParams);
        this.function[2 * motif + 1].initializeFunctionRandomly(this.freeParams);
        this.init(this.freeParams);
    }

    @Override
    public int getNumberOfMotifs() {
        return this.getNumberOfComponents() - (this.type ? 0 : 1);
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        int c = this.getNumberOfComponents() - 1;
        if (component < c || component == c && this.type) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) {
        return this.getIndexOfMaximalComponentFor(sequence, 0);
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        return component;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile dist) throws WrongLengthException {
        if (this.length != sequence.getLength() - startpos) {
            throw new WrongLengthException("The model can not score a sequence of this length.");
        }
        int c = this.getNumberOfComponents() - (!this.type ? 1 : 0);
        if (motif == 0 && component < c) {
            this.fillComponentScoreOf(component, sequence, startpos);
            double d = 0.0;
            switch (dist) {
                case UNNORMALIZED_JOINT: {
                    d = this.logHiddenPotential[component];
                }
                case UNNORMALIZED_CONDITIONAL: {
                    d += this.bg.getLogScoreFor(sequence, startpos, startpos + this.length - 1);
                    break;
                }
                case NORMALIZED_CONDITIONAL: {
                    d = -Normalisation.getLogSum(0, this.simpleScore[component].length, this.simpleScore[component]);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
            double[] res = new double[this.length - this.function[2 * component].getLength() + 1];
            DurationDiffSM posPrior = (DurationDiffSM)this.function[2 * component + 1];
            posPrior.reset();
            int[] internal = new int[1];
            posPrior.getInternalPosition(internal);
            int i = 0;
            int j = 0;
            while (i < res.length) {
                if (i == internal[0]) {
                    res[i] = this.simpleScore[component][j++] + d;
                    boolean b = posPrior.next();
                    if (b) {
                        posPrior.getInternalPosition(internal);
                    } else {
                        internal[0] = -1;
                    }
                } else {
                    res[i] = Double.NEGATIVE_INFINITY;
                }
                ++i;
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMotifLength(int motif) {
        int c = this.getNumberOfComponents() - 1;
        if (motif < c || motif == c && this.type) {
            return this.function[2 * motif].getLength();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void adjustHiddenParameters(int classIndex, DataSet[] data, double[][] dataWeights) throws Exception {
        this.initializeHiddenUniformly();
        this.adjustParameters(classIndex, data, dataWeights, false, true, false);
        this.adjustParameters(classIndex, data, dataWeights, true, false, false);
    }

    @Override
    protected void initializeUsingPlugIn(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        double[] old = null;
        if (this.plugInBg) {
            old = this.bg.getCurrentParameterValues();
        }
        this.bg.initializeFunction(index, freeParams, data, weights);
        int num = this.getNumberOfMotifs();
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double d = 0.1 / (double)(a - 1);
        d = (1.0 - (double)a * d) / ((double)a * d);
        int motif = 0;
        while (motif < num) {
            int l = this.function[2 * motif].getLength();
            int s = r.nextInt(data[index].getNumberOfElements());
            Sequence seq = data[index].getElementAt(s);
            int p = r.nextInt(seq.getLength() - l + 1);
            seq = seq.getSubSequence(p, l);
            double h = d * this.function[2 * motif].getESS();
            this.function[2 * motif].initializeFunction(0, freeParams, new DataSet[]{new DataSet("", seq)}, new double[][]{{h}});
            ++motif;
        }
        this.initializeHiddenUniformly();
        this.adjustParameters(index, data, weights, false, true, false);
        this.adjustParameters(index, data, weights, true, false, true);
        if (this.plugInBg) {
            this.bg.setParameters(old, 0);
        } else {
            this.bg.initializeUniformly(freeParams);
        }
    }

    private void adjustParameters(int index, DataSet[] data, double[][] dataWeights, boolean adjustComponent, boolean adjustDuration, boolean adjustMotif) throws Exception {
        int l;
        int c = this.getNumberOfComponents();
        int stop = c - (this.type ? 0 : 1);
        int i = 0;
        int n = 0;
        int anz = data[index].getNumberOfElements();
        int[][] len = null;
        Sequence[][] seqs = null;
        double[][] seqComponentWeights = null;
        double[][] weightsPos = null;
        double[][] weightsNeg = null;
        if (adjustDuration || adjustMotif) {
            len = new int[stop][];
            i = 0;
            while (i < stop) {
                DurationDiffSM dur = (DurationDiffSM)this.function[2 * i + 1];
                len[i] = new int[dur.getNumberOfPossibilities()];
                dur.reset();
                l = 0;
                do {
                    len[i][l++] = dur.internal[0];
                } while (dur.next());
                ++i;
            }
            if (adjustMotif) {
                seqs = new Sequence[this.getNumberOfMotifs()][anz];
                seqComponentWeights = new double[seqs.length][anz];
            }
            if (adjustDuration) {
                weightsPos = new double[stop][];
                weightsNeg = new double[stop][];
                i = 0;
                while (i < stop) {
                    weightsPos[i] = new double[len[i].length];
                    weightsNeg[i] = new double[len[i].length];
                    ++i;
                }
            }
        }
        double[] stat = new double[this.hiddenParameter.length];
        double w = 1.0;
        int d = 0;
        while (d < data.length) {
            anz = data[d].getNumberOfElements();
            n = 0;
            while (n < anz) {
                if (dataWeights != null) {
                    w = dataWeights[d][n];
                }
                Sequence current = data[d].getElementAt(n);
                this.fillComponentScores(current, 0);
                Normalisation.logSumNormalisation(this.componentScore);
                i = 0;
                while (i < c) {
                    double scw = this.componentScore[i] * w;
                    if (adjustComponent && d == index) {
                        int n2 = i;
                        stat[n2] = stat[n2] + scw;
                    }
                    if ((adjustDuration || adjustMotif) && i < stop) {
                        int maxIndex = 0;
                        l = 0;
                        while (l < this.simpleScore[i].length) {
                            if (this.simpleScore[i][l] >= this.simpleScore[i][maxIndex]) {
                                maxIndex = l;
                            }
                            ++l;
                        }
                        if (adjustDuration) {
                            if (d == index) {
                                double[] dArray = weightsPos[i];
                                int n3 = maxIndex;
                                dArray[n3] = dArray[n3] + scw;
                            } else {
                                double[] dArray = weightsNeg[i];
                                int n4 = maxIndex;
                                dArray[n4] = dArray[n4] + scw;
                            }
                        }
                        if (adjustMotif && d == index) {
                            seqComponentWeights[i][n] = scw;
                            seqs[i][n] = current.getSubSequence(len[i][maxIndex], this.function[2 * i].getLength());
                            if (this.getStrandProbabilitiesFor(i, 0, seqs[i][n], 0)[0] < 0.5) {
                                seqs[i][n] = seqs[i][n].reverseComplement();
                            }
                        }
                    }
                    ++i;
                }
                ++n;
            }
            ++d;
        }
        if (adjustComponent) {
            this.computeHiddenParameter(stat, true);
        }
        if (adjustDuration) {
            anz = data[index].getNumberOfElements();
            n = this.length / anz;
            c = Math.max(1, n / 2);
            i = 0;
            while (i < stop) {
                int x;
                int z;
                int binEnd;
                double[] help = new double[weightsPos[i].length];
                double sumPos = 0.0;
                int y = 0;
                while (y < help.length) {
                    help[y] = 0.0;
                    binEnd = Math.min(help.length - 1, y + c);
                    z = 0;
                    x = Math.max(0, y - c);
                    while (x <= binEnd) {
                        int n5 = y;
                        help[n5] = help[n5] + weightsPos[i][x];
                        ++x;
                        ++z;
                    }
                    int n6 = y;
                    help[n6] = help[n6] / (double)z;
                    sumPos += help[y];
                    ++y;
                }
                weightsPos[i] = help;
                double sumNeg = 0.0;
                y = 0;
                while (y < help.length) {
                    help[y] = 0.0;
                    binEnd = Math.min(help.length, y + c);
                    z = 0;
                    x = Math.max(0, y - c);
                    while (x < binEnd) {
                        int n7 = y;
                        help[n7] = help[n7] + weightsNeg[i][x];
                        ++x;
                        ++z;
                    }
                    int n8 = y;
                    help[n8] = help[n8] / (double)z;
                    sumNeg += help[y];
                    ++y;
                }
                weightsNeg[i] = help;
                double f = sumNeg > 0.0 ? sumPos / sumNeg : 0.0;
                int x2 = 0;
                while (x2 < weightsPos.length) {
                    weightsPos[i][x2] = weightsPos[i][x2] > 1.2 * f * weightsNeg[i][x2] ? weightsPos[i][x2] - f * weightsNeg[i][x2] : 0.0;
                    ++x2;
                }
                ((DurationDiffSM)this.function[2 * i + 1]).adjust(len[i], weightsPos[i]);
                ++i;
            }
        }
        if (adjustMotif) {
            i = 0;
            while (i < stop) {
                this.function[2 * i].initializeFunction(0, this.freeParams, new DataSet[]{new DataSet("picked sites " + i, seqs[i])}, new double[][]{seqComponentWeights[i]});
                ++i;
            }
        }
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        int c = this.getNumberOfComponents() - (!this.type ? 1 : 0);
        if (motif > 0 || component >= c) {
            throw new IndexOutOfBoundsException();
        }
        DifferentiableStatisticalModel m = this.function[2 * component];
        while (m instanceof NormalizedDiffSM) {
            m = ((NormalizedDiffSM)m).getFunction();
        }
        if (m instanceof StrandDiffSM) {
            if (startpos == 0) {
                return ((StrandDiffSM)m).getProbsForComponent(sequence);
            }
            return ((StrandDiffSM)m).getProbsForComponent(sequence.getSubSequence(startpos));
        }
        return new double[]{1.0, 0.0};
    }
}

