/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.program.das.DASFeatureSet;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.DASSequenceI;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.DummySymbolList;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

class RawAnnotationSequence
extends Unchangeable
implements DASSequenceI {
    private URL dataSourceURL;
    private String seqID;
    private FeatureRealizer featureRealizer = FeatureImpl.DEFAULT;
    private SymbolList nullSymbols = new DummySymbolList(DNATools.getDNA(), 2000000000);
    private DASSequenceDB dummyDB;
    private DASFeatureSet features;

    RawAnnotationSequence(DASSequenceDB dummyDB, URL dataSourceURL, String seqID) throws BioException, IllegalIDException {
        this.dummyDB = dummyDB;
        this.dataSourceURL = dataSourceURL;
        this.seqID = seqID;
        this.features = new DASFeatureSet(this, dataSourceURL, seqID);
    }

    URL getDataSourceURL() {
        return this.dataSourceURL;
    }

    public DASSequenceDB getParentDB() {
        return this.dummyDB;
    }

    private int registerLocalFeatureFetchers(Object regKey) {
        this.features.registerFeatureFetcher(regKey);
        return 1;
    }

    private int registerLocalFeatureFetchers(Location l, Object regKey) {
        this.features.registerFeatureFetcher(l, regKey);
        return 1;
    }

    int registerFeatureFetchers(Object regKey) throws BioException {
        return this.registerLocalFeatureFetchers(regKey);
    }

    int registerFeatureFetchers(Location l, Object regKey) throws BioException {
        return this.registerLocalFeatureFetchers(l, regKey);
    }

    public Alphabet getAlphabet() {
        return this.nullSymbols.getAlphabet();
    }

    public Iterator iterator() {
        return this.nullSymbols.iterator();
    }

    public int length() {
        return this.nullSymbols.length();
    }

    public String seqString() {
        return this.nullSymbols.seqString();
    }

    public String subStr(int start, int end) {
        return this.nullSymbols.subStr(start, end);
    }

    public SymbolList subList(int start, int end) {
        return this.nullSymbols.subList(start, end);
    }

    public Symbol symbolAt(int pos) {
        return this.nullSymbols.symbolAt(pos);
    }

    public List toList() {
        return this.nullSymbols.toList();
    }

    public void edit(Edit e) throws ChangeVetoException {
        throw new ChangeVetoException("/You/ try implementing read-write DAS");
    }

    public String getName() {
        return this.seqID;
    }

    public String getURN() {
        try {
            return new URL(this.getDataSourceURL(), "?ref=" + this.seqID).toString();
        }
        catch (MalformedURLException ex) {
            throw new BioRuntimeException(ex);
        }
    }

    public Iterator features() {
        try {
            this.registerFeatureFetchers(null);
            return this.features.features();
        }
        catch (BioException be) {
            throw new BioRuntimeException("Couldn't create features iterator", be);
        }
    }

    public boolean containsFeature(Feature f) {
        return this.features.containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.filter(ff, !FilterUtils.areProperSubset(ff, FeatureFilter.top_level));
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        try {
            FeatureFilter.ByClass structureMembershipFilter = new FeatureFilter.ByClass(ComponentFeature.class);
            if (FilterUtils.areProperSubset(ff, structureMembershipFilter)) {
                return FeatureHolder.EMPTY_FEATURE_HOLDER;
            }
            Location ffl = FilterUtils.extractOverlappingLocation(ff);
            if (recurse) {
                int numComponents = 1;
                numComponents = ffl != null ? this.registerFeatureFetchers(ffl, ff) : this.registerFeatureFetchers(ff);
                this.getParentDB().ensureFeaturesCacheCapacity(numComponents * 3);
            } else if (ffl != null) {
                this.registerLocalFeatureFetchers(ffl, ff);
            } else {
                this.registerLocalFeatureFetchers(ff);
            }
            return this.features.filter(ff, recurse);
        }
        catch (BioException be) {
            throw new BioRuntimeException("Can't filter", be);
        }
    }

    public FeatureFilter getSchema() {
        return this.features.getSchema();
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public Feature createFeature(Feature.Template temp) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on DAS sequences.");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from DAS sequences.");
    }

    public Feature realizeFeature(FeatureHolder dest, Feature.Template temp) throws BioException {
        return this.featureRealizer.realizeFeature(this, dest, temp);
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }
}

