/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.PFMComparator;
import java.io.File;
import java.util.AbstractMap;

public class PredictBindingSites {
    public static void main(String[] args) throws Exception {
        int k;
        int j;
        SimpleParameterSet params = new SimpleParameterSet(new SimpleParameter(DataType.STRING, "Data", "The file containing the scanned sequences", true), new SimpleParameter(DataType.STRING, "Matrix", "File containing the matrix", true), new EnumParameter(Format.class, "The format of the matrix file", true), new SimpleParameter(DataType.DOUBLE, "Threshold", "The threshold for predicting BSs", true, 0.0));
        String[] tags = new String[]{"data", "matrix", "format", "threshold"};
        ParameterSetTagger tagger = new ParameterSetTagger(tags, params);
        tagger.fillParameters("=", args);
        System.err.println(tagger);
        if (!params.hasDefaultOrIsSet()) {
            System.err.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String data = (String)params.getParameterAt(0).getValue();
        String matrix = (String)params.getParameterAt(1).getValue();
        Format format = (Format)((Object)params.getParameterAt(2).getValue());
        double threshold = (Double)params.getParameterAt(3).getValue();
        DataSet ds = new DataSet(new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "S", "W", "R", "Y", "M", "K", "B", "D", "H", "V")), new SparseStringExtractor(data, '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
        int[][] nArrayArray = new int[15][];
        nArrayArray[0] = new int[1];
        nArrayArray[1] = new int[]{1};
        nArrayArray[2] = new int[]{2};
        nArrayArray[3] = new int[]{3};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArrayArray[4] = nArray;
        nArrayArray[5] = new int[]{1, 2};
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        nArrayArray[6] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        nArrayArray[7] = nArray3;
        nArrayArray[8] = new int[]{1, 3};
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        nArrayArray[9] = nArray4;
        nArrayArray[10] = new int[]{2, 3};
        nArrayArray[11] = new int[]{1, 2, 3};
        int[] nArray5 = new int[3];
        nArray5[1] = 2;
        nArray5[2] = 3;
        nArrayArray[12] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[1] = 1;
        nArray6[2] = 3;
        nArrayArray[13] = nArray6;
        int[] nArray7 = new int[3];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArrayArray[14] = nArray7;
        int[][] map = nArrayArray;
        int[] nArray8 = new int[15];
        nArray8[0] = 3;
        nArray8[1] = 2;
        nArray8[2] = 1;
        nArray8[4] = 4;
        nArray8[5] = 5;
        nArray8[6] = 6;
        nArray8[7] = 8;
        nArray8[8] = 7;
        nArray8[9] = 10;
        nArray8[10] = 9;
        nArray8[11] = 14;
        nArray8[12] = 13;
        nArray8[13] = 12;
        nArray8[14] = 11;
        int[] rc = nArray8;
        AbstractMap.SimpleEntry<String, double[][]> en = null;
        en = format == Format.JASPAR ? PFMComparator.readPFMsFromJasparFastA(matrix).get(0) : (format == Format.TRANSFAC ? PFMComparator.readPFMsFromEMBL(matrix, Integer.MAX_VALUE).get(0) : PFMComparator.readPFMFromUniprobe("", new File(matrix)));
        double[][] mat = en.getValue();
        String name = en.getKey().trim();
        double[] bg = new double[4];
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            Sequence seq = ds.getElementAt(i);
            j = 0;
            while (j < seq.getLength()) {
                int v = seq.discreteVal(j);
                k = 0;
                while (k < map[v].length) {
                    int n = map[v][k];
                    bg[n] = bg[n] + 1.0 / (double)map[v].length;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        Normalisation.sumNormalisation(bg);
        i = 0;
        while (i < mat.length) {
            Normalisation.sumNormalisation(mat[i]);
            int j2 = 0;
            while (j2 < mat[i].length) {
                mat[i][j2] = Math.log(mat[i][j2]) - Math.log(bg[j2]);
                ++j2;
            }
            ++i;
        }
        double[][] expMat = new double[mat.length][map.length];
        int i2 = 0;
        while (i2 < expMat.length) {
            j = 0;
            while (j < expMat[i2].length) {
                double[] temp = new double[map[j].length];
                k = 0;
                while (k < temp.length) {
                    temp[k] = mat[i2][map[j][k]] + Math.log(map[j].length);
                    ++k;
                }
                expMat[i2][j] = Normalisation.getLogSum(temp);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < ds.getNumberOfElements()) {
            Sequence seq = ds.getElementAt(i2);
            int j3 = 0;
            while (j3 < seq.getLength() - mat.length + 1) {
                int v;
                double sc = 0.0;
                int k2 = 0;
                while (k2 < mat.length) {
                    v = seq.discreteVal(j3 + k2);
                    sc += expMat[k2][v];
                    ++k2;
                }
                if (sc > threshold) {
                    System.out.println(String.valueOf(i2) + "\t" + seq.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue() + "\t" + name + "\t" + (j3 + 1) + "\t" + (j3 + expMat.length) + "\t+\t" + sc);
                }
                sc = 0.0;
                k2 = 0;
                while (k2 < mat.length) {
                    v = seq.discreteVal(j3 + k2);
                    sc += expMat[expMat.length - 1 - k2][rc[v]];
                    ++k2;
                }
                if (sc > threshold) {
                    System.out.println(String.valueOf(i2) + "\t" + seq.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue() + "\t" + name + "\t" + (j3 + 1) + "\t" + (j3 + expMat.length) + "\t-\t" + sc);
                }
                ++j3;
            }
            ++i2;
        }
    }

    private static enum Format {
        JASPAR,
        TRANSFAC,
        UNIPROBE;

    }
}

