/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs;

import java.util.Arrays;
import java.util.LinkedList;

public class Chu_Liu_Edmonds {
    public static final byte MAXIMALBRANCHING = 0;
    public static final byte MINIMALBRANCHING = 1;
    private static final double[] INFTY = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
    private static final byte[] NULLBYTEARRAY = new byte[0];

    private Chu_Liu_Edmonds() {
    }

    public static byte[][] getOptimalBranching(double[][] graph, double[][] rootWeights, byte type) throws IllegalArgumentException, Exception {
        if (!(type == 0 ^ type == 1)) {
            throw new IllegalArgumentException("Error in Chu_Liu_Edmonds.getOptimalBranching(): given type has to be either Chu_Liu_Edmonds.MAXIMALBRANCHING or Chu_Liu_Edmonds.MINIMALBRANCHING");
        }
        byte root = -1;
        double[][] optimalResult = null;
        if (rootWeights == null || rootWeights.length == 0) {
            optimalResult = Chu_Liu_Edmonds.Chu_Liu_Edmonds_Algo(Chu_Liu_Edmonds.copyGraph(graph, type), root, type);
        } else {
            double optimalScore = INFTY[type];
            byte i = 0;
            while (i < rootWeights.length) {
                root = i;
                double[][] result = Chu_Liu_Edmonds.Chu_Liu_Edmonds_Algo(Chu_Liu_Edmonds.copyGraph(graph, type), root, type);
                double tempScore = 0.0;
                int l = 0;
                while (l < result.length) {
                    int j = 0;
                    while (j < result[l].length) {
                        if (!Double.isInfinite(result[l][j])) {
                            tempScore += result[l][j];
                            break;
                        }
                        j = (byte)(j + 1);
                    }
                    l = (byte)(l + 1);
                }
                if (type == 0 && tempScore + rootWeights[root][0] > optimalScore || type == 1 && tempScore + rootWeights[root][0] < optimalScore) {
                    optimalScore = tempScore + rootWeights[root][0];
                    optimalResult = result;
                }
                i = (byte)(i + 1);
            }
        }
        byte[][] randVarDeps = new byte[graph.length][];
        byte l = 0;
        while (l < optimalResult.length) {
            boolean foundDep = false;
            byte j = 0;
            while (j < optimalResult[l].length) {
                if (!Double.isInfinite(optimalResult[l][j])) {
                    byte[] temp = new byte[]{j, l};
                    randVarDeps[l] = temp;
                    foundDep = true;
                    break;
                }
                j = (byte)(j + 1);
            }
            if (!foundDep) {
                byte[] temp = new byte[]{l};
                randVarDeps[l] = temp;
            }
            l = (byte)(l + 1);
        }
        return randVarDeps;
    }

    private static double[][] Chu_Liu_Edmonds_Algo(double[][] graph, byte root, byte type) throws Exception {
        byte[] parents;
        block39: {
            parents = new byte[graph.length];
            Arrays.fill(parents, (byte)-1);
            byte i = 0;
            while (i < graph.length) {
                int tempParent;
                parents[i] = i != root ? (tempParent = Chu_Liu_Edmonds.getMaxParent(i, graph, type)) : -1;
                i = (byte)(i + 1);
            }
            byte[][] cycli = Chu_Liu_Edmonds.getCycles(parents);
            byte[] tempCycle = cycli.length == 0 ? NULLBYTEARRAY : cycli[0];
            if (tempCycle.length == 0) break block39;
            if (tempCycle.length == graph.length) {
                byte unoptimalRandVar = (byte)Chu_Liu_Edmonds.getMostUnoptimalParams(graph, tempCycle, parents, type)[0];
                parents[unoptimalRandVar] = -1;
                Chu_Liu_Edmonds.reduceGraph(graph, parents, type);
                return graph;
            }
            if (tempCycle.length == 1) {
                throw new Exception("Error in Chu_Liu_Edmonds: Cycle has length 1");
            }
            Arrays.sort(tempCycle);
            double[] temp = Chu_Liu_Edmonds.getMostUnoptimalParams(graph, tempCycle, parents, type);
            double cycleMostUnoptimalScore = temp[2];
            byte mostUnoptimalRandVar = (byte)temp[0];
            byte mostUnoptimalParent = (byte)temp[1];
            int tempCycleCounter = 0;
            int newRandVarOrderCounter = 0;
            byte newPosOfRoot = -1;
            byte[] newRandVarOrder = new byte[graph.length];
            int m = 0;
            while (m < newRandVarOrder.length) {
                if (tempCycleCounter >= tempCycle.length || m != tempCycle[tempCycleCounter]) {
                    int n = newRandVarOrderCounter;
                    newRandVarOrderCounter = (byte)(n + 1);
                    newRandVarOrder[n] = m;
                    if (m == root) {
                        newPosOfRoot = (byte)(newRandVarOrderCounter - 1);
                    }
                } else {
                    newRandVarOrder[newRandVarOrder.length - 1 - tempCycleCounter] = m;
                    tempCycleCounter = (byte)(tempCycleCounter + 1);
                }
                m = (byte)(m + 1);
            }
            double[][] reducedMatrix = new double[graph.length - tempCycle.length + 1][graph.length - tempCycle.length + 1];
            byte[] maxHeadFromIngoingEdge = new byte[reducedMatrix.length - 1];
            int cycleRegion = newRandVarOrder.length - tempCycle.length;
            int m2 = 0;
            while (m2 < newRandVarOrder.length) {
                int l = 0;
                while (l < newRandVarOrder.length) {
                    block41: {
                        block44: {
                            double tempScore;
                            block45: {
                                block42: {
                                    block43: {
                                        block40: {
                                            if (m2 >= cycleRegion || l >= cycleRegion) break block40;
                                            reducedMatrix[m2][l] = m2 == l ? INFTY[type] : graph[newRandVarOrder[m2]][newRandVarOrder[l]];
                                            break block41;
                                        }
                                        if (m2 >= cycleRegion || l < cycleRegion) break block42;
                                        if (l != cycleRegion) break block43;
                                        reducedMatrix[m2][cycleRegion] = graph[newRandVarOrder[m2]][newRandVarOrder[l]];
                                        break block41;
                                    }
                                    switch (type) {
                                        case 0: {
                                            if (reducedMatrix[m2][cycleRegion] < graph[newRandVarOrder[m2]][newRandVarOrder[l]]) {
                                                reducedMatrix[m2][cycleRegion] = graph[newRandVarOrder[m2]][newRandVarOrder[l]];
                                                break;
                                            }
                                            break block41;
                                        }
                                        case 1: {
                                            if (!(reducedMatrix[m2][cycleRegion] > graph[newRandVarOrder[m2]][newRandVarOrder[l]])) break block41;
                                            reducedMatrix[m2][cycleRegion] = graph[newRandVarOrder[m2]][newRandVarOrder[l]];
                                        }
                                        default: {
                                            break;
                                        }
                                        {
                                        }
                                    }
                                    break block41;
                                }
                                if (m2 < cycleRegion || l >= cycleRegion) break block44;
                                if (m2 != cycleRegion) break block45;
                                reducedMatrix[cycleRegion][l] = tempScore = graph[newRandVarOrder[m2]][newRandVarOrder[l]] + cycleMostUnoptimalScore - graph[newRandVarOrder[m2]][parents[newRandVarOrder[m2]]];
                                maxHeadFromIngoingEdge[l] = m2;
                                break block41;
                            }
                            tempScore = graph[newRandVarOrder[m2]][newRandVarOrder[l]] + cycleMostUnoptimalScore - graph[newRandVarOrder[m2]][parents[newRandVarOrder[m2]]];
                            switch (type) {
                                case 0: {
                                    if (reducedMatrix[cycleRegion][l] < tempScore) {
                                        reducedMatrix[cycleRegion][l] = tempScore;
                                        maxHeadFromIngoingEdge[l] = m2;
                                        break;
                                    }
                                    break block41;
                                }
                                case 1: {
                                    if (!(reducedMatrix[cycleRegion][l] > tempScore)) break block41;
                                    reducedMatrix[cycleRegion][l] = tempScore;
                                    maxHeadFromIngoingEdge[l] = m2;
                                }
                                default: {
                                    break;
                                }
                                {
                                }
                            }
                            break block41;
                        }
                        if (newRandVarOrder[l] != parents[newRandVarOrder[m2]]) {
                            graph[newRandVarOrder[m2]][newRandVarOrder[l]] = INFTY[type];
                        }
                    }
                    l = (byte)(l + 1);
                }
                m2 = (byte)(m2 + 1);
            }
            reducedMatrix[reducedMatrix.length - 1][reducedMatrix.length - 1] = INFTY[type];
            double[][] newWeights = Chu_Liu_Edmonds.Chu_Liu_Edmonds_Algo(reducedMatrix, newPosOfRoot, type);
            boolean exsistsIngoingEdge = false;
            int headNodeOfIngoingEdge = -1;
            int m3 = 0;
            while (m3 < newRandVarOrder.length) {
                int l = 0;
                while (l < newRandVarOrder.length) {
                    if (m3 < cycleRegion && l < cycleRegion) {
                        graph[newRandVarOrder[m3]][newRandVarOrder[l]] = reducedMatrix[m3][l];
                    } else if (m3 < cycleRegion && l >= cycleRegion) {
                        graph[newRandVarOrder[m3]][newRandVarOrder[l]] = Double.isInfinite(reducedMatrix[m3][cycleRegion]) || graph[newRandVarOrder[m3]][newRandVarOrder[l]] != reducedMatrix[m3][cycleRegion] ? INFTY[type] : reducedMatrix[m3][cycleRegion];
                    } else if (m3 >= cycleRegion && l < cycleRegion) {
                        if (Double.isInfinite(reducedMatrix[cycleRegion][l])) {
                            graph[newRandVarOrder[m3]][newRandVarOrder[l]] = INFTY[type];
                        } else {
                            exsistsIngoingEdge = true;
                            if (m3 != maxHeadFromIngoingEdge[l]) {
                                graph[newRandVarOrder[m3]][newRandVarOrder[l]] = INFTY[type];
                            } else {
                                headNodeOfIngoingEdge = newRandVarOrder[m3];
                            }
                        }
                    }
                    l = (byte)(l + 1);
                }
                m3 = (byte)(m3 + 1);
            }
            if (exsistsIngoingEdge) {
                graph[headNodeOfIngoingEdge][parents[headNodeOfIngoingEdge]] = INFTY[type];
            } else {
                graph[mostUnoptimalRandVar][mostUnoptimalParent] = INFTY[type];
            }
            return graph;
        }
        Chu_Liu_Edmonds.reduceGraph(graph, parents, type);
        return graph;
    }

    private static byte[][] getCycles(byte[] parents) {
        boolean[] traversed = new boolean[parents.length];
        boolean[] tempWalk = new boolean[parents.length];
        Arrays.fill(traversed, false);
        LinkedList<byte[]> cycli = new LinkedList<byte[]>();
        int randVar = 0;
        while (randVar < parents.length) {
            if (!traversed[randVar]) {
                int tempRandVar = randVar;
                Arrays.fill(tempWalk, false);
                while (tempRandVar != -1 && !tempWalk[tempRandVar] && !traversed[tempRandVar]) {
                    tempWalk[tempRandVar] = true;
                    tempRandVar = parents[tempRandVar];
                }
                if (tempRandVar != -1 && !traversed[tempRandVar]) {
                    int cycleLength = 0;
                    int cycleElement = tempRandVar;
                    do {
                        tempRandVar = parents[tempRandVar];
                        ++cycleLength;
                    } while (tempRandVar != cycleElement);
                    byte[] cyclus = new byte[cycleLength];
                    tempRandVar = cycleElement;
                    int i = 0;
                    while (i < cyclus.length) {
                        cyclus[i] = tempRandVar;
                        tempRandVar = parents[tempRandVar];
                        i = (byte)(i + 1);
                    }
                    cycli.add(cyclus);
                }
                int i = 0;
                while (i < traversed.length) {
                    traversed[i] = traversed[i] | tempWalk[i++];
                }
            }
            randVar = (byte)(randVar + 1);
        }
        if (cycli.size() == 0) {
            return new byte[0][0];
        }
        int size = cycli.size();
        byte[][] ret = new byte[size][];
        int i = 0;
        while (i < size) {
            ret[i] = (byte[])cycli.removeFirst();
            ++i;
        }
        return ret;
    }

    private static byte getMaxParent(byte randVar, double[][] weights, byte type) {
        int optimalParent = -1;
        double optimalScore = INFTY[type];
        switch (type) {
            case 1: {
                int i = 0;
                while (i < weights[randVar].length) {
                    if (i != randVar && weights[randVar][i] < optimalScore) {
                        optimalScore = weights[randVar][i];
                        optimalParent = i;
                    }
                    i = (byte)(i + 1);
                }
                break;
            }
            case 0: {
                int i = 0;
                while (i < weights[randVar].length) {
                    if (i != randVar && weights[randVar][i] > optimalScore) {
                        optimalScore = weights[randVar][i];
                        optimalParent = i;
                    }
                    i = (byte)(i + 1);
                }
                break;
            }
        }
        return (byte)optimalParent;
    }

    private static void reduceGraph(double[][] graph, byte[] parents, byte type) {
        int m = 0;
        while (m < graph.length) {
            int l = 0;
            while (l < graph.length) {
                if (m != l && l != parents[m]) {
                    graph[m][l] = INFTY[type];
                }
                l = (byte)(l + 1);
            }
            m = (byte)(m + 1);
        }
    }

    private static double[] getMostUnoptimalParams(double[][] graph, byte[] tempCycle, byte[] parents, byte type) {
        double mostUnoptimalScore = INFTY[1 - type];
        double[] ret = new double[3];
        int m = 0;
        while (m < tempCycle.length) {
            switch (type) {
                case 0: {
                    if (!(graph[tempCycle[m]][parents[tempCycle[m]]] < mostUnoptimalScore)) break;
                    mostUnoptimalScore = graph[tempCycle[m]][parents[tempCycle[m]]];
                    ret[0] = tempCycle[m];
                    ret[1] = parents[tempCycle[m]];
                    break;
                }
                case 1: {
                    if (!(graph[tempCycle[m]][parents[tempCycle[m]]] > mostUnoptimalScore)) break;
                    mostUnoptimalScore = graph[tempCycle[m]][parents[tempCycle[m]]];
                    ret[0] = tempCycle[m];
                    ret[1] = parents[tempCycle[m]];
                }
            }
            m = (byte)(m + 1);
        }
        ret[2] = mostUnoptimalScore;
        return ret;
    }

    private static double[][] copyGraph(double[][] graph, byte type) {
        double[][] ret = new double[graph.length][graph.length];
        int i = 0;
        while (i < graph.length) {
            int j = 0;
            while (j < graph.length) {
                ret[i][j] = i == j ? INFTY[type] : graph[i][j];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private static void printMatrix(double[][] m) {
        System.out.println("matrixausgabe:***********************");
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[i].length) {
                System.out.print(String.valueOf(m[i][j]) + "\t");
                j = (byte)(j + 1);
            }
            System.out.println();
            i = (byte)(i + 1);
        }
        System.out.println("ende*********************************");
    }

    private static void printCycle(byte[] c) {
        System.out.println("start Zyklus:****************");
        int i = 0;
        while (i < c.length) {
            System.out.print(String.valueOf(c[i]) + "\t");
            ++i;
        }
        System.out.println("\nende Zyklus******************");
    }
}

