/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SequenceScoringParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.DiscreteGraphicalTrainSM;

public abstract class DGTrainSMParameterSet<T extends DiscreteGraphicalTrainSM>
extends SequenceScoringParameterSet<T> {
    protected DGTrainSMParameterSet(StringBuffer s) throws NonParsableException {
        super(s);
    }

    protected DGTrainSMParameterSet(Class<T> instanceClass, boolean simple, boolean variableLength) {
        super(instanceClass, AlphabetContainer.AlphabetContainerType.DISCRETE, simple, variableLength);
        this.addParameters();
    }

    protected DGTrainSMParameterSet(Class<T> instanceClass, AlphabetContainer alphabet, double ess, String description) throws Exception {
        this(instanceClass, alphabet, 0, true, ess, description);
    }

    protected DGTrainSMParameterSet(Class<T> instanceClass, AlphabetContainer alphabet, int length, double ess, String description) throws Exception {
        this(instanceClass, alphabet, length, false, ess, description);
    }

    private DGTrainSMParameterSet(Class<T> instanceClass, AlphabetContainer alphabet, int length, boolean variableLength, double ess, String description) throws Exception {
        super(instanceClass, alphabet, length, variableLength);
        this.addParameters();
        this.setEss(ess);
        if (description != null) {
            ((Parameter)this.parameters.get(1)).setValue(description);
        }
    }

    private void addParameters() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "ESS", "the equivalent sample size", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE)))});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "description", "a textual description or comment for the model", false, "none")});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (super.hasDefaultOrIsSet()) {
            return ((AlphabetContainer.AbstractAlphabetContainerParameterSet)this.alphabet.getValue()).isDiscrete();
        }
        return false;
    }

    @Override
    public String getInstanceName() {
        return this.getInstanceClass().getSimpleName();
    }

    @Override
    public DGTrainSMParameterSet clone() throws CloneNotSupportedException {
        return (DGTrainSMParameterSet)super.clone();
    }

    public void setEss(double ess) throws SimpleParameter.IllegalValueException {
        this.getParameterForName("ESS").setValue(ess);
    }
}

