/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.util;

public final class ArrayUtilities {
    public static final float FLOAT_EPS = 1.0E-6f;
    public static final double DOUBLE_EPS = 1.0E-12;

    private ArrayUtilities() {
    }

    public static final boolean equal(double[] dArray, double[] dArray2, double d) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > d)) continue;
            return false;
        }
        return true;
    }

    public static final boolean equal(double[] dArray, double[] dArray2) {
        return ArrayUtilities.equal(dArray, dArray2, 1.0E-12);
    }

    public static final double[] copy(double[] dArray, double[] dArray2) {
        if (dArray2 == null || dArray2.length != dArray.length) {
            return (double[])dArray.clone();
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static final double[] size(double[] dArray, int n) {
        return dArray != null && dArray.length == n ? dArray : new double[n];
    }

    public static final double[] resize(double[] dArray, int n) {
        if (dArray != null && dArray.length == n) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, Math.min(n, dArray.length));
        return dArray2;
    }

    public static final double[] unrole(double[] dArray, double[] dArray2, int n) {
        int n2 = dArray2.length * n;
        if (dArray == null || dArray.length != dArray2.length * n) {
            dArray = new double[n2];
        }
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
        int n3 = dArray2.length;
        while (2 * n3 < n2) {
            System.arraycopy(dArray, 0, dArray, n3, n3);
            n3 *= 2;
        }
        System.arraycopy(dArray, 0, dArray, n3, n2 - n3);
        return dArray;
    }

    public static final double[] concat(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray.length != dArray2.length + dArray3.length) {
            dArray = new double[dArray2.length + dArray3.length];
        }
        System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
        System.arraycopy(dArray3, 0, dArray, dArray2.length, dArray3.length);
        return dArray;
    }

    public static final void fill(double[] dArray, double d) {
        ArrayUtilities.fill(dArray, 0, dArray.length, d);
    }

    public static final void fill(double[] dArray, int n, int n2, double d) {
        if (n2 < 1) {
            return;
        }
        dArray[n + 0] = d;
        if (n2 < 2) {
            return;
        }
        dArray[n + 1] = d;
        if (n2 < 3) {
            return;
        }
        dArray[n + 2] = d;
        if (n2 < 4) {
            return;
        }
        dArray[n + 3] = d;
        if (n2 < 5) {
            return;
        }
        dArray[n + 4] = d;
        int n3 = 5;
        while (2 * n3 < n2) {
            System.arraycopy(dArray, n, dArray, n + n3, n3);
            n3 *= 2;
        }
        System.arraycopy(dArray, n, dArray, n + n3, n2 - n3);
    }

    public static final double sum(double[] dArray) {
        return ArrayUtilities.sum(dArray, 0, dArray.length);
    }

    public static final double sum(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n + n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static final double min(double[] dArray) {
        return ArrayUtilities.min(dArray, 0, dArray.length);
    }

    public static final double min(double[] dArray, int n, int n2) {
        double d = dArray[n];
        for (int i = n; i < n + n2; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public static final double max(double[] dArray) {
        return ArrayUtilities.max(dArray, 0, dArray.length);
    }

    public static final double max(double[] dArray, int n, int n2) {
        double d = dArray[n];
        for (int i = n; i < n + n2; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public static final boolean equal(float[] fArray, float[] fArray2, float f) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(fArray[i] - fArray2[i]) > f)) continue;
            return false;
        }
        return true;
    }

    public static final boolean equal(float[] fArray, float[] fArray2) {
        return ArrayUtilities.equal(fArray, fArray2, 1.0E-6f);
    }

    public static final float[] copy(float[] fArray, float[] fArray2) {
        if (fArray2 == null || fArray2.length != fArray.length) {
            return (float[])fArray.clone();
        }
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static final float[] size(float[] fArray, int n) {
        return fArray != null && fArray.length == n ? fArray : new float[n];
    }

    public static final float[] resize(float[] fArray, int n) {
        if (fArray != null && fArray.length == n) {
            return fArray;
        }
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(n, fArray.length));
        return fArray2;
    }

    public static final float[] unrole(float[] fArray, float[] fArray2, int n) {
        int n2 = fArray2.length * n;
        if (fArray == null || fArray.length != fArray2.length * n) {
            fArray = new float[n2];
        }
        System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
        int n3 = fArray2.length;
        while (2 * n3 < n2) {
            System.arraycopy(fArray, 0, fArray, n3, n3);
            n3 *= 2;
        }
        System.arraycopy(fArray, 0, fArray, n3, n2 - n3);
        return fArray;
    }

    public static final float[] concat(float[] fArray, float[] fArray2, float[] fArray3) {
        if (fArray == null || fArray.length != fArray2.length + fArray3.length) {
            fArray = new float[fArray2.length + fArray3.length];
        }
        System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
        System.arraycopy(fArray3, 0, fArray, fArray2.length, fArray3.length);
        return fArray;
    }

    public static final void fill(float[] fArray, float f) {
        ArrayUtilities.fill(fArray, 0, fArray.length, f);
    }

    public static final void fill(float[] fArray, int n, int n2, float f) {
        if (n2 < 1) {
            return;
        }
        fArray[n + 0] = f;
        if (n2 < 2) {
            return;
        }
        fArray[n + 1] = f;
        if (n2 < 3) {
            return;
        }
        fArray[n + 2] = f;
        if (n2 < 4) {
            return;
        }
        fArray[n + 3] = f;
        if (n2 < 5) {
            return;
        }
        fArray[n + 4] = f;
        int n3 = 5;
        while (2 * n3 < n2) {
            System.arraycopy(fArray, n, fArray, n + n3, n3);
            n3 *= 2;
        }
        System.arraycopy(fArray, n, fArray, n + n3, n2 - n3);
    }

    public static final float sum(float[] fArray) {
        return ArrayUtilities.sum(fArray, 0, fArray.length);
    }

    public static final float sum(float[] fArray, int n, int n2) {
        float f = 0.0f;
        for (int i = n; i < n + n2; ++i) {
            f += fArray[i];
        }
        return f;
    }

    public static final float min(float[] fArray) {
        return ArrayUtilities.min(fArray, 0, fArray.length);
    }

    public static final float min(float[] fArray, int n, int n2) {
        float f = fArray[n];
        for (int i = n; i < n + n2; ++i) {
            if (!(f > fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    public static final float max(float[] fArray) {
        return ArrayUtilities.max(fArray, 0, fArray.length);
    }

    public static final float max(float[] fArray, int n, int n2) {
        float f = fArray[n];
        for (int i = n; i < n + n2; ++i) {
            if (!(f > fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    public static final boolean equal(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final int[] copy(int[] nArray, int[] nArray2) {
        if (nArray2 == null || nArray2.length != nArray.length) {
            return (int[])nArray.clone();
        }
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final int[] size(int[] nArray, int n) {
        return nArray != null && nArray.length == n ? nArray : new int[n];
    }

    public static final int[] resize(int[] nArray, int n) {
        if (nArray != null && nArray.length == n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(n, nArray.length));
        return nArray2;
    }

    public static final int[] unrole(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray2.length * n;
        if (nArray == null || nArray.length != nArray2.length * n) {
            nArray = new int[n2];
        }
        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
        int n3 = nArray2.length;
        while (2 * n3 < n2) {
            System.arraycopy(nArray, 0, nArray, n3, n3);
            n3 *= 2;
        }
        System.arraycopy(nArray, 0, nArray, n3, n2 - n3);
        return nArray;
    }

    public static final int[] concat(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray.length != nArray2.length + nArray3.length) {
            nArray = new int[nArray2.length + nArray3.length];
        }
        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
        System.arraycopy(nArray3, 0, nArray, nArray2.length, nArray3.length);
        return nArray;
    }

    public static final void fill(int[] nArray, int n) {
        ArrayUtilities.fill(nArray, 0, nArray.length, n);
    }

    public static final void fill(int[] nArray, int n, int n2, int n3) {
        if (n2 < 1) {
            return;
        }
        nArray[n + 0] = n3;
        if (n2 < 2) {
            return;
        }
        nArray[n + 1] = n3;
        if (n2 < 3) {
            return;
        }
        nArray[n + 2] = n3;
        if (n2 < 4) {
            return;
        }
        nArray[n + 3] = n3;
        if (n2 < 5) {
            return;
        }
        nArray[n + 4] = n3;
        int n4 = 5;
        while (2 * n4 < n2) {
            System.arraycopy(nArray, n, nArray, n + n4, n4);
            n4 *= 2;
        }
        System.arraycopy(nArray, n, nArray, n + n4, n2 - n4);
    }

    public static final int sum(int[] nArray) {
        return ArrayUtilities.sum(nArray, 0, nArray.length);
    }

    public static final int sum(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += nArray[i];
        }
        return n3;
    }

    public static final int min(int[] nArray) {
        return ArrayUtilities.min(nArray, 0, nArray.length);
    }

    public static final int min(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        for (int i = n; i < n + n2; ++i) {
            if (n3 <= nArray[i]) continue;
            n3 = nArray[i];
        }
        return n3;
    }

    public static final int max(int[] nArray) {
        return ArrayUtilities.max(nArray, 0, nArray.length);
    }

    public static final int max(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        for (int i = n; i < n + n2; ++i) {
            if (n3 <= nArray[i]) continue;
            n3 = nArray[i];
        }
        return n3;
    }
}

