/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDistQuick;
import umontreal.iro.lecuyer.util.RootFinder;

public class AndersonDarlingDist
extends ContinuousDistribution {
    protected int n;

    public AndersonDarlingDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        return AndersonDarlingDist.density(this.n, x);
    }

    public double cdf(double x) {
        return AndersonDarlingDist.cdf(this.n, x);
    }

    public double barF(double x) {
        return AndersonDarlingDist.barF(this.n, x);
    }

    public double inverseF(double u) {
        return AndersonDarlingDist.inverseF(this.n, u);
    }

    private static double dclem(int n, double x, double EPS) {
        return (AndersonDarlingDist.cdf(n, x + EPS) - AndersonDarlingDist.cdf(n, x - EPS)) / (2.0 * EPS);
    }

    protected static double density_N_1(double x) {
        double AD_X0 = 0.38629436111989063;
        double AD_X1 = 37.816242111357;
        if (x <= 0.38629436111989063 || x >= 37.816242111357) {
            return 0.0;
        }
        double t = Math.exp(-x - 1.0);
        return 2.0 * t / Math.sqrt(1.0 - 4.0 * t);
    }

    public static double density(int n, double x) {
        double D2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            return AndersonDarlingDist.density_N_1(x);
        }
        if (x >= 100.0 || x <= 0.0) {
            return 0.0;
        }
        double EPS = 0.01;
        double D1 = AndersonDarlingDist.dclem(n, x, 0.01);
        double RES = D1 + (D1 - (D2 = AndersonDarlingDist.dclem(n, x, 0.02))) / 3.0;
        if (RES <= 0.0) {
            return 0.0;
        }
        return RES;
    }

    protected static double cdf_N_1(double x) {
        double AD_X0 = 0.38629436111989063;
        double AD_X1 = 37.816242111357;
        if (x <= 0.38629436111989063) {
            return 0.0;
        }
        if (x >= 37.816242111357) {
            return 1.0;
        }
        return Math.sqrt(1.0 - 4.0 * Math.exp(-x - 1.0));
    }

    private static double ADf(double z, int j) {
        double T = (4.0 * (double)j + 1.0) * (4.0 * (double)j + 1.0) * 1.23370055013617 / z;
        if (T > 150.0) {
            return 0.0;
        }
        double a = 2.22144146907918 * Math.exp(-T) / Math.sqrt(T);
        double b = 7.8748049728612 * NormalDistQuick.barF01(Math.sqrt(2.0 * T));
        double r = z * 0.125;
        double f = a + b * r;
        for (int i = 1; i < 200; ++i) {
            double c = (((double)i - 0.5 - T) * b + T * a) / (double)i;
            a = b;
            b = c;
            if (Math.abs(r *= z / (double)(8 * i + 8)) < 1.0E-40 || Math.abs(c) < 1.0E-40) {
                return f;
            }
            double fnew = f + c * r;
            if (f == fnew) {
                return f;
            }
            f = fnew;
        }
        return f;
    }

    private static double ADinf(double z) {
        if (z < 0.01) {
            return 0.0;
        }
        double r = 1.0 / z;
        double ad = r * AndersonDarlingDist.ADf(z, 0);
        for (int j = 1; j < 100; ++j) {
            double adnew = ad + (double)(4 * j + 1) * (r *= (0.5 - (double)j) / (double)j) * AndersonDarlingDist.ADf(z, j);
            if (ad == adnew) {
                return ad;
            }
            ad = adnew;
        }
        return ad;
    }

    private static double adinf(double z) {
        if (z < 2.0) {
            return Math.exp(-1.2337141 / z) / Math.sqrt(z) * (2.00012 + (0.247105 - (0.0649821 - (0.0347962 - (0.011672 - 0.00168691 * z) * z) * z) * z) * z);
        }
        return Math.exp(-Math.exp(1.0776 - (2.30695 - (0.43424 - (0.082433 - (0.008056 - 3.146E-4 * z) * z) * z) * z) * z));
    }

    private static double AD(int n, double z, boolean isFastADinf) {
        double x = isFastADinf ? AndersonDarlingDist.adinf(z) : AndersonDarlingDist.ADinf(z);
        if (x > 0.8) {
            double v = (-130.2137 + (745.2337 - (1705.091 - (1950.646 - (1116.36 - 255.7844 * x) * x) * x) * x) * x) / (double)n;
            return x + v;
        }
        double C = 0.01265 + 0.1757 / (double)n;
        if (x < C) {
            double v = x / C;
            v = Math.sqrt(v) * (1.0 - v) * (49.0 * v - 102.0);
            return x + v * (0.0037 / (double)(n * n) + 7.8E-4 / (double)n + 6.0E-5) / (double)n;
        }
        double v = (x - C) / (0.8 - C);
        v = -2.2633E-4 + (6.54034 - (14.6538 - (14.458 - (8.259 - 1.91864 * v) * v) * v) * v) * v;
        return x + v * (0.04213 + 0.01365 / (double)n) / (double)n;
    }

    public static double cdf(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 100.0) {
            return 1.0;
        }
        if (1 == n) {
            return AndersonDarlingDist.cdf_N_1(x);
        }
        double RES = AndersonDarlingDist.AD(n, x, true);
        if (RES <= 0.0) {
            return 0.0;
        }
        return RES;
    }

    protected static double barF_N_1(double x) {
        if (x <= 0.38629436111989) {
            return 1.0;
        }
        if (x >= 1000.0) {
            return 0.0;
        }
        if (x < 6.0) {
            double q = 1.0 - 4.0 * Math.exp(-x - 1.0);
            return 1.0 - Math.sqrt(q);
        }
        double q = 4.0 * Math.exp(-x - 1.0);
        return 0.5 * q * (1.0 + 0.25 * q * (1.0 + 0.5 * q * (1.0 + 0.125 * q * (5.0 + 3.5 * q))));
    }

    public static double barF(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            return AndersonDarlingDist.barF_N_1(x);
        }
        return 1.0 - AndersonDarlingDist.cdf(n, x);
    }

    protected static double inverse_N_1(double u) {
        double AD_X0 = 0.38629436111989063;
        if (u <= 0.0) {
            return 0.38629436111989063;
        }
        double AD_X1 = 37.816242111357;
        if (u >= 1.0) {
            return 37.816242111357;
        }
        return 0.38629436111989063 - Math.log1p(-u * u);
    }

    public static double inverseF(int n, double u) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (n == 1) {
            return AndersonDarlingDist.inverse_N_1(u);
        }
        if (u == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u == 0.0) {
            return 0.0;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.0, 50.0, f, 1.0E-10);
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n < 1");
        }
        this.n = n;
        if (1 == n) {
            this.supportA = 0.38629436111989063;
            this.supportB = 37.816242111357;
        } else {
            this.supportA = 0.0;
            this.supportB = 1000.0;
        }
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - AndersonDarlingDist.cdf(this.n, x);
        }
    }
}

