/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class Pearson5Dist
extends ContinuousDistribution {
    protected double alpha;
    protected double beta;

    public Pearson5Dist(double alpha, double beta) {
        this.setParam(alpha, beta);
    }

    public double density(double x) {
        return Pearson5Dist.density(this.alpha, this.beta, x);
    }

    public double cdf(double x) {
        return Pearson5Dist.cdf(this.alpha, this.beta, x);
    }

    public double barF(double x) {
        return Pearson5Dist.barF(this.alpha, this.beta, x);
    }

    public double inverseF(double u) {
        return Pearson5Dist.inverseF(this.alpha, this.beta, u);
    }

    public double getMean() {
        return Pearson5Dist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return Pearson5Dist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return Pearson5Dist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(alpha * Math.log(beta) - (alpha + 1.0) * Math.log(x) - beta / x - Num.lnGamma(alpha));
    }

    public static double cdf(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return GammaDist.barF(alpha, beta, 15, 1.0 / x);
    }

    public static double barF(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        return GammaDist.cdf(alpha, beta, 15, 1.0 / x);
    }

    public static double inverseF(double alpha, double beta, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return 1.0 / GammaDist.inverseF(alpha, beta, 15, 1.0 - u);
    }

    public static double[] getMLE(double[] x, int n) {
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            y[i] = x[i] > 0.0 ? 1.0 / x[i] : 1.0E100;
        }
        return GammaDist.getMaximumLikelihoodEstimate(y, n);
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int n) {
        return Pearson5Dist.getMLE(x, n);
    }

    public static Pearson5Dist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = Pearson5Dist.getMaximumLikelihoodEstimate(x, n);
        return new Pearson5Dist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return beta / (alpha - 1.0);
    }

    public static double getVariance(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return beta * beta / ((alpha - 1.0) * (alpha - 1.0) * (alpha - 2.0));
    }

    public static double getStandardDeviation(double alpha, double beta) {
        return Math.sqrt(Pearson5Dist.getVariance(alpha, beta));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParam(double alpha, double beta) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.supportA = 0.0;
        this.alpha = alpha;
        this.beta = beta;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }
}

