/*
 * This file is part of Jstacs.
 * 
 * Jstacs is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * Jstacs is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * Jstacs. If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package projects.tals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;

/**
 * Class for the TALgetter13 model
 * 
 * @author Jan Grau
 *
 */
public class TALgetter13DiffSM extends TALgetterDiffSM {

	public TALgetter13DiffSM( AlphabetContainer alphabets, AlphabetContainer alphabetsRVD, int length, double midLength, double Ess,
								int order_talU, int p_anz, boolean p_gesamte_seq, double[] priorFP, double[] priorImp, double[][] priorPrefs )
																																				throws Exception {
		super( alphabets, alphabetsRVD, length, midLength, Ess, order_talU, p_anz, p_gesamte_seq, priorFP, priorImp, priorPrefs );
	}

	public TALgetter13DiffSM( StringBuffer xml ) throws NonParsableException {
		super( xml );
	}

	@Override
	protected TALgetterRVDDependentComponent getTalANsf( AlphabetContainer alphabets, AlphabetContainer alphabetsRVD, int midLength, double Ess, double part,
			double[] priorImp, double[][] priorPrefs ) throws Exception {
		return new TAL_A_NSFMap(alphabets, alphabetsRVD, (int)midLength, Ess*part, priorImp,priorPrefs);
	}

	
	
}
