/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.OdeSolverBasedIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.BulirschStoer;

public final class BulirschStoerIntegrator
extends OdeSolverBasedIntegrator {
    private static final long serialVersionUID = 1L;
    double initialStepSize = 0.1;
    double eps = 1.0E-7;

    public BulirschStoerIntegrator() {
        super(new BulirschStoer());
    }

    public BulirschStoerIntegrator(RealFunctionOfOneVariable realFunctionOfOneVariable) {
        super(new BulirschStoer(1));
        this.setFunction(realFunctionOfOneVariable);
    }

    public BulirschStoerIntegrator(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable) {
        super(new BulirschStoer(realVectorValuedFunctionOfOneVariable.getDimensionOfTargetSpace()));
        this.setFunction(realVectorValuedFunctionOfOneVariable);
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setInitialStepSize(double d) {
        if (this.initialStepSize == d) {
            return;
        }
        this.initialStepSize = d;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double d) {
        ((BulirschStoer)this.odeSolver).setEps(d);
        if (this.eps == d) {
            return;
        }
        this.eps = d;
    }

    public static double integrate(RealFunctionOfOneVariable realFunctionOfOneVariable, double d, double d2) {
        return BulirschStoerIntegrator.integrate(realFunctionOfOneVariable, d, d2, 1.0E-12);
    }

    public static double integrate(RealFunctionOfOneVariable realFunctionOfOneVariable, double d, double d2, double d3) {
        BulirschStoerIntegrator bulirschStoerIntegrator = new BulirschStoerIntegrator(realFunctionOfOneVariable);
        bulirschStoerIntegrator.setEps(d3);
        return bulirschStoerIntegrator.integrate(d, d2);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable, double[] dArray, double d, double d2) {
        BulirschStoerIntegrator.integrate(realVectorValuedFunctionOfOneVariable, d, d2, dArray, 1.0E-12);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable realVectorValuedFunctionOfOneVariable, double d, double d2, double[] dArray, double d3) {
        BulirschStoerIntegrator bulirschStoerIntegrator = new BulirschStoerIntegrator(realVectorValuedFunctionOfOneVariable);
        bulirschStoerIntegrator.setEps(d3);
        bulirschStoerIntegrator.integrate(d, d2, dArray);
    }
}

