/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.hyperSurface;

import java.io.Serializable;

public class MarchingCubes
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[] point;
    int[] index;
    double[] min;
    double[] max;
    static int[][] triTable = new int[][]{new int[0], {0, 8, 3}, {0, 1, 9}, {1, 8, 3, 9, 8, 1}, {1, 2, 10}, {0, 8, 3, 1, 2, 10}, {9, 2, 10, 0, 2, 9}, {2, 8, 3, 2, 10, 8, 10, 9, 8}, {3, 11, 2}, {0, 11, 2, 8, 11, 0}, {1, 9, 0, 2, 3, 11}, {1, 11, 2, 1, 9, 11, 9, 8, 11}, {3, 10, 1, 11, 10, 3}, {0, 10, 1, 0, 8, 10, 8, 11, 10}, {3, 9, 0, 3, 11, 9, 11, 10, 9}, {9, 8, 10, 10, 8, 11}, {4, 7, 8}, {4, 3, 0, 7, 3, 4}, {0, 1, 9, 8, 4, 7}, {4, 1, 9, 4, 7, 1, 7, 3, 1}, {1, 2, 10, 8, 4, 7}, {3, 4, 7, 3, 0, 4, 1, 2, 10}, {9, 2, 10, 9, 0, 2, 8, 4, 7}, {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4}, {8, 4, 7, 3, 11, 2}, {11, 4, 7, 11, 2, 4, 2, 0, 4}, {9, 0, 1, 8, 4, 7, 2, 3, 11}, {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1}, {3, 10, 1, 3, 11, 10, 7, 8, 4}, {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4}, {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3}, {4, 7, 11, 4, 11, 9, 9, 11, 10}, {9, 5, 4}, {9, 5, 4, 0, 8, 3}, {0, 5, 4, 1, 5, 0}, {8, 5, 4, 8, 3, 5, 3, 1, 5}, {1, 2, 10, 9, 5, 4}, {3, 0, 8, 1, 2, 10, 4, 9, 5}, {5, 2, 10, 5, 4, 2, 4, 0, 2}, {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8}, {9, 5, 4, 2, 3, 11}, {0, 11, 2, 0, 8, 11, 4, 9, 5}, {0, 5, 4, 0, 1, 5, 2, 3, 11}, {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5}, {10, 3, 11, 10, 1, 3, 9, 5, 4}, {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10}, {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3}, {5, 4, 8, 5, 8, 10, 10, 8, 11}, {9, 7, 8, 5, 7, 9}, {9, 3, 0, 9, 5, 3, 5, 7, 3}, {0, 7, 8, 0, 1, 7, 1, 5, 7}, {1, 5, 3, 3, 5, 7}, {9, 7, 8, 9, 5, 7, 10, 1, 2}, {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3}, {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2}, {2, 10, 5, 2, 5, 3, 3, 5, 7}, {7, 9, 5, 7, 8, 9, 3, 11, 2}, {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11}, {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7}, {11, 2, 1, 11, 1, 7, 7, 1, 5}, {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11}, {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0}, {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0}, {11, 10, 5, 7, 11, 5}, {10, 6, 5}, {0, 8, 3, 5, 10, 6}, {9, 0, 1, 5, 10, 6}, {1, 8, 3, 1, 9, 8, 5, 10, 6}, {1, 6, 5, 2, 6, 1}, {1, 6, 5, 1, 2, 6, 3, 0, 8}, {9, 6, 5, 9, 0, 6, 0, 2, 6}, {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8}, {2, 3, 11, 10, 6, 5}, {11, 0, 8, 11, 2, 0, 10, 6, 5}, {0, 1, 9, 2, 3, 11, 5, 10, 6}, {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11}, {6, 3, 11, 6, 5, 3, 5, 1, 3}, {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6}, {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9}, {6, 5, 9, 6, 9, 11, 11, 9, 8}, {5, 10, 6, 4, 7, 8}, {4, 3, 0, 4, 7, 3, 6, 5, 10}, {1, 9, 0, 5, 10, 6, 8, 4, 7}, {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4}, {6, 1, 2, 6, 5, 1, 4, 7, 8}, {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7}, {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6}, {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9}, {3, 11, 2, 7, 8, 4, 10, 6, 5}, {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11}, {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6}, {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6}, {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6}, {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11}, {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7}, {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9}, {10, 4, 9, 6, 4, 10}, {4, 10, 6, 4, 9, 10, 0, 8, 3}, {10, 0, 1, 10, 6, 0, 6, 4, 0}, {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10}, {1, 4, 9, 1, 2, 4, 2, 6, 4}, {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4}, {0, 2, 4, 4, 2, 6}, {8, 3, 2, 8, 2, 4, 4, 2, 6}, {10, 4, 9, 10, 6, 4, 11, 2, 3}, {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6}, {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10}, {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1}, {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3}, {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1}, {3, 11, 6, 3, 6, 0, 0, 6, 4}, {6, 4, 8, 11, 6, 8}, {7, 10, 6, 7, 8, 10, 8, 9, 10}, {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10}, {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0}, {10, 6, 7, 10, 7, 1, 1, 7, 3}, {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7}, {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9}, {7, 8, 0, 7, 0, 6, 6, 0, 2}, {7, 3, 2, 6, 7, 2}, {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7}, {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7}, {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11}, {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1}, {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6}, {0, 9, 1, 11, 6, 7}, {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0}, {7, 11, 6}, {7, 6, 11}, {3, 0, 8, 11, 7, 6}, {0, 1, 9, 11, 7, 6}, {8, 1, 9, 8, 3, 1, 11, 7, 6}, {10, 1, 2, 6, 11, 7}, {1, 2, 10, 3, 0, 8, 6, 11, 7}, {2, 9, 0, 2, 10, 9, 6, 11, 7}, {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8}, {7, 2, 3, 6, 2, 7}, {7, 0, 8, 7, 6, 0, 6, 2, 0}, {2, 7, 6, 2, 3, 7, 0, 1, 9}, {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6}, {10, 7, 6, 10, 1, 7, 1, 3, 7}, {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8}, {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7}, {7, 6, 10, 7, 10, 8, 8, 10, 9}, {6, 8, 4, 11, 8, 6}, {3, 6, 11, 3, 0, 6, 0, 4, 6}, {8, 6, 11, 8, 4, 6, 9, 0, 1}, {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6}, {6, 8, 4, 6, 11, 8, 2, 10, 1}, {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6}, {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9}, {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3}, {8, 2, 3, 8, 4, 2, 4, 6, 2}, {0, 4, 2, 4, 6, 2}, {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8}, {1, 9, 4, 1, 4, 2, 2, 4, 6}, {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1}, {10, 1, 0, 10, 0, 6, 6, 0, 4}, {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3}, {10, 9, 4, 6, 10, 4}, {4, 9, 5, 7, 6, 11}, {0, 8, 3, 4, 9, 5, 11, 7, 6}, {5, 0, 1, 5, 4, 0, 7, 6, 11}, {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5}, {9, 5, 4, 10, 1, 2, 7, 6, 11}, {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5}, {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2}, {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6}, {7, 2, 3, 7, 6, 2, 5, 4, 9}, {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7}, {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0}, {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8}, {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7}, {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4}, {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10}, {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10}, {6, 9, 5, 6, 11, 9, 11, 8, 9}, {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5}, {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11}, {6, 11, 3, 6, 3, 5, 5, 3, 1}, {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6}, {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10}, {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5}, {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3}, {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2}, {9, 5, 6, 9, 6, 0, 0, 6, 2}, {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8}, {1, 5, 6, 2, 1, 6}, {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6}, {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0}, {0, 3, 8, 5, 6, 10}, {10, 5, 6}, {11, 5, 10, 7, 5, 11}, {11, 5, 10, 11, 7, 5, 8, 3, 0}, {5, 11, 7, 5, 10, 11, 1, 9, 0}, {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1}, {11, 1, 2, 11, 7, 1, 7, 5, 1}, {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11}, {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7}, {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2}, {2, 5, 10, 2, 3, 5, 3, 7, 5}, {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5}, {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2}, {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2}, {1, 3, 5, 3, 7, 5}, {0, 8, 7, 0, 7, 1, 1, 7, 5}, {9, 0, 3, 9, 3, 5, 5, 3, 7}, {9, 8, 7, 5, 9, 7}, {5, 8, 4, 5, 10, 8, 10, 11, 8}, {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0}, {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5}, {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4}, {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8}, {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11}, {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5}, {9, 4, 5, 2, 11, 3}, {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4}, {5, 10, 2, 5, 2, 4, 4, 2, 0}, {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9}, {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2}, {8, 4, 5, 8, 5, 3, 3, 5, 1}, {0, 4, 5, 1, 0, 5}, {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5}, {9, 4, 5}, {4, 11, 7, 4, 9, 11, 9, 10, 11}, {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11}, {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11}, {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4}, {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2}, {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3}, {11, 7, 4, 11, 4, 2, 2, 4, 0}, {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4}, {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9}, {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7}, {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10}, {1, 10, 2, 8, 7, 4}, {4, 9, 1, 4, 1, 7, 7, 1, 3}, {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1}, {4, 0, 3, 7, 4, 3}, {4, 8, 7}, {9, 10, 8, 10, 11, 8}, {3, 0, 9, 3, 9, 11, 11, 9, 10}, {0, 1, 10, 0, 10, 8, 8, 10, 11}, {3, 1, 10, 11, 3, 10}, {1, 2, 11, 1, 11, 9, 9, 11, 8}, {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9}, {0, 2, 11, 8, 0, 11}, {3, 2, 11}, {2, 3, 8, 2, 8, 10, 10, 8, 9}, {9, 10, 2, 0, 9, 2}, {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8}, {1, 10, 2}, {1, 3, 8, 9, 1, 8}, {0, 9, 1}, {0, 3, 8}, new int[0]};

    public MarchingCubes() {
        this.min = new double[]{-0.5, -0.5, -0.5};
        this.max = new double[]{0.5, 0.5, 0.5};
    }

    public MarchingCubes(double[][][] dArray, double d, double[] dArray2, double[] dArray3) {
        this.min = dArray2;
        this.max = dArray3;
        this.triangulate(dArray, d);
    }

    public double getMin(int n) {
        return this.min[n];
    }

    public void setMin(int n, double d) {
        if (this.min[n] == d) {
            return;
        }
        if (this.max[n] <= d) {
            throw new IllegalArgumentException(" max must be bigger then min");
        }
        this.rescale(n, d, this.min[n], this.max[n], this.max[n]);
        this.min[n] = d;
    }

    public double getMax(int n) {
        return this.max[n];
    }

    public void setMax(int n, double d) {
        if (this.max[n] == d) {
            return;
        }
        if (this.min[n] >= d) {
            throw new IllegalArgumentException(" max must be bigger then min");
        }
        this.rescale(n, this.min[n], this.min[n], d, this.max[n]);
        this.max[n] = d;
    }

    private void rescale(int n, double d, double d2, double d3, double d4) {
        if (this.point == null) {
            return;
        }
        double d5 = (d3 - d) / (d4 - d2);
        double d6 = d - d2 * d5;
        for (int i = n; i < this.point.length; i += 3) {
            this.point[i] = d6 + this.point[i] * d5;
        }
    }

    public double[] getPoints() {
        return this.point;
    }

    public int[] getIndices() {
        return this.index;
    }

    public void triangulate(final double[][][] dArray, double d) {
        RealFunctionOnTripleIndex realFunctionOnTripleIndex = new RealFunctionOnTripleIndex(){
            {
                this.xSize = dArray.length;
                this.ySize = dArray[0].length;
                this.zSize = dArray[0][0].length;
            }

            double valueAt(int n, int n2, int n3) {
                return dArray[n][n2][n3];
            }
        };
        this.triangulate(realFunctionOnTripleIndex, d);
    }

    public void triangulate(final RealFunctionOnReal3 realFunctionOnReal3, final int[] nArray, double d) {
        RealFunctionOnTripleIndex realFunctionOnTripleIndex = new RealFunctionOnTripleIndex(){
            final double xs;
            final double ys;
            final double zs;
            final double xMin;
            final double yMin;
            final double zMin;
            final double xMax;
            final double yMax;
            final double zMax;
            {
                this.xSize = nArray[0];
                this.ySize = nArray[1];
                this.zSize = nArray[2];
                this.xs = 1.0 / (double)(this.xSize - 1);
                this.ys = 1.0 / (double)(this.ySize - 1);
                this.zs = 1.0 / (double)(this.zSize - 1);
                this.xMin = MarchingCubes.this.min[0];
                this.yMin = MarchingCubes.this.min[1];
                this.zMin = MarchingCubes.this.min[2];
                this.xMax = MarchingCubes.this.max[0];
                this.yMax = MarchingCubes.this.max[1];
                this.zMax = MarchingCubes.this.max[2];
            }

            double valueAt(int n, int n2, int n3) {
                double d = this.xMin * (1.0 - (double)n * this.xs) + this.xMax * (double)n * this.xs;
                double d2 = this.yMin * (1.0 - (double)n2 * this.ys) + this.yMax * (double)n2 * this.ys;
                double d3 = this.zMin * (1.0 - (double)n3 * this.zs) + this.zMax * (double)n3 * this.zs;
                return realFunctionOnReal3.valueAt(d, d2, d3);
            }
        };
        this.triangulate(realFunctionOnTripleIndex, d);
    }

    void triangulate(RealFunctionOnTripleIndex realFunctionOnTripleIndex, double d) {
        double d2;
        double d3;
        double d4;
        int n;
        double d5;
        int n2;
        int n3;
        int n4 = realFunctionOnTripleIndex.xSize;
        int n5 = realFunctionOnTripleIndex.ySize;
        int n6 = realFunctionOnTripleIndex.zSize;
        int[][][] nArray = new int[n4 - 1][n5][n6];
        int[][][] nArray2 = new int[n4][n5 - 1][n6];
        int[][][] nArray3 = new int[n4][n5][n6 - 1];
        int n7 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                d5 = realFunctionOnTripleIndex.valueAt(n3, n2, 0);
                for (n = 1; n < n6; ++n) {
                    d4 = realFunctionOnTripleIndex.valueAt(n3, n2, n);
                    if (d4 < d && d5 >= d || d5 < d && d4 >= d) {
                        d3 = (d - d5) / (d4 - d5);
                        d2 = (double)(n - 1) + d3;
                        this.setPoint(n7, n3, n2, d2);
                        nArray3[n3][n2][n - 1] = n7++;
                    } else {
                        nArray3[n3][n2][n - 1] = -1;
                    }
                    d5 = d4;
                }
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                d5 = realFunctionOnTripleIndex.valueAt(0, n3, n2);
                for (n = 1; n < n4; ++n) {
                    d4 = realFunctionOnTripleIndex.valueAt(n, n3, n2);
                    if (d4 < d && d5 >= d || d5 < d && d4 >= d) {
                        d3 = (d - d5) / (d4 - d5);
                        d2 = (double)(n - 1) + d3;
                        this.setPoint(n7, d2, n3, n2);
                        nArray[n - 1][n3][n2] = n7++;
                    } else {
                        nArray[n - 1][n3][n2] = -1;
                    }
                    d5 = d4;
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                d5 = realFunctionOnTripleIndex.valueAt(n3, 0, n2);
                for (n = 1; n < n5; ++n) {
                    d4 = realFunctionOnTripleIndex.valueAt(n3, n, n2);
                    if (d4 < d && d5 >= d || d5 < d && d4 >= d) {
                        d3 = (d - d5) / (d4 - d5);
                        d2 = (double)(n - 1) + d3;
                        this.setPoint(n7, n3, d2, n2);
                        nArray2[n3][n - 1][n2] = n7++;
                    } else {
                        nArray2[n3][n - 1][n2] = -1;
                    }
                    d5 = d4;
                }
            }
        }
        this.setNumOfPoints(n7);
        n3 = 0;
        int[] nArray4 = new int[12];
        for (int i = 0; i < n4 - 1; ++i) {
            for (int j = 0; j < n5 - 1; ++j) {
                for (n = 0; n < n6 - 1; ++n) {
                    int n8 = 0;
                    if (realFunctionOnTripleIndex.valueAt(i, j, n) < d) {
                        n8 |= 1;
                    }
                    if (realFunctionOnTripleIndex.valueAt(i + 1, j, n) < d) {
                        n8 |= 2;
                    }
                    if (realFunctionOnTripleIndex.valueAt(i + 1, j, n + 1) < d) {
                        n8 |= 4;
                    }
                    if (realFunctionOnTripleIndex.valueAt(i, j, n + 1) < d) {
                        n8 |= 8;
                    }
                    if (realFunctionOnTripleIndex.valueAt(i, j + 1, n) < d) {
                        n8 |= 0x10;
                    }
                    if (realFunctionOnTripleIndex.valueAt(i + 1, j + 1, n) < d) {
                        n8 |= 0x20;
                    }
                    if (realFunctionOnTripleIndex.valueAt(i + 1, j + 1, n + 1) < d) {
                        n8 |= 0x40;
                    }
                    if (realFunctionOnTripleIndex.valueAt(i, j + 1, n + 1) < d) {
                        n8 |= 0x80;
                    }
                    if (n8 == 0 || n8 == 255) continue;
                    nArray4[0] = nArray[i][j][n];
                    nArray4[2] = nArray[i][j][n + 1];
                    nArray4[4] = nArray[i][j + 1][n];
                    nArray4[6] = nArray[i][j + 1][n + 1];
                    nArray4[8] = nArray2[i][j][n];
                    nArray4[9] = nArray2[i + 1][j][n];
                    nArray4[10] = nArray2[i + 1][j][n + 1];
                    nArray4[11] = nArray2[i][j][n + 1];
                    nArray4[1] = nArray3[i + 1][j][n];
                    nArray4[3] = nArray3[i][j][n];
                    nArray4[5] = nArray3[i + 1][j + 1][n];
                    nArray4[7] = nArray3[i][j + 1][n];
                    int n9 = 0;
                    while (n9 < triTable[n8].length) {
                        this.setTriangle(n3, nArray4[triTable[n8][n9]], nArray4[triTable[n8][n9 + 1]], nArray4[triTable[n8][n9 + 2]]);
                        n9 += 3;
                        ++n3;
                    }
                }
            }
        }
        this.setNumOfTriangles(n3);
        this.rescale(0, this.min[0], 0.0, this.max[0], n4 - 1);
        this.rescale(1, this.min[1], 0.0, this.max[1], n5 - 1);
        this.rescale(2, this.min[2], 0.0, this.max[2], n6 - 1);
    }

    private void setPoint(int n, double d, double d2, double d3) {
        if (this.point == null || this.point.length <= 3 * n) {
            double[] dArray = new double[3 * n + 300];
            if (this.point != null) {
                System.arraycopy(this.point, 0, dArray, 0, this.point.length);
            }
            this.point = dArray;
        }
        this.point[3 * n] = d;
        this.point[3 * n + 1] = d2;
        this.point[3 * n + 2] = d3;
    }

    private void setNumOfPoints(int n) {
        if (this.point != null && this.point.length == 3 * n) {
            return;
        }
        double[] dArray = new double[3 * n];
        if (this.point != null) {
            System.arraycopy(this.point, 0, dArray, 0, Math.min(3 * n, this.point.length));
        }
        this.point = dArray;
    }

    private void setTriangle(int n, int n2, int n3, int n4) {
        if (this.index == null || this.index.length <= 3 * n) {
            int[] nArray = new int[3 * n + 300];
            if (this.index != null) {
                System.arraycopy(this.index, 0, nArray, 0, this.index.length);
            }
            this.index = nArray;
        }
        this.index[3 * n] = n2;
        this.index[3 * n + 1] = n3;
        this.index[3 * n + 2] = n4;
    }

    private void setNumOfTriangles(int n) {
        if (this.index != null && this.index.length == 3 * n) {
            return;
        }
        int[] nArray = new int[3 * n];
        if (this.index != null) {
            System.arraycopy(this.index, 0, nArray, 0, Math.min(3 * n, this.index.length));
        }
        this.index = nArray;
    }

    public static interface RealFunctionOnReal3 {
        public double valueAt(double var1, double var3, double var5);
    }

    static abstract class RealFunctionOnTripleIndex {
        int xSize;
        int ySize;
        int zSize;

        RealFunctionOnTripleIndex() {
        }

        abstract double valueAt(int var1, int var2, int var3);
    }
}

