/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment;

import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.util.List;

public class StringAlignment
implements Comparable<StringAlignment>,
Storable {
    private String[] r;
    private double cost;
    private Result res;

    public StringAlignment(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
    }

    public StringAlignment(double cost, String ... strings) {
        this(cost, strings, (Result)null);
    }

    public StringAlignment(double cost, String[] strings, Result res) {
        this.cost = cost;
        this.r = (String[])strings.clone();
        this.res = res;
    }

    public Result getAnnotationResult() {
        return this.res;
    }

    public double getCost() {
        return this.cost;
    }

    public int getNumberOfAlignedSequences() {
        return this.r.length;
    }

    public String getAlignedString(int index) {
        return this.r[index];
    }

    public String toString() {
        return this.toString(Integer.MAX_VALUE, -1, null);
    }

    public String toString(int chunkSize, int simplifyIdx, List<String> annot) {
        String[] d;
        StringBuffer buf = new StringBuffer();
        if (simplifyIdx >= 0) {
            StringBuffer[] data = new StringBuffer[this.r.length];
            int[] start = new int[this.r.length];
            int[] end = new int[this.r.length];
            int i = 0;
            while (i < this.r.length) {
                data[i] = new StringBuffer();
                int l = 0;
                while (l < this.r[i].length() && this.r[i].charAt(l) == '-') {
                    ++l;
                }
                start[i] = l;
                l = this.r[i].length() - 1;
                while (l >= 0 && this.r[i].charAt(l) == '-') {
                    --l;
                }
                end[i] = l;
                ++i;
            }
            int same = 46;
            int border = 32;
            int l = 0;
            while (l < this.r[simplifyIdx].length()) {
                int i2 = 0;
                while (i2 < this.r.length) {
                    data[i2].append((char)(i2 == simplifyIdx ? this.r[i2].charAt(l) : (start[i2] <= l && l <= end[i2] ? (this.r[i2].charAt(l) == this.r[simplifyIdx].charAt(l) ? same : (int)this.r[i2].charAt(l)) : border)));
                    ++i2;
                }
                ++l;
            }
            d = new String[this.r.length];
            int i3 = 0;
            while (i3 < this.r.length) {
                d[i3] = data[i3].toString();
                ++i3;
            }
        } else {
            d = this.r;
        }
        int start = 0;
        while (start < d[0].length()) {
            int end = Math.min(start + chunkSize, d[0].length());
            int i = 0;
            while (i < this.r.length) {
                buf.append(d[i].substring(start, end));
                if (annot != null && i < annot.size()) {
                    buf.append("\t");
                    buf.append(annot.get(i));
                }
                buf.append("\n");
                ++i;
            }
            buf.append("\n");
            start += chunkSize;
        }
        buf.append("costs: ");
        buf.append(this.cost);
        return buf.toString();
    }

    public int getLength() {
        return this.r[0].length();
    }

    @Override
    public int compareTo(StringAlignment o) {
        if (this.getNumberOfAlignedSequences() == o.getNumberOfAlignedSequences()) {
            int n = this.getNumberOfAlignedSequences();
            int c = 0;
            int i = 0;
            while (i < n && (c = this.r[i].compareTo(o.r[i])) == 0) {
                ++i;
            }
            return c;
        }
        return this.getNumberOfAlignedSequences() - o.getNumberOfAlignedSequences();
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "StringAlignment");
        this.cost = (Double)XMLParser.extractObjectForTags(xml, "cost");
        this.r = (String[])XMLParser.extractObjectForTags(xml, "r");
        this.res = (Result)XMLParser.extractObjectForTags(xml, "res");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.cost, "cost");
        XMLParser.appendObjectWithTags(xml, this.r, "r");
        XMLParser.appendObjectWithTags(xml, this.res, "res");
        XMLParser.addTags(xml, "StringAlignment");
        return xml;
    }
}

