/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.OneDimensionalFunction;
import java.io.IOException;

public class QuadraticFunction
extends OneDimensionalFunction {
    private double a;
    private double b;
    private double c;

    public QuadraticFunction(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public QuadraticFunction(double x1, double fx1, double x2, double fx2, double x3, double fx3) throws IOException {
        if (x1 == x2 || x1 == x3 || x2 == x3) {
            throw new IOException("The values of x1, x2 and x3 have to be different.");
        }
        double x1x1 = x1 * x1;
        double x2x2 = x2 * x2;
        double x2_x1 = x2 - x1;
        this.a = ((fx3 - fx1) * x2_x1 - (fx2 - fx1) * (x3 - x1)) / ((x3 * x3 - x1x1) * x2_x1 - (x2x2 - x1x1) * (x3 - x1));
        this.b = (fx2 - fx1 - this.a * (x2x2 - x1x1)) / x2_x1;
        this.c = fx1 - this.a * x1x1 - this.b * x1;
    }

    @Override
    public double evaluateFunction(double x) {
        return this.a * x * x + this.b * x + this.c;
    }

    public double findMax() throws IOException {
        if (this.a >= 0.0) {
            throw new IOException("There is no maximum.");
        }
        return this.getExtremum();
    }

    public double findMin() throws IOException {
        if (this.a <= 0.0) {
            throw new IOException("There is no minimum.");
        }
        return this.getExtremum();
    }

    public double getExtremum() throws IOException {
        if (this.a == 0.0) {
            throw new IOException("There's no extremum.");
        }
        return -this.b / (2.0 * this.a);
    }

    public String toString() {
        String erg = "f(x) = ";
        if (this.a != 0.0) {
            erg = String.valueOf(erg) + this.a + " * x^2 ";
        }
        if (this.b != 0.0) {
            erg = this.b > 0.0 ? String.valueOf(erg) + "+ " + this.b + " * x " : String.valueOf(erg) + this.b + " * x ";
        }
        if (this.c != 0.0) {
            erg = this.c > 0.0 ? String.valueOf(erg) + "+ " + this.c : String.valueOf(erg) + this.c;
        }
        if (this.a == 0.0 && this.b == 0.0 && this.c == 0.0) {
            erg = String.valueOf(erg) + 0;
        }
        return erg;
    }
}

