/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.ListResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import java.util.Collection;
import java.util.LinkedList;

public class SequenceAnnotation
extends ResultSet {
    private String type;
    private String identifier;

    public SequenceAnnotation(String type, String identifier, Result result) {
        super(result);
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(String type, String identifier, Result[] ... results) {
        super(results);
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(String type, String identifier, SequenceAnnotation[] subAnnotations, Result ... additionalAnnotation) {
        super(new Result[][]{SequenceAnnotation.fuse(additionalAnnotation, subAnnotations)});
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(String type, String identifier, Collection<? extends Result> results) {
        super(results);
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public String getType() {
        return this.type;
    }

    public Result[] getAnnotations() {
        if (this.results.size() > 0) {
            LinkedList<Result> list = new LinkedList<Result>();
            int i = 0;
            while (i < this.results.size()) {
                boolean add = true;
                if (this.results.get(i) instanceof ListResult) {
                    ListResult lr = (ListResult)this.results.get(i);
                    ResultSet[] rs = lr.getRawResult();
                    int j = 0;
                    while (j < rs.length) {
                        if (rs[j] instanceof SequenceAnnotation) {
                            add = false;
                        }
                        ++j;
                    }
                }
                if (add) {
                    list.add((Result)this.results.get(i));
                }
                ++i;
            }
            if (list.size() > 0) {
                return list.toArray(new Result[0]);
            }
            return null;
        }
        return null;
    }

    public SequenceAnnotation[] getSubAnnotations() {
        if (this.results.size() > 0 && this.results.get(this.results.size() - 1) instanceof ListResult) {
            ListResult lr = (ListResult)this.results.get(this.results.size() - 1);
            ResultSet[] rs = lr.getRawResult();
            int num = 0;
            int i = 0;
            while (i < rs.length) {
                if (rs[i] instanceof SequenceAnnotation) {
                    ++num;
                }
                ++i;
            }
            if (num == 0) {
                return null;
            }
            SequenceAnnotation[] annot = new SequenceAnnotation[num];
            num = 0;
            int i2 = 0;
            while (i2 < rs.length) {
                if (rs[i2] instanceof SequenceAnnotation) {
                    annot[num] = (SequenceAnnotation)rs[i2];
                    ++num;
                }
                ++i2;
            }
            return annot;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.type);
        buf.append(", ");
        buf.append(this.identifier);
        buf.append(":\n");
        int i = 0;
        while (i < this.results.size()) {
            if (this.results.get(i) instanceof ListResult) {
                ResultSet[] ress = (ResultSet[])((Result)this.results.get(i)).getValue();
                int j = 0;
                while (j < ress.length) {
                    buf.append(ress[j].toString());
                    buf.append("\n");
                    ++j;
                }
            } else {
                buf.append(((Result)this.results.get(i)).toString());
                buf.append("\n");
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    protected void fromXML(StringBuffer source) throws NonParsableException {
        source = XMLParser.extractForTag(source, "sequenceAnnotation");
        super.fromXML(XMLParser.extractForTag(source, "results"));
        this.type = XMLParser.extractObjectForTags(source, "type", String.class);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "results");
        XMLParser.appendObjectWithTags(buf, this.type, "type");
        XMLParser.addTags(buf, "sequenceAnnotation");
        return buf;
    }

    private static Result[] fuse(Result[] res, SequenceAnnotation[] res2) {
        if (res2 == null || res2.length == 0) {
            return res;
        }
        Result[] ress = new Result[res.length + 1];
        int i = 0;
        while (i < res.length) {
            ress[i] = res[i];
            ++i;
        }
        ress[ress.length - 1] = new ListResult("Sub-annotation", "The list of sub-annotations", null, res2);
        return ress;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int hashCode() {
        int hash = this.identifier.hashCode() + 31 * this.type.hashCode();
        int i = 0;
        while (i < this.results.size()) {
            hash = 31 * hash + ((Result)this.results.get(i)).hashCode();
            ++i;
        }
        return hash;
    }
}

