/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ComparableElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;

public class ListResult
extends Result {
    protected ResultSet[] list;
    private ResultSet annotation;
    private boolean export;

    public ListResult(String name, String comment, ResultSet annotation, ResultSet ... results) {
        super(name, comment, DataType.LIST);
        this.list = new ResultSet[results.length];
        System.arraycopy(results, 0, this.list, 0, results.length);
        this.annotation = annotation;
        this.export = false;
    }

    public ListResult(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public ResultSet[] getValue() {
        int i = 0;
        ResultSet[] resultsToShow = new ResultSet[this.list.length];
        while (i < this.list.length) {
            if (this.list[i] instanceof MeanResultSet) {
                ResultSet infos = ((MeanResultSet)this.list[i]).getInfos();
                NumericalResultSet statistics = ((MeanResultSet)this.list[i]).getStatistics();
                Result[] all = new Result[infos.getNumberOfResults() + statistics.getNumberOfResults()];
                int k = 0;
                while (k < infos.getNumberOfResults()) {
                    all[k] = infos.getResultAt(k);
                    ++k;
                }
                k = 0;
                while (k < statistics.getNumberOfResults()) {
                    all[k + infos.getNumberOfResults()] = statistics.getResultAt(k);
                    ++k;
                }
                resultsToShow[i] = new ResultSet(new Result[][]{all});
            } else {
                resultsToShow[i] = this.list[i];
            }
            ++i;
        }
        return resultsToShow;
    }

    public ResultSet[] getRawResult() {
        ResultSet[] res = new ResultSet[this.list.length];
        System.arraycopy(this.list, 0, res, 0, res.length);
        return res;
    }

    public ResultSet getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getXMLTag() {
        return "listResult";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        if (this.annotation != null) {
            XMLParser.appendObjectWithTags(buf, this.annotation, "annotation");
        }
        XMLParser.appendObjectWithTags(buf, this.export, "export");
        XMLParser.appendObjectWithTags(buf, this.list, "list");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        try {
            this.annotation = XMLParser.extractObjectForTags(representation, "annotation", ResultSet.class);
        }
        catch (NonParsableException e) {
            this.annotation = null;
        }
        try {
            this.export = XMLParser.extractObjectForTags(representation, "export", Boolean.class);
        }
        catch (NonParsableException e) {
            this.export = false;
        }
        this.list = (ResultSet[])XMLParser.extractObjectForTags(representation, "list");
    }

    public String toString() {
        StringWriter s = new StringWriter();
        PrintWriter writer = new PrintWriter(s);
        this.print(writer);
        return s.toString();
    }

    public void print(PrintWriter writer) {
        if (this.annotation != null) {
            int i = 0;
            while (i < this.annotation.getNumberOfResults()) {
                Result r = this.annotation.getResultAt(i);
                DataType d = r.getDatatype();
                if (d != DataType.PNG && d != DataType.HTML && d != DataType.LIST && d != DataType.STORABLE) {
                    if (r.getName().equals("kind of assessment")) {
                        writer.println("#");
                    }
                    writer.print("# ");
                    writer.print(r.getName());
                    writer.print(": ");
                    writer.println(r.getValue().toString());
                }
                ++i;
            }
        }
        if (this.list != null) {
            ResultSet[] res = this.getValue();
            int i = 0;
            while (i < res.length) {
                int j;
                boolean newNames = i == 0;
                int k = res[i].getNumberOfResults() - 1;
                if (!newNames) {
                    if (k + 1 != res[i - 1].getNumberOfResults()) {
                        newNames = true;
                    } else {
                        j = 0;
                        while (j <= k) {
                            if (!res[i].getResultAt(j).getName().equals(res[i - 1].getResultAt(j).getName())) {
                                newNames = true;
                                break;
                            }
                            ++j;
                        }
                    }
                }
                if (newNames) {
                    writer.print("# ");
                    j = 0;
                    while (j <= k) {
                        writer.print(res[i].getResultAt(j).getName());
                        if (j < k) {
                            writer.print("\t");
                        } else {
                            writer.println();
                        }
                        ++j;
                    }
                }
                j = 0;
                while (j <= k) {
                    writer.print(res[i].getResultAt(j).getValue());
                    if (j < k) {
                        writer.print("\t");
                    } else {
                        writer.println();
                    }
                    ++j;
                }
                ++i;
            }
            writer.flush();
        }
    }

    public ListResult sort(String columnName) throws IllegalArgumentException {
        Object[] c = new ComparableElement[this.list.length];
        Comparable comp = null;
        int i = 0;
        while (i < this.list.length) {
            int k = this.list[i].findColumn(columnName);
            if (k < 0) {
                ResultSet r;
                if (this.list[i] instanceof MeanResultSet && (k = (r = ((MeanResultSet)this.list[i]).getInfos()).findColumn(columnName)) >= 0) {
                    comp = (Comparable)r.getResultAt(k).getValue();
                }
                if (k < 0) {
                    throw new IllegalArgumentException("Could not find such a column.");
                }
            } else {
                comp = (Comparable)this.list[i].getResultAt(k).getValue();
            }
            c[i] = new ComparableElement<ResultSet, Comparable>(this.list[i], comp);
            ++i;
        }
        Arrays.sort(c);
        ResultSet[] results = new ResultSet[this.list.length];
        i = 0;
        while (i < this.list.length) {
            results[i] = (ResultSet)((ComparableElement)c[i]).getElement();
            ++i;
        }
        return new ListResult(this.name, this.comment, this.annotation, results);
    }

    public boolean getExport() {
        return this.export;
    }

    public void setExport(boolean export) {
        this.export = export;
    }
}

