/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels;

import de.jstacs.Storable;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class BNDiffSMParameter
implements Storable,
Cloneable {
    private double value;
    protected byte symbol;
    protected int position;
    protected int[][] context;
    protected double count;
    protected double pseudoCount;
    private boolean free;
    private int index;
    private double expValue;
    private Double z;
    private Double t;

    public BNDiffSMParameter clone() throws CloneNotSupportedException {
        BNDiffSMParameter clone = (BNDiffSMParameter)super.clone();
        int i = 0;
        while (i < this.context.length) {
            clone.context[i] = (int[])this.context[i].clone();
            ++i;
        }
        return clone;
    }

    public BNDiffSMParameter(int index, byte symbol, int position, double pseudoCount, boolean free) {
        this(index, symbol, position, new int[0][2], pseudoCount, free);
    }

    public BNDiffSMParameter(int index, byte symbol, int position, int[][] context, double pseudoCount, boolean free) {
        this.index = index;
        this.symbol = symbol;
        this.position = position;
        this.context = context;
        this.pseudoCount = pseudoCount;
        this.count = pseudoCount;
        this.value = 0.0;
        this.expValue = 1.0;
        this.free = free;
        this.z = null;
        this.t = null;
    }

    public BNDiffSMParameter(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "parameter");
        this.value = XMLParser.extractObjectForTags(representation, "value", Double.TYPE);
        this.expValue = Math.exp(this.value);
        this.index = XMLParser.extractObjectForTags(representation, "index", Integer.TYPE);
        this.pseudoCount = XMLParser.extractObjectForTags(representation, "pseudoCount", Double.TYPE);
        this.symbol = XMLParser.extractObjectForTags(representation, "symbol", Byte.TYPE);
        this.position = XMLParser.extractObjectForTags(representation, "position", Integer.TYPE);
        this.context = XMLParser.extractObjectForTags(representation, "context", int[][].class);
        this.count = XMLParser.extractObjectForTags(representation, "count", Double.TYPE);
        this.free = XMLParser.extractObjectForTags(representation, "free", Boolean.TYPE);
        this.z = XMLParser.extractObjectForTags(representation, "z", Double.class);
        this.t = XMLParser.extractObjectForTags(representation, "t", Double.class);
    }

    public double getPseudoCount() {
        return this.pseudoCount;
    }

    public void reset() {
        this.count = this.pseudoCount;
        this.value = 0.0;
        this.expValue = 1.0;
    }

    public int getDepth() {
        return this.context.length;
    }

    public void print() {
        System.out.println(String.valueOf(this.symbol) + " c: " + this.count);
        System.out.println(String.valueOf(this.symbol) + ": " + this.value);
    }

    public double doesApplyFor(Sequence seq) {
        if (seq.discreteVal(this.position) == this.symbol) {
            int i = 0;
            while (i < this.context.length) {
                boolean app = false;
                int j = 1;
                while (j < this.context[i].length) {
                    if (seq.discreteVal(this.context[i][0]) == this.context[i][j]) {
                        app = true;
                    }
                    ++j;
                }
                if (!app) {
                    return 0.0;
                }
                ++i;
            }
            return 1.0;
        }
        return 0.0;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.expValue = Math.exp(value);
    }

    public double getExpValue() {
        return this.expValue;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.value, "value");
        XMLParser.appendObjectWithTags(buf, this.symbol, "symbol");
        XMLParser.appendObjectWithTags(buf, this.index, "index");
        XMLParser.appendObjectWithTags(buf, this.pseudoCount, "pseudoCount");
        XMLParser.appendObjectWithTags(buf, this.position, "position");
        XMLParser.appendObjectWithTags(buf, this.context, "context");
        XMLParser.appendObjectWithTags(buf, this.count, "count");
        XMLParser.appendObjectWithTags(buf, this.free, "free");
        XMLParser.appendObjectWithTags(buf, this.z, "z");
        XMLParser.appendObjectWithTags(buf, this.t, "t");
        XMLParser.addTags(buf, "parameter");
        return buf;
    }

    public void invalidateNormalizers() {
        this.z = null;
        this.t = null;
    }

    public double getLogPartialNormalizer() throws Exception {
        if (this.z == null || this.t == null) {
            throw new Exception("No valid normalizers available for parameter " + this.index + " at position " + this.position + ": z=" + this.z + ", t=" + this.t + ".");
        }
        return this.t + this.value + this.z;
    }

    public double getCounts() {
        return this.count;
    }

    public void addCount(double count2) {
        this.count += count2;
    }

    public boolean isFree() {
        return this.free;
    }

    public int getPosition() {
        return this.position;
    }

    public int getIndex() {
        return this.index;
    }

    void setLogT(Double t) {
        this.t = t;
    }

    void setLogZ(Double z) {
        this.z = z;
    }

    public double getLogZ() {
        return this.z;
    }

    public double getLogT() {
        return this.t;
    }
}

