/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;
import org.biojava.utils.Unchangeable;

public interface Triple
extends Term {
    public Term getSubject();

    public Term getObject();

    public Term getPredicate();

    public int hashCode();

    public boolean equals(Object var1);

    public static final class Impl
    extends Unchangeable
    implements Triple,
    Serializable {
        private static final long serialVersionUID = 3807331980372839221L;
        private final Term subject;
        private final Term object;
        private final Term predicate;
        private String name;
        private String description;
        private Set<Object> synonyms;

        public Impl(Term subject, Term object, Term predicate) {
            this(subject, object, predicate, null, null, null);
        }

        public Impl(Term subject, Term object, Term predicate, Object[] synonyms) {
            this(subject, object, predicate, null, null, synonyms);
        }

        public Impl(Term subject, Term object, Term predicate, String name, String description) {
            this(subject, object, predicate, name, description, null);
        }

        public Impl(Term subject, Term object, Term predicate, String name, String description, Object[] synonyms) {
            if (subject == null) {
                throw new NullPointerException("Subject must not be null");
            }
            if (object == null) {
                throw new NullPointerException("Object must not be null");
            }
            if (predicate == null) {
                throw new NullPointerException("predicate must not be null");
            }
            if (subject.getOntology() != object.getOntology() || subject.getOntology() != predicate.getOntology()) {
                throw new IllegalArgumentException("All terms must be from the same ontology: " + subject.getOntology().getName() + ", " + object.getOntology().getName() + ", " + predicate.getOntology().getName());
            }
            if (description == null) {
                description = "";
            }
            this.subject = subject;
            this.object = object;
            this.predicate = predicate;
            this.name = name;
            this.description = description;
            this.synonyms = new TreeSet<Object>();
            if (synonyms != null) {
                this.synonyms.addAll(Arrays.asList(synonyms));
            }
        }

        public void addSynonym(Object synonym) {
            this.synonyms.add(synonym);
        }

        public void removeSynonym(Object synonym) {
            this.synonyms.remove(synonym);
        }

        public Object[] getSynonyms() {
            return this.synonyms.toArray();
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.predicate + "(" + this.subject + ", " + this.object + ")";
            }
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String desc) {
            this.description = desc;
        }

        public Ontology getOntology() {
            return this.subject.getOntology();
        }

        public Term getSubject() {
            return this.subject;
        }

        public Term getObject() {
            return this.object;
        }

        public Term getPredicate() {
            return this.predicate;
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Triple)) {
                return false;
            }
            Triple to = (Triple)o;
            return to.getSubject().equals(this.getSubject()) && to.getObject().equals(this.getObject()) && to.getPredicate().equals(this.getPredicate());
        }

        public int hashCode() {
            return this.getSubject().hashCode() + 31 * this.getObject().hashCode() + 961 * this.getPredicate().hashCode();
        }

        public String toString() {
            if (this.getName().length() > 0) {
                return this.getName();
            }
            return this.subject + " " + this.predicate + " " + this.object;
        }
    }
}

