/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractNumericalTwoClassPerformanceMeasure;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;

public class CorrelationCoefficient
extends AbstractNumericalTwoClassPerformanceMeasure {
    private Method method;
    private boolean logit;

    public CorrelationCoefficient() {
        this(Method.SPEARMAN, false);
    }

    public CorrelationCoefficient(Method method, boolean logit) {
        this.method = method;
        this.logit = logit;
    }

    @Override
    public String getName() {
        return "Correlation (" + this.method.name() + ")";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] weightsClass0, double[] sortedScoresClass1, double[] weightsClass1) {
        double[] temp = new double[sortedScoresClass0.length + sortedScoresClass1.length];
        if (weightsClass0 == null || weightsClass1 == null) {
            Arrays.fill(temp, 0, sortedScoresClass0.length, 1.0);
            Arrays.fill(temp, sortedScoresClass0.length, temp.length, 0.0);
        } else {
            int i = 0;
            while (i < weightsClass0.length) {
                temp[i] = this.logit ? Math.log(weightsClass0[i] / (1.0 - weightsClass0[i])) : weightsClass0[i];
                ++i;
            }
            i = 0;
            while (i < weightsClass1.length) {
                temp[i + weightsClass0.length] = this.logit ? Math.log((1.0 - weightsClass1[i]) / weightsClass1[i]) : weightsClass1[i];
                ++i;
            }
        }
        double[] temp2 = new double[sortedScoresClass0.length + sortedScoresClass1.length];
        System.arraycopy(sortedScoresClass0, 0, temp2, 0, sortedScoresClass0.length);
        System.arraycopy(sortedScoresClass1, 0, temp2, sortedScoresClass0.length, sortedScoresClass1.length);
        double cor = 0.0;
        try {
            cor = this.method == Method.PEARSON ? ToolBox.pearsonCorrelation(temp, temp2) : ToolBox.spearmanCorrelation(sortedScoresClass0, weightsClass0);
            return new NumericalResultSet(new NumericalResult(this.getName(), "", cor));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Method {
        SPEARMAN,
        PEARSON;

    }
}

