/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.utils;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ImageResult;
import de.jstacs.utils.REnvironment;
import java.util.ArrayList;
import javax.naming.OperationNotSupportedException;

public class ClassificationVisualizer {
    private static final String FANCY_SCATTTER = "fancyScatter <- function( data, breaks=20, density=10 ) {\nm=matrix(c(2,1,4,3),ncol=2);\nlayout(m, widths = c(3,1), heights=c(1,3));\npar(mar=c(3,3,1,1));\nplot(data[,1],data[,2],col=data[,3],pch=16,xlab=\"\",ylab=\"\");\nl = length(table(data[,3]));\ndegree = 180/l;\ndef.par <- par(no.readonly = TRUE); # save default, for resetting...\nmar = par(\"mar\");\n\nfor( column in 1:2 ) {\nmyMar = mar;\nmyMar[column] = 0;\npar(mar=myMar);\nh = marginal(data,column=column,breaks=breaks);\nbounds = c(min(data[,column]),max(data[,column]));\n\nmax=0;\nfor( i in 1:l ) {\nmax=max(max,h[[i]]$intensities);\n}\nfor( i in 1:l ) {\nif( column == 1 ) {\nbarplot(h[[i]]$intensities, add=i>1, axes=FALSE, ylim=c(0, max), space=0, col=i, angle=-90+i*degree, density=density);\n} else {\nbarplot(h[[i]]$intensities, add=i>1, axes=FALSE, xlim=c(0, max), space=0, horiz=TRUE, col=i, angle=i*degree, density=density);\n}\n}\n}\npar( def.par );\n}\n\n\nmarginal <- function ( data, column=1, breaks=20 ) {\nbounds = c(min(data[,column]),max(data[,column]));\nt = table(data[,3]);\nl = length(t);\n\nh=list();\nfor( i in 1:l ) {\nh[[i]] = hist( data[which(data[,3]==names(t)[i]),column], breaks=seq(bounds[1],bounds[2],length=breaks+1), plot=F );\n}\nreturn( h );\n}\n";

    private ClassificationVisualizer() {
    }

    private static String getPlotScoresCmd(AbstractScoreBasedClassifier cl, DataSet class0, DataSet class1, REnvironment e, int bins, double density, String plotOptions) throws Exception {
        StringBuffer b = new StringBuffer(100000);
        if (cl.getNumberOfClasses() != 2) {
            throw new OperationNotSupportedException("This method is only possible for 2-class-classifiers.");
        }
        e.createVector("sample0", cl.getScores(class0));
        e.createVector("sample1", cl.getScores(class1));
        b.append("min0 = min( sample0 ); max0 = max( sample0 );\n");
        b.append("min1 = min( sample1 ); max1 = max( sample1 );\n");
        b.append("min = min( min0, min1 ); max = max( max0, max1 );\n");
        b.append("s=(max-min)/" + bins + "; binBreaks = seq(min,max,by=s);\n");
        b.append("h0 = hist( sample0, breaks=c(min0,s+binBreaks[binBreaks>=min0 & binBreaks<=max0]), plot=F );\n");
        b.append("h1 = hist( sample1, breaks=c(min1,s+binBreaks[binBreaks>=min1 & binBreaks<=max1]), plot=F );\n\n");
        plotOptions = plotOptions == null ? "" : plotOptions.trim();
        if (plotOptions.length() == 0) {
            plotOptions = ", xlim=c(min, max), ylim=c(0, max(h0$density,h1$density)), xlab=\"ratio of the scores\", ylab=\"density\", main=\"histogram for " + ClassificationVisualizer.getClassifierName(cl) + "\"";
        } else if (plotOptions.charAt(0) != ',') {
            plotOptions = ", " + plotOptions;
        }
        int c1 = 4;
        int c2 = 2;
        b.append("plot( h0, col=" + c1 + ", border=" + c1 + ", angle=45, density=" + density + ", freq=F " + plotOptions + ");\n");
        b.append("plot( h1, col=" + c2 + ", border=" + c2 + ", angle=-45, density=" + density + ", add=T, freq=F );\n");
        return b.toString();
    }

    public static ImageResult plotScores(AbstractScoreBasedClassifier cl, DataSet class0, DataSet class1, REnvironment e, int bins, double density, String plotOptions) throws Exception {
        return new ImageResult("plot of the scores", "this plot shows the scores that are used to assign the classes", e.plot(ClassificationVisualizer.getPlotScoresCmd(cl, class0, class1, e, bins, density, plotOptions), 720.0, 360.0));
    }

    public static void plotScores(AbstractScoreBasedClassifier cl, DataSet class0, DataSet class1, REnvironment e, int bins, double density, String plotOptions, String fName) throws Exception {
        e.plotToPDF(ClassificationVisualizer.getPlotScoresCmd(cl, class0, class1, e, bins, density, plotOptions), 10.0, 5.0, fName, true);
    }

    public static ImageResult getScatterplot(AbstractScoreBasedClassifier cl1, AbstractScoreBasedClassifier cl2, DataSet class0, DataSet class1, REnvironment e, boolean drawThreshold) throws Exception {
        if (cl1.getNumberOfClasses() != 2 || cl2.getNumberOfClasses() != 2) {
            throw new OperationNotSupportedException("This method is only possible for 2-class-classifiers.");
        }
        e.createVector("cl1_0", cl1.getScores(class0));
        e.createVector("cl2_0", cl2.getScores(class0));
        e.createVector("cl1_1", cl1.getScores(class1));
        e.createVector("cl2_1", cl2.getScores(class1));
        e.voidEval("xlim = c(min(cl1_0,cl1_1),max(cl1_0,cl1_1))");
        e.voidEval("ylim = c(min(cl2_0,cl2_1),max(cl2_0,cl2_1))");
        String pltcmd = "plot( cl1_1, cl2_1, col=2, xlim = xlim, ylim = ylim, xlab=\"" + ClassificationVisualizer.getClassifierName(cl1) + "\", ylab=\"" + ClassificationVisualizer.getClassifierName(cl2) + "\", main=\"" + ClassificationVisualizer.getTitle(class0, class1) + "\"); points( cl1_0, cl2_0, col=1, pch=2 );";
        if (drawThreshold) {
            pltcmd = String.valueOf(pltcmd) + "lines( c(0,0), ylim, lty=2, col=3 ); lines( xlim, c(0,0), lty=2, col=3 )";
        }
        return new ImageResult("scatterplot of the scores", "this plot shows the scores that are used to assign the classes scattered against each other", e.plot(pltcmd, 720.0, 720.0));
    }

    public static ImageResult getFancyScatterplot(AbstractScoreBasedClassifier cl1, AbstractScoreBasedClassifier cl2, REnvironment e, DataSet ... data) throws Exception {
        if (cl1.getNumberOfClasses() != 2 || cl2.getNumberOfClasses() != 2) {
            throw new OperationNotSupportedException("This method is only possible for binary classifiers.");
        }
        e.voidEval(FANCY_SCATTTER);
        ArrayList<double[]> dlist = new ArrayList<double[]>();
        int d = 0;
        while (d < data.length) {
            int n = 0;
            while (n < data[d].getNumberOfElements()) {
                double[] current = new double[3];
                Sequence seq = data[d].getElementAt(n);
                current[0] = cl1.getScore(seq, 0) - cl1.getScore(seq, 1);
                current[1] = cl2.getScore(seq, 0) - cl2.getScore(seq, 1);
                current[2] = d + 1;
                dlist.add(current);
                ++n;
            }
            ++d;
        }
        e.createMatrix("data", (double[][])dlist.toArray((T[])new double[0][0]));
        return new ImageResult("scatterplot of the scores", "this plot shows the scores that are used to assign the classes scattered against each other", e.plot("fancyScatter(data)", 720.0, 720.0));
    }

    private static String getClassifierName(AbstractClassifier cl) {
        CategoricalResult[] cat = cl.getClassifierAnnotation();
        String res = cat[0].getValue() + "(" + cat[1].getValue();
        int i = 2;
        while (i < cat.length) {
            res = String.valueOf(res) + "; " + cat[i].getValue();
            ++i;
        }
        return String.valueOf(res) + ")";
    }

    private static String getTitle(DataSet class0, DataSet class1) {
        String res = "scatterplot for ";
        res = class0 != null && class1 != null ? String.valueOf(res) + class0.getAnnotation() + " and " + class1.getAnnotation() : (class0 == null ? String.valueOf(res) + class1.getAnnotation() : String.valueOf(res) + class0.getAnnotation());
        return res;
    }
}

