/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.AnnotatedEntity;
import de.jstacs.AnnotatedEntityList;
import de.jstacs.Storable;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class ParameterSet
implements Storable,
Cloneable,
GalaxyConvertible {
    protected ParameterList parameters;
    protected String errorMessage;
    protected Parameter parent;

    public static String getName(Class<? extends ParameterSet> c) {
        return c.getSimpleName();
    }

    public static String getComment(Class<? extends ParameterSet> c) {
        return "";
    }

    public static String getName(ParameterSet p) {
        return ParameterSet.getName(p.getClass());
    }

    public static String getComment(ParameterSet p) {
        return ParameterSet.getComment(p.getClass());
    }

    public static int getIndex(String[] names, Object[] values, Comparable current, boolean hasAlternative) throws IllegalArgumentException {
        int i = 0;
        int l = values.length;
        if (hasAlternative) {
            --l;
        }
        while (i < l && !current.equals(values[i])) {
            ++i;
        }
        if (i == values.length) {
            throw new IllegalArgumentException("Could not find a matching constant.");
        }
        return i;
    }

    public ParameterSet() {
        this.initParameterList();
    }

    public ParameterSet clone() throws CloneNotSupportedException {
        ParameterSet ret = (ParameterSet)super.clone();
        if (this.parameters != null) {
            ret.initParameterList(this.parameters.size());
            int i = 0;
            while (i < this.parameters.size()) {
                ret.parameters.add(i, ((Parameter)this.parameters.get(i)).clone());
                ++i;
            }
        }
        return ret;
    }

    protected final void initParameterList() {
        this.parameters = new ParameterList();
    }

    protected final void initParameterList(int initCapacity) {
        this.parameters = new ParameterList(initCapacity);
    }

    public boolean parametersLoaded() {
        return this.parameters != null;
    }

    public boolean isAtomic() {
        int i = 0;
        while (i < this.parameters.size()) {
            if (!((Parameter)this.parameters.get(i)).isAtomic()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasDefaultOrIsSet() {
        int i = 0;
        while (i < this.parameters.size()) {
            if (((Parameter)this.parameters.get(i)).isRequired() && !((Parameter)this.parameters.get(i)).hasDefaultOrIsSet()) {
                this.errorMessage = "At least parameter " + ((Parameter)this.parameters.get(i)).getName() + " has not been set to a valid value.";
                return false;
            }
            ++i;
        }
        this.errorMessage = null;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected ParameterSet(Parameter ... parameters) {
        this.initParameterList(parameters.length);
        int i = 0;
        while (i < parameters.length) {
            this.parameters.add(parameters[i]);
            ++i;
        }
    }

    protected ParameterSet(ArrayList<Parameter> parameters) {
        this.initParameterList(parameters.size());
        Iterator<Parameter> parIt = parameters.iterator();
        while (parIt.hasNext()) {
            this.parameters.add(parIt.next());
        }
    }

    public ParameterSet(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public int getNumberOfParameters() {
        if (this.parameters != null) {
            return this.parameters.size();
        }
        return 0;
    }

    public String[] getAllParameterNames() {
        return this.parameters.getNames();
    }

    public Parameter getParameterForName(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public Parameter getParameterAt(int i) {
        return (Parameter)this.parameters.get(i);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        if (this.parameters != null) {
            StringBuffer buf2 = new StringBuffer();
            XMLParser.appendObjectWithTags(buf2, this.parameters.size(), "numberOfParameters");
            int i = 0;
            while (i < this.parameters.size()) {
                XMLParser.appendObjectWithTags(buf2, this.parameters.get(i), "parameter");
                ++i;
            }
            XMLParser.addTags(buf2, "set");
            buf.append(buf2);
        } else {
            XMLParser.appendObjectWithTags(buf, null, "set");
        }
        XMLParser.addTags(buf, "parameterSet");
        return buf;
    }

    public void reset() {
        this.parameters = null;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer buf = XMLParser.extractForTag(representation = XMLParser.extractForTag(representation, "parameterSet"), "set");
        if (buf != null && !buf.toString().equalsIgnoreCase("null")) {
            int numPars = XMLParser.extractObjectForTags(buf, "numberOfParameters", Integer.TYPE);
            this.parameters = new ParameterList(numPars);
            int i = 0;
            while (i < numPars) {
                this.parameters.add((Parameter)XMLParser.extractObjectForTags(buf, "parameter"));
                ++i;
            }
        }
    }

    public Parameter getParent() {
        return this.parent;
    }

    public void setParent(Parameter parent) {
        this.parent = parent;
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine) throws Exception {
        int i = 0;
        while (i < this.getNumberOfParameters()) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).toGalaxy(String.valueOf(namePrefix) + "_ps", configPrefix, depth + 1, descBuffer, configBuffer, false);
            descBuffer.append("\n");
            configBuffer.append("\n");
            ++i;
        }
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        int i = 0;
        while (i < this.getNumberOfParameters()) {
            ((GalaxyConvertible)((Object)this.getParameterAt(i))).fromGalaxy(String.valueOf(namePrefix) + "_ps", command);
            ++i;
        }
    }

    public boolean isComparable(ParameterSet p) {
        boolean res = this.getClass().equals(p.getClass());
        if (res) {
            int n = this.getNumberOfParameters();
            int i = 0;
            res = n == p.getNumberOfParameters();
            while (res && i < n && this.getParameterAt(i).isComparable(p.getParameterAt(i))) {
                ++i;
            }
            return res && i == n;
        }
        return res;
    }

    protected class ParameterList
    extends AnnotatedEntityList<Parameter> {
        public ParameterList() {
        }

        public ParameterList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public void set(int idx, Parameter p) {
            p.setParent(ParameterSet.this);
            super.set(idx, p);
        }

        @Override
        public void add(int idx, Parameter p) {
            p.setParent(ParameterSet.this);
            super.add(idx, p);
        }

        public void add(Parameter ... p) {
            int i = 0;
            while (i < p.length) {
                p[i].setParent(ParameterSet.this);
                ++i;
            }
            super.add((AnnotatedEntity[])p);
        }
    }
}

