/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.differentiable.logistic;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.differentiable.logistic.LogisticConstraint;
import java.util.Arrays;

public class ProductConstraint
implements LogisticConstraint {
    private int[] pos;
    private static final String XML_TAG = ProductConstraint.class.getSimpleName();

    public ProductConstraint(int ... pos) {
        this.pos = (int[])pos.clone();
    }

    public ProductConstraint(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.pos = XMLParser.extractObjectForTags(xml, "pos", int[].class);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.pos, "pos");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    public ProductConstraint clone() throws CloneNotSupportedException {
        ProductConstraint clone = (ProductConstraint)super.clone();
        clone.pos = (int[])this.pos.clone();
        return clone;
    }

    @Override
    public double getValue(Sequence seq, int start) {
        double res = 1.0;
        int i = 0;
        while (i < this.pos.length) {
            res *= seq.continuousVal(start + this.pos[i]);
            ++i;
        }
        return res;
    }

    public String toString() {
        return Arrays.toString(this.pos);
    }

    public int[] getPositions() {
        return (int[])this.pos.clone();
    }
}

