/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.distances;

import de.jstacs.clustering.distances.DeBruijnMotifComparison;
import de.jstacs.clustering.distances.SequenceScoreDistance;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.CyclicSequenceAdaptor;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.sequenceScores.statisticalModels.StatisticalModel;
import java.util.Random;

public class RandomSequenceScoreDistance
extends SequenceScoreDistance {
    private static Random r = new Random(117L);

    public RandomSequenceScoreDistance(DiscreteAlphabet alphabet, int n, boolean exp) throws WrongAlphabetException, WrongSequenceTypeException {
        super(RandomSequenceScoreDistance.createSequences(alphabet, n), exp);
    }

    @Override
    public double[][] getProfile(StatisticalModel o, boolean rc) throws Exception {
        return DeBruijnMotifComparison.getProfilesForMotif(this.seqs, o, rc, this.exp);
    }

    public static CyclicSequenceAdaptor[] createSequences(DiscreteAlphabet alphabet, int n) throws WrongAlphabetException, WrongSequenceTypeException {
        int l = (int)Math.pow(alphabet.length(), n);
        int al = (int)alphabet.length();
        byte[] seq = new byte[l];
        int i = 0;
        while (i < l) {
            seq[i] = (byte)r.nextInt(al);
            ++i;
        }
        AlphabetContainer ac = null;
        ac = alphabet instanceof DNAAlphabet ? DNAAlphabetContainer.SINGLETON : new AlphabetContainer((Alphabet)alphabet);
        return new CyclicSequenceAdaptor[]{new CyclicSequenceAdaptor<int[]>(new ByteSequence(ac, seq))};
    }
}

