/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.MultiSelectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import java.util.HashSet;

public abstract class AbstractSelectionParameter
extends Parameter
implements Rangeable,
GalaxyConvertible {
    protected ParameterSet parameters;
    protected boolean userSelected;
    private boolean required;
    protected String errorMessage;
    private boolean rangeable;

    private AbstractSelectionParameter(DataType datatype, String name, String comment, boolean required) {
        super(name, comment, datatype);
        this.required = required;
        this.userSelected = false;
        this.rangeable = true;
    }

    public AbstractSelectionParameter(DataType datatype, String[] keys, Object[] values, String name, String comment, boolean required) throws InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        this(datatype, keys, values, null, name, comment, required);
    }

    public AbstractSelectionParameter(DataType datatype, String[] keys, Object[] values, String[] comments, String name, String comment, boolean required) throws InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        this(datatype, name, comment, required);
        if (!(values instanceof Parameter[]) && (keys == null || keys.length != values.length || comments != null && keys.length != comments.length)) {
            throw new InconsistentCollectionException("You have to define the same number of keys and values for a AbstractSelectionParameter!");
        }
        this.createParameterSet(values, keys, comments);
    }

    public AbstractSelectionParameter(String name, String comment, boolean required, ParameterSet ... values) {
        this(DataType.PARAMETERSET, name, comment, required);
        try {
            this.createParameterSet(values, null, null);
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    public AbstractSelectionParameter(String name, String comment, boolean required, Class<? extends ParameterSet> ... values) {
        this(DataType.PARAMETERSET, name, comment, required);
        try {
            this.createParameterSet(values, null, null);
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    public AbstractSelectionParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    protected void createParameterSet(Object[] values, String[] keys, String[] comments) throws SimpleParameter.DatatypeNotValidException, SimpleParameter.IllegalValueException, InconsistentCollectionException {
        Parameter[] pars = new Parameter[values.length];
        HashSet<String> hash = new HashSet<String>();
        int i = 0;
        while (i < pars.length) {
            if (values[i] instanceof Parameter) {
                pars[i] = (Parameter)values[i];
            } else if (values[i] instanceof ParameterSet) {
                pars[i] = keys == null || keys[i] == null ? new ParameterSetContainer((ParameterSet)values[i]) : new ParameterSetContainer(keys[i], comments == null ? null : comments[i], (ParameterSet)values[i]);
            } else if (values[i] instanceof Class && ParameterSet.class.isAssignableFrom((Class)values[i])) {
                pars[i] = keys == null || keys[i] == null ? new ParameterSetContainer((Class)values[i]) : new ParameterSetContainer(keys[i], comments == null ? null : comments[i], (Class)values[i]);
            } else {
                if (keys == null || keys[i] == null) {
                    throw new IllegalArgumentException("You have to state the key for entity " + i);
                }
                pars[i] = new SimpleParameter(this.datatype, keys[i], comments == null ? null : comments[i], false);
                pars[i].setValue(values[i]);
            }
            if (hash.contains(pars[i].getName())) {
                throw new InconsistentCollectionException("The key \"" + pars[i].getName() + "\" is used multiple times.");
            }
            hash.add(pars[i].getName());
            ++i;
        }
        this.parameters = new SimpleParameterSet(pars);
        this.parameters.setParent(this);
        try {
            this.setDefault(pars[0].getName());
        }
        catch (Exception doesNotHappen) {
            System.out.println(pars[0]);
            throw new RuntimeException(doesNotHappen);
        }
    }

    @Override
    public AbstractSelectionParameter clone() throws CloneNotSupportedException {
        AbstractSelectionParameter clone = (AbstractSelectionParameter)super.clone();
        clone.parameters = this.parameters == null ? null : this.parameters.clone();
        return clone;
    }

    @Override
    public boolean isAtomic() {
        int i = 0;
        while (i < this.parameters.getNumberOfParameters()) {
            if (this.parameters.getParameterAt(i).getValue() instanceof ParameterSet) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract boolean hasDefault();

    @Override
    public boolean isSet() {
        return this.isUserSelected();
    }

    public ParameterSet getParametersInCollection() {
        return this.parameters;
    }

    public void setRangeable(boolean rangeable) {
        this.rangeable = rangeable;
    }

    @Override
    public boolean isComparable(Parameter p) {
        boolean res;
        boolean bl = res = this.getClass().equals(p.getClass()) && this.getDatatype() == p.getDatatype() && this.getName().equals(p.getName()) && this.getComment().equals(p.getComment());
        if (res) {
            AbstractSelectionParameter sp2 = (AbstractSelectionParameter)p;
            if (res &= this.parameters.getNumberOfParameters() == sp2.parameters.getNumberOfParameters()) {
                int i = 0;
                while (i < this.parameters.getNumberOfParameters()) {
                    res &= this.parameters.getParameterAt(i).isComparable(sp2.parameters.getParameterAt(i));
                    ++i;
                }
            }
        }
        return res;
    }

    @Override
    public boolean isRangeable() {
        return this.rangeable;
    }

    protected int check(Object value) {
        if (value == null) {
            return -1;
        }
        Object val2 = value;
        if (value instanceof ParameterSet) {
            val2 = ParameterSet.getName((ParameterSet)value);
        } else if (value instanceof Class && ParameterSet.class.isAssignableFrom((Class)value)) {
            val2 = ParameterSet.getName((Class)value);
        } else if (value instanceof Parameter) {
            val2 = ((Parameter)value).getName();
        }
        if (val2 instanceof String) {
            int i = 0;
            while (i < this.parameters.getNumberOfParameters()) {
                if (this.parameters.getParameterAt(i).getName().equals(val2)) {
                    this.errorMessage = null;
                    return i;
                }
                ++i;
            }
        }
        this.errorMessage = "The value is not in the set of defined values: " + value + ".";
        return -1;
    }

    @Override
    public boolean checkValue(Object value) {
        return this.check(value) >= 0;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.required, "required");
        XMLParser.appendObjectWithTags(buf, this.userSelected, "userSelected");
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.rangeable, "rangeable");
        XMLParser.appendObjectWithTags(buf, this.parameters, "collection");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        super.extractFurtherInfos(representation);
        this.required = XMLParser.extractObjectForTags(representation, "required", Boolean.TYPE);
        this.userSelected = XMLParser.extractObjectForTags(representation, "userSelected", Boolean.TYPE);
        this.errorMessage = XMLParser.parseString(XMLParser.extractObjectForTags(representation, "errorMessage", String.class));
        StringBuffer help = XMLParser.extractForTag(representation, "rangeable");
        this.rangeable = help == null ? false : Boolean.parseBoolean(help.toString());
        this.parameters = new SimpleParameterSet(XMLParser.extractForTag(representation, "collection"));
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public abstract boolean isSelected(int var1);

    public boolean isUserSelected() {
        return this.userSelected;
    }

    @Override
    public abstract void setDefault(Object var1) throws Exception;

    public boolean equals(Object o2) {
        if (o2 instanceof AbstractSelectionParameter) {
            ParameterSet parSet2 = ((AbstractSelectionParameter)o2).getParametersInCollection();
            if (parSet2.getNumberOfParameters() != this.parameters.getNumberOfParameters()) {
                return false;
            }
            if (!((AbstractSelectionParameter)o2).getName().equals(this.name) || !((AbstractSelectionParameter)o2).getComment().equals(this.comment)) {
                return false;
            }
            int i = 0;
            while (i < this.parameters.getNumberOfParameters()) {
                if (!this.parameters.getParameterAt(i).equals(parSet2.getParameterAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public MultiSelectionParameter getRangedInstance() throws Exception {
        Object[] p = new Parameter[this.parameters.getNumberOfParameters()];
        int i = 0;
        while (i < p.length) {
            p[i] = this.parameters.getParameterAt(i);
            ++i;
        }
        MultiSelectionParameter par = new MultiSelectionParameter(this.datatype, null, p, null, this.getName(), this.getComment(), this.required);
        return par;
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine) throws Exception {
        StringBuffer buf = new StringBuffer();
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        int i = 0;
        while (i < this.parameters.getNumberOfParameters()) {
            if (this.isSelected(i)) {
                XMLParser.appendObjectWithTagsAndAttributes(buf, this.parameters.getParameterAt(i).getName(), "option", "value=\"" + this.parameters.getParameterAt(i).getName() + "\" selected=\"true\"", false);
            } else {
                XMLParser.appendObjectWithTagsAndAttributes(buf, this.parameters.getParameterAt(i).getName(), "option", "value=\"" + this.parameters.getParameterAt(i).getName() + "\"", false);
            }
            ++i;
        }
        String line = "";
        if (addLine) {
            line = "&lt;hr /&gt;";
        }
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"select\" format=\"text\" name=\"" + namePrefix + "\" label=\"" + line + this.getName() + "\" optional=\"" + !this.isRequired() + "\" help=\"" + this.getComment() + "\"");
        StringBuffer buf3 = new StringBuffer("${" + configPrefix + (this.isAtomic() ? "" : String.valueOf(namePrefix) + "_cond.") + namePrefix + "}");
        XMLParser.addTags(buf3, namePrefix);
        configBuffer.append(buf3);
        if (!this.isAtomic()) {
            int i2 = 0;
            while (i2 < this.parameters.getNumberOfParameters()) {
                StringBuffer temp = new StringBuffer();
                StringBuffer temp2 = new StringBuffer();
                ((GalaxyConvertible)((Object)this.parameters.getParameterAt(i2))).toGalaxy(String.valueOf(namePrefix) + "_opt" + i2, String.valueOf(configPrefix) + namePrefix + "_cond.", depth + 1, temp, temp2, false);
                XMLParser.addTagsAndAttributes(temp, "when", "value=\"" + this.parameters.getParameterAt(i2).getName() + "\"");
                buf.append(temp);
                configBuffer.append(String.valueOf(i2 == 0 ? "#if " : "#elif ") + "$" + configPrefix + namePrefix + "_cond." + namePrefix + " == \"" + this.parameters.getParameterAt(i2).getName() + "\"\n");
                configBuffer.append(temp2);
                configBuffer.append("\n");
                ++i2;
            }
            configBuffer.append("#end if\n");
        }
        if (!this.isAtomic()) {
            XMLParser.addTagsAndAttributes(buf, "conditional", "name=\"" + namePrefix + "_cond\"");
        }
        descBuffer.append(buf);
    }

    public class InconsistentCollectionException
    extends ParameterException {
        private static final long serialVersionUID = -2703514434545861722L;

        public InconsistentCollectionException(String message) {
            super(message);
        }
    }
}

