/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.data.DataSet;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sampling.GibbsSamplingModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.FSDAGModelForGibbsSamplingParameterSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeMap;

public class FSDAGModelForGibbsSampling
extends FSDAGTrainSM
implements GibbsSamplingModel {
    protected File[] paramsFile;
    protected int[] counter;
    protected int samplingIndex;
    protected BufferedWriter writer;
    protected BufferedReader reader;

    public FSDAGModelForGibbsSampling(FSDAGModelForGibbsSamplingParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
        this.paramsFile = null;
        this.counter = null;
        this.reader = null;
        this.writer = null;
    }

    public FSDAGModelForGibbsSampling(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public FSDAGModelForGibbsSampling clone() throws CloneNotSupportedException {
        FSDAGModelForGibbsSampling clone = (FSDAGModelForGibbsSampling)super.clone();
        if (this.writer != null) {
            throw new CloneNotSupportedException("sampling was not stopped before");
        }
        clone.writer = null;
        clone.reader = null;
        if (this.paramsFile != null) {
            try {
                clone.paramsFile = new File[this.paramsFile.length];
                clone.counter = new int[this.paramsFile.length];
                int i = 0;
                while (i < this.paramsFile.length) {
                    if (this.paramsFile[i] != null) {
                        clone.paramsFile[i] = File.createTempFile("fsdag-", ".dat", null);
                        FileManager.copy(this.paramsFile[i].getAbsolutePath(), clone.paramsFile[i].getAbsolutePath());
                        clone.counter[i] = this.counter[i];
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                CloneNotSupportedException c = new CloneNotSupportedException(e.getMessage());
                c.setStackTrace(e.getStackTrace());
                throw c;
            }
        }
        return clone;
    }

    @Override
    public boolean parseNextParameterSet() {
        String str;
        block9: {
            if (this.writer != null) {
                return false;
            }
            str = null;
            try {
                try {
                    str = this.reader.readLine();
                }
                catch (IOException iOException) {
                    if (str == null) {
                        return false;
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (str == null) {
                    return false;
                }
                throw throwable;
            }
            if (str == null) {
                return false;
            }
        }
        this.parse(str);
        return true;
    }

    private void parse(String str) {
        String[] strArray = str.split("\t");
        int k = 1;
        int l = 0;
        while (l < this.length) {
            this.constraints[l].setFreqs(strArray, k);
            k += this.constraints[l].getNumberOfSpecificConstraints();
            ++l;
        }
    }

    @Override
    public boolean parseParameterSet(int sampling, int n) throws NumberFormatException, IOException {
        String str;
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new BufferedReader(new FileReader(this.paramsFile[sampling]));
        while ((str = this.reader.readLine()) != null) {
            if (Integer.parseInt(str.substring(0, str.indexOf("\t"))) != n) continue;
            this.parse(str);
            return true;
        }
        return false;
    }

    @Override
    public void initForSampling(int starts) throws IOException {
        if (this.paramsFile != null && this.paramsFile.length == starts) {
            int i = 0;
            while (i < starts) {
                if (this.paramsFile[i] != null) {
                    FileOutputStream o = new FileOutputStream(this.paramsFile[i]);
                    o.close();
                }
                this.counter[i] = 0;
                ++i;
            }
        } else {
            this.deleteParameterFiles();
            this.paramsFile = new File[starts];
            this.counter = new int[starts];
        }
    }

    @Override
    public void extendSampling(int sampling, boolean extend) throws IOException {
        if (this.paramsFile[sampling] == null) {
            this.paramsFile[sampling] = File.createTempFile("fsdag-", ".dat", null);
        } else if (extend) {
            this.parseParameterSet(sampling, this.counter[sampling] - 1);
            this.reader.close();
            this.reader = null;
        } else {
            this.counter[sampling] = 0;
        }
        this.writer = new BufferedWriter(new FileWriter(this.paramsFile[sampling], extend));
        this.samplingIndex = sampling;
    }

    @Override
    public void drawParameters(DataSet data, double[] weights) throws Exception {
        super.drawParameters(data, weights);
    }

    @Override
    public void samplingStopped() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    protected StringBuffer getFurtherModelInfos() {
        if (this.writer != null) {
            throw new RuntimeException("could not parse the model to XML while sampling");
        }
        StringBuffer xml = super.getFurtherModelInfos();
        if (xml == null) {
            xml = new StringBuffer(1000);
        }
        XMLParser.appendObjectWithTags(xml, this.paramsFile != null, "hasParameters");
        if (this.paramsFile != null) {
            try {
                XMLParser.appendObjectWithTags(xml, this.counter, "counter");
                int i = 0;
                while (i < this.paramsFile.length) {
                    String content = this.paramsFile[i] != null ? FileManager.readFile(this.paramsFile[i]).toString() : "";
                    XMLParser.appendObjectWithTagsAndAttributes(xml, content, "fileContent", "pos=\"" + i + "\"");
                    ++i;
                }
            }
            catch (IOException e) {
                RuntimeException r = new RuntimeException(e.getMessage());
                r.setStackTrace(e.getStackTrace());
                throw r;
            }
        }
        return xml;
    }

    @Override
    protected void setFurtherModelInfos(StringBuffer xml) throws NonParsableException {
        super.setFurtherModelInfos(xml);
        if (XMLParser.extractObjectForTags(xml, "hasParameters", Boolean.TYPE).booleanValue()) {
            this.counter = XMLParser.extractObjectForTags(xml, "counter", int[].class);
            this.paramsFile = new File[this.counter.length];
            try {
                TreeMap<String, String> filter = new TreeMap<String, String>();
                int i = 0;
                while (i < this.paramsFile.length) {
                    filter.clear();
                    filter.put("pos", "" + i);
                    String content = XMLParser.extractObjectAndAttributesForTags(xml, "fileContent", null, filter, String.class);
                    if (!content.equalsIgnoreCase("")) {
                        this.paramsFile[i] = File.createTempFile("pi-", ".dat", null);
                        FileManager.writeFile(this.paramsFile[i], (CharSequence)new StringBuffer(content));
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                NonParsableException n = new NonParsableException(e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
        } else {
            this.counter = null;
            this.paramsFile = null;
        }
        this.writer = null;
        this.reader = null;
    }

    @Override
    public boolean isInSamplingMode() {
        return this.writer != null;
    }

    @Override
    public void drawParameters(DataSet data, double[] weights, int[][] graph) throws Exception {
        if (this.isInSamplingMode()) {
            throw new RuntimeException("could not change the structure while sampling");
        }
        super.drawParameters(data, weights, graph);
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        if (this.isInSamplingMode()) {
            throw new RuntimeException("could not train the model while sampling");
        }
        super.train(data, weights);
    }

    @Override
    public void train(DataSet data, double[] weights, int[][] graph) throws Exception {
        if (this.isInSamplingMode()) {
            throw new RuntimeException("could not train the model while sampling");
        }
        super.train(data, weights, graph);
    }

    protected void finalize() throws Throwable {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.deleteParameterFiles();
        super.finalize();
    }

    private void deleteParameterFiles() {
        if (this.paramsFile != null) {
            int i = 0;
            while (i < this.paramsFile.length) {
                if (this.paramsFile[i] != null) {
                    this.paramsFile[i].delete();
                }
                ++i;
            }
        }
    }

    @Override
    public void acceptParameters() throws IOException {
        int n = this.samplingIndex;
        int n2 = this.counter[n];
        this.counter[n] = n2 + 1;
        this.writer.write("" + n2);
        int l = 0;
        while (l < this.length) {
            int n3 = this.constraints[l].getNumberOfSpecificConstraints();
            int i = 0;
            while (i < n3) {
                this.writer.write("\t" + this.constraints[l].getFreq(i));
                ++i;
            }
            ++l;
        }
        this.writer.write("\n");
        this.writer.flush();
    }
}

