/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import java.io.IOException;
import java.io.OutputStream;

public class SafeOutputStream
extends OutputStream {
    public static final OutputStream DEFAULT_STREAM = System.out;
    private OutputStream ostream;

    public static SafeOutputStream getSafeOutputStream(OutputStream out) {
        if (out != null && out instanceof SafeOutputStream) {
            return (SafeOutputStream)out;
        }
        return new SafeOutputStream(out);
    }

    private SafeOutputStream(OutputStream ostream) {
        this.ostream = ostream;
    }

    @Override
    public void close() throws IOException {
        if (this.ostream != null) {
            this.ostream.flush();
            this.ostream.close();
        }
    }

    public boolean doesNothing() {
        return this.ostream == null;
    }

    @Override
    public void flush() throws IOException {
        if (this.ostream != null) {
            this.ostream.flush();
        }
    }

    public OutputStream getOutputStream() {
        return this.ostream;
    }

    public void writeln() throws IOException {
        this.writeln("");
    }

    public void writeln(Object s) throws IOException {
        this.write(s + "\n");
    }

    public void write(Object s) throws IOException {
        if (this.ostream != null) {
            this.ostream.write(s.toString().getBytes());
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.ostream != null) {
            this.ostream.write(b);
        }
    }

    protected void finalize() throws IOException {
        this.flush();
    }
}

