/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Cholesky {
    private static IllegalArgumentException notPositiveDefinte = new IllegalArgumentException("matrix is not positive definite");

    private Cholesky() {
    }

    public static void decompose(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray2[i];
            double[] dArray4 = dArray[i];
            for (int j = i; j < n; ++j) {
                double[] dArray5 = dArray2[j];
                double d = dArray4[j];
                for (int k = i - 1; k >= 0; --k) {
                    d -= dArray3[k] * dArray5[k];
                }
                if (i == j) {
                    if (d <= 0.0) {
                        throw notPositiveDefinte;
                    }
                    if (dArray2 != null) {
                        dArray2[j][i] = Math.sqrt(d);
                    }
                } else if (dArray2 != null) {
                    dArray2[j][i] = d / dArray2[i][i];
                }
                if (i >= j) continue;
                dArray2[i][j] = 0.0;
            }
        }
    }

    public static boolean decomposable(double[][] dArray, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(Math.abs(dArray[i][j] - dArray[j][i]) > d)) continue;
                return false;
            }
        }
        try {
            Cholesky.decompose(dArray, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public static boolean decomposable(double[][] dArray) {
        return Cholesky.decomposable(dArray, 1.0E-14);
    }
}

