/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.DataType;
import de.jstacs.classifiers.performanceMeasures.MaximumNumericalTwoClassMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public class MaximumFMeasure
extends MaximumNumericalTwoClassMeasure {
    public MaximumFMeasure() {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "beta", "the beta defining the F measure", true, new NumberValidator<Double>(0.0, Double.POSITIVE_INFINITY), 1.0)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public MaximumFMeasure(double beta) throws Exception {
        this();
        ((Parameter)this.parameters.get(0)).setValue(beta);
    }

    public MaximumFMeasure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected String getMeasureName() {
        return "F-Measure";
    }

    @Override
    protected String getSpecificName() {
        return String.valueOf(this.getMeasureName()) + " with beta=" + ((Parameter)this.parameters.get("beta")).getValue();
    }

    @Override
    protected double getMeasure(double tp, double fp, double fn, double tn) {
        double b = (Double)((Parameter)this.parameters.get("beta")).getValue();
        b *= b;
        double precision = tp / (tp + fp);
        double recall = tp / (tp + fn);
        return (1.0 + b) * precision * recall / (b * precision + recall);
    }
}

