/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results.savers;

import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.ToolResult;
import java.io.File;
import java.util.HashSet;

public class ResultSetResultSaver
implements ResultSaver<ResultSetResult> {
    public static void register() {
        ResultSaverLibrary.register(ResultSetResult.class, new ResultSetResultSaver());
        ResultSaverLibrary.register(ToolResult.class, new ResultSetResultSaver());
    }

    private ResultSetResultSaver() {
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public String[] getFileExtensions(ResultSetResult result) {
        return null;
    }

    @Override
    public boolean writeOutput(ResultSetResult result, File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            return false;
        }
        ResultSet set = result.getRawResult()[0];
        HashSet<String> names = new HashSet<String>();
        boolean wroteAll = true;
        int i = 0;
        while (i < set.getNumberOfResults()) {
            Result res = set.getResultAt(i);
            ResultSaver<?> saver = ResultSaverLibrary.getSaver(res.getClass());
            if (saver != null) {
                String filename;
                String temp = filename = res.getName().replaceAll("[\\s\\:\\/]", "_");
                if (saver.isAtomic()) {
                    temp = String.valueOf(temp) + "." + saver.getFileExtensions(res)[0];
                }
                int j = 1;
                while (names.contains(temp) || new File(String.valueOf(dir.getAbsolutePath()) + File.separator + temp).exists()) {
                    temp = String.valueOf(filename) + "_" + j;
                    if (saver.isAtomic()) {
                        temp = String.valueOf(temp) + "." + saver.getFileExtensions(res)[0];
                    }
                    ++j;
                }
                filename = temp;
                names.add(filename);
                wroteAll &= saver.writeOutput(res, new File(String.valueOf(dir.getAbsolutePath()) + File.separator + filename));
            }
            ++i;
        }
        return wroteAll;
    }

    @Override
    public boolean writeOutput(ResultSetResult result, StringBuffer buf) {
        throw new RuntimeException("Not possible");
    }
}

