/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools.ui.cli;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.Pair;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CLI {
    private String opt;
    private JstacsTool[] tools;
    private boolean[] configureThreads;
    private ParameterSet[] toolParameters;
    private HashMap<Parameter, String>[] keyMap;

    public CLI(JstacsTool ... tools) {
        this((boolean[])null, tools);
    }

    public CLI(boolean[] configureThreads, JstacsTool ... tools) {
        this("", configureThreads, tools);
    }

    public CLI(String opt, boolean[] configureThreads, JstacsTool ... tools) {
        this.configureThreads = configureThreads == null ? new boolean[tools.length] : configureThreads;
        this.tools = tools;
        this.toolParameters = new ParameterSet[tools.length];
        this.keyMap = new HashMap[tools.length];
        int i = 0;
        while (i < tools.length) {
            this.toolParameters[i] = tools[i].getToolParameters();
            this.keyMap[i] = new HashMap();
            this.addToKeyMap(this.keyMap[i], this.toolParameters[i]);
            ++i;
        }
        this.opt = opt.trim();
        if (this.opt.length() > 0) {
            this.opt = " " + this.opt;
        }
    }

    private void addToKeyMap(HashMap<Parameter, String> hashMap, ParameterSet parameterSet) {
        int i = 0;
        while (i < parameterSet.getNumberOfParameters()) {
            String key;
            Parameter par = parameterSet.getParameterAt(i);
            if (par.getDatatype() != DataType.PARAMETERSET) {
                key = this.getKey(hashMap, par);
                hashMap.put(par, key);
            } else if (par instanceof AbstractSelectionParameter) {
                key = this.getKey(hashMap, par);
                hashMap.put(par, key);
                ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                int j = 0;
                while (j < incoll.getNumberOfParameters()) {
                    ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                    this.addToKeyMap(hashMap, cont.getValue());
                    ++j;
                }
            } else {
                ParameterSet ps = (ParameterSet)par.getValue();
                this.addToKeyMap(hashMap, ps);
            }
            ++i;
        }
    }

    private String getKey(HashMap<Parameter, String> hashMap, Parameter par) {
        Collection<String> valueSet2 = hashMap.values();
        LinkedList<String> valueSet = new LinkedList<String>(valueSet2);
        valueSet.add("outdir");
        valueSet.add("info");
        valueSet.add("threads");
        String parName = par.getName();
        String key = String.valueOf(parName.charAt(0)).toLowerCase();
        if (!valueSet.contains(key)) {
            return key;
        }
        String[] temp = parName.split("\\s");
        key = "";
        int i = 0;
        while (i < temp.length) {
            key = String.valueOf(key) + temp[i].charAt(0);
            ++i;
        }
        if (!valueSet.contains(key = key.toLowerCase())) {
            return key;
        }
        key = parName.replaceAll("[\\s=]", "");
        int k = 1;
        String temp2 = key;
        while (valueSet.contains(temp2)) {
            temp2 = String.valueOf(key) + k;
            ++k;
        }
        return key;
    }

    private int getToolIndex(String shortName) {
        int i = 0;
        while (i < this.tools.length) {
            if (shortName.equals(this.tools[i].getShortName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void run(String[] args) throws Exception {
        SysProtocol protocol = new SysProtocol();
        String jar = "<name>.jar";
        try {
            File jarfile = new File(CLI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            jar = jarfile.getName();
        }
        catch (Exception jarfile) {
            // empty catch block
        }
        String outdir = ".";
        if (args.length == 0 && (this.tools.length > 1 || !this.tools[0].getToolParameters().hasDefaultOrIsSet()) || this.tools.length > 1 && this.getToolIndex(args[0]) < 0) {
            if (this.tools.length > 1) {
                System.err.println("Available tools:\n");
                int i = 0;
                while (i < this.tools.length) {
                    System.err.println("\t" + this.tools[i].getShortName() + " - " + this.tools[i].getToolName());
                    ++i;
                }
                System.err.println();
                System.err.println("Syntax: java -jar " + jar + this.opt + " <toolname> [<parameter=value> ...]\n");
                System.err.println("Further info about the tools is given with\n\tjava -jar " + jar + this.opt + " <toolname> info\n");
                System.err.println("Tool parameters are listed with\n\tjava -jar " + jar + this.opt + " <toolname>\n");
            } else {
                this.printToolParameters(0, protocol, outdir, 1);
            }
            return;
        }
        if (args.length > 1 && args[1].equals("info")) {
            int toolIndex = this.getToolIndex(args[0]);
            System.err.println("\n" + CLI.parse(this.tools[toolIndex].getHelpText()));
        } else {
            int toolIndex = this.tools.length == 1 ? 0 : this.getToolIndex(args[0]);
            Pair<String, Integer> pair = this.setToolParameters(this.configureThreads[toolIndex], this.tools.length == 1 ? 0 : 1, this.toolParameters[toolIndex], this.keyMap[toolIndex], args, protocol);
            outdir = pair.getFirstElement();
            int threads = pair.getSecondElement();
            if (!this.toolParameters[toolIndex].hasDefaultOrIsSet()) {
                System.err.println("At least one parameter has not been set (correctly):\n");
                this.printToolParameters(toolIndex, protocol, outdir, threads);
                return;
            }
            this.printToolParameters(toolIndex, protocol, outdir, threads);
            protocol.flush();
            ToolResult results = this.tools[toolIndex].run(this.toolParameters[toolIndex], protocol, new ProgressUpdater(), threads);
            ResultSaver<?> saver = ResultSaverLibrary.getSaver(results.getClass());
            saver.writeOutput(results, new File(outdir));
            String prefix = String.valueOf(outdir) + File.separator + "protocol_" + this.tools[toolIndex].getShortName();
            File protout = new File(String.valueOf(prefix) + ".txt");
            int k = 1;
            while (protout.exists()) {
                protout = new File(String.valueOf(prefix) + "_" + k + ".txt");
                ++k;
            }
            FileManager.writeFile(protout, (CharSequence)protocol.getLog());
        }
    }

    private Pair<String, Integer> setToolParameters(boolean configureThreads, int off, ParameterSet parameterSet, HashMap<Parameter, String> hashMap, String[] args, Protocol protocol) throws SimpleParameter.IllegalValueException {
        HashMap<String, LinkedList<String>> valueMap = new HashMap<String, LinkedList<String>>();
        String outdir = ".";
        int threads = 1;
        boolean newLine = false;
        int i = off;
        while (i < args.length) {
            int idx = args[i].indexOf("=");
            if (idx < 0) {
                throw new SimpleParameter.IllegalValueException("Parameter mis-specified in: " + args[i]);
            }
            String[] temp = new String[]{args[i].substring(0, idx), args[i].substring(idx + 1)};
            if ("outdir".equals(temp[0])) {
                outdir = temp[1];
            } else if (configureThreads && "threads".equals(temp[0])) {
                threads = Integer.parseInt(temp[1]);
            } else {
                LinkedList<String> v = valueMap.get(temp[0]);
                if (v == null) {
                    valueMap.put(temp[0], new LinkedList());
                }
                valueMap.get(temp[0]).add(temp[1]);
            }
            ++i;
        }
        if (newLine) {
            protocol.append("\n");
        }
        this.set(parameterSet, hashMap, valueMap, protocol, 0);
        if (valueMap.size() > 0) {
            throw new SimpleParameter.IllegalValueException("Unknown parameters: " + valueMap);
        }
        return new Pair<String, Integer>(outdir, threads);
    }

    private void set(ParameterSet parameters, HashMap<Parameter, String> hashMap, HashMap<String, LinkedList<String>> valueMap, Protocol protocol, int exp) throws SimpleParameter.IllegalValueException {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        ParameterSet template = null;
        if (isExp) {
            template = (ParameterSet)parameters.getParameterAt(0).getValue();
            if (++exp > 1) {
                throw new RuntimeException("Nested ExpandableParameterSets not implemented.");
            }
        }
        int n = (isExp ? template : parameters).getNumberOfParameters();
        int i = 0;
        while (i < n) {
            Parameter par = (isExp ? template : parameters).getParameterAt(i);
            if (par.getDatatype() != DataType.PARAMETERSET || par instanceof AbstractSelectionParameter) {
                String key = hashMap.get(par);
                LinkedList<String> value = valueMap.remove(key);
                if (value != null) {
                    if (isExp) {
                        int k = 0;
                        while (k < value.size()) {
                            if (k >= parameters.getNumberOfParameters()) {
                                try {
                                    ((ExpandableParameterSet)parameters).addParameterToSet();
                                }
                                catch (CloneNotSupportedException doesnothappen) {
                                    doesnothappen.printStackTrace();
                                }
                            }
                            Parameter par2 = ((ParameterSet)parameters.getParameterAt(k).getValue()).getParameterAt(i);
                            par2.setValue(value.get(k));
                            ++k;
                        }
                    } else {
                        if (value.size() > 1) {
                            protocol.appendWarning("Parameter " + key + " specified multiple times (" + value + "). Using only first value: " + value.getFirst() + ".\n");
                        }
                        par.setValue(value.getFirst());
                        if (par.getDatatype() == DataType.PARAMETERSET) {
                            this.set((ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
                        }
                    }
                } else if (par.getDatatype() == DataType.PARAMETERSET) {
                    this.set((ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
                }
            } else {
                this.set((ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
            }
            ++i;
        }
    }

    private void print(HashMap<Parameter, String> keyMap, ParameterSet parameters, String tabPrefix, Protocol protocol) {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        ExpandableParameterSet exp = null;
        if (isExp) {
            exp = (ExpandableParameterSet)parameters;
            parameters = (ParameterSet)parameters.getParameterAt(0).getValue();
            protocol.appendWarning(String.valueOf(tabPrefix) + "This parameter can be used multiple times:\n");
            ParameterSet template = (ParameterSet)exp.getParameterAt(0).getValue();
            int n = exp.getNumberOfParameters();
            int k = 0;
            while (k < n) {
                ParameterSet ps2 = (ParameterSet)exp.getParameterAt(k).getValue();
                int j = 0;
                while (j < template.getNumberOfParameters()) {
                    Parameter par2 = template.getParameterAt(j);
                    protocol.appendWarning(String.valueOf(tabPrefix) + "\t" + keyMap.get(par2) + (n > 1 ? " (" + (k + 1) + ")" : "") + " - " + ps2.getParameterAt(j).toString() + "\n");
                    ++j;
                }
                ++k;
            }
        } else {
            int i = 0;
            while (i < parameters.getNumberOfParameters()) {
                Parameter par = parameters.getParameterAt(i);
                if (par.getDatatype() != DataType.PARAMETERSET) {
                    protocol.appendWarning(String.valueOf(tabPrefix) + keyMap.get(par) + " - " + par.toString() + "\n");
                } else if (par instanceof AbstractSelectionParameter) {
                    protocol.appendWarning(String.valueOf(tabPrefix) + keyMap.get(par) + " - " + par.toString() + "\n");
                    ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                    char[] array = new char[keyMap.get(par).length() + 3];
                    Arrays.fill(array, ' ');
                    String off = String.valueOf(tabPrefix) + new String(array);
                    int j = 0;
                    while (j < incoll.getNumberOfParameters()) {
                        ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                        if (cont.getValue().getNumberOfParameters() > 0) {
                            protocol.appendWarning(String.valueOf(off) + "Parameters for selection \"" + cont.getName() + "\":\n");
                            this.print(keyMap, cont.getValue(), String.valueOf(off) + "\t", protocol);
                        } else {
                            protocol.appendWarning(String.valueOf(off) + "No parameters for selection \"" + cont.getName() + "\"\n");
                        }
                        ++j;
                    }
                } else {
                    ParameterSet ps = (ParameterSet)par.getValue();
                    this.print(keyMap, ps, String.valueOf(tabPrefix) + "\t", protocol);
                }
                ++i;
            }
        }
    }

    private void printTable(HashMap<Parameter, String> keyMap, ParameterSet parameters, PrintStream out) {
        int i = 0;
        while (i < parameters.getNumberOfParameters()) {
            Parameter par = parameters.getParameterAt(i);
            if (par.getDatatype() == DataType.PARAMETERSET && !(par instanceof AbstractSelectionParameter)) {
                ParameterSet ps = (ParameterSet)par.getValue();
                this.printTable(keyMap, ps, out);
            } else {
                out.append("<tr style=\"vertical-align:top\">\n<td><font color=\"green\">" + keyMap.get(par) + "</font></td>\n");
                String s = par.toString();
                out.append("<td>" + s.substring(0, s.lastIndexOf(")\t= ") + 1));
                if (par.getDatatype() != DataType.PARAMETERSET) {
                    out.append("</td>\n<td>" + (Object)((Object)par.getDatatype()) + "</td>\n</tr>\n");
                } else {
                    out.append("<table border=0 cellpadding=10 align=\"center\">\n");
                    ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                    int j = 0;
                    while (j < incoll.getNumberOfParameters()) {
                        ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                        if (cont.getValue().getNumberOfParameters() > 0) {
                            out.append("Parameters for selection &quot;" + cont.getName() + "&quot;:<br/>\n");
                            this.printTable(keyMap, cont.getValue(), out);
                        } else {
                            out.append("No parameters for selection &quot;" + cont.getName() + "&quot;<br/>\n");
                        }
                        ++j;
                    }
                    out.append("</table></td><td></td>\n</tr>\n");
                }
            }
            ++i;
        }
    }

    private void printToolParameters(int toolIndex, Protocol protocol, String outdir, int threads) {
        ParameterSet ps = this.toolParameters[toolIndex];
        if (this.tools.length > 1) {
            protocol.appendWarning("Parameters of tool \"" + this.tools[toolIndex].getToolName() + "\" (" + this.tools[toolIndex].getShortName() + ", version: " + this.tools[toolIndex].getToolVersion() + "):\n");
        } else {
            protocol.appendWarning("Parameters of " + this.tools[toolIndex].getToolName() + ":\n");
        }
        this.print(this.keyMap[toolIndex], ps, "", protocol);
        protocol.appendWarning("outdir - The output directory, defaults to the current working directory (.)\t= " + outdir + "\n");
        if (this.configureThreads[toolIndex]) {
            protocol.appendWarning("threads - The number of threads used for the tool, defaults to 1\t= " + threads + "\n");
        }
    }

    private static String parse(String restruct) {
        String[] lines = restruct.split("\n");
        Pattern bold = Pattern.compile("\\*\\*(.+?)\\*\\*");
        Pattern italics = Pattern.compile("\\*(.+?)\\*");
        Pattern tt = Pattern.compile("\\`\\`(.+?)\\`\\`");
        Pattern link = Pattern.compile("^\\.\\.\\s+\\_(.*?)\\s*\\:\\s*(.*)$");
        HashMap<Pattern, String> linkTargets = new HashMap<Pattern, String>();
        int i = 0;
        while (i < lines.length) {
            Matcher m = bold.matcher(lines[i]);
            lines[i] = m.replaceAll("\u00a7$1\u00a7");
            m = italics.matcher(lines[i]);
            lines[i] = m.replaceAll("'$1'");
            lines[i] = lines[i].replaceAll("\u00a7", "*");
            m = tt.matcher(lines[i]);
            lines[i] = m.replaceAll("$1");
            m = link.matcher(lines[i]);
            if (m.matches()) {
                String key = m.group(1);
                String target = m.group(2);
                linkTargets.put(Pattern.compile("\\`?(" + key + ")\\`?\\_"), target);
                lines[i] = "";
            }
            ++i;
        }
        i = 0;
        while (i < lines.length) {
            Set pats = linkTargets.keySet();
            for (Pattern pat : pats) {
                Matcher m = pat.matcher(lines[i]);
                lines[i] = m.replaceAll("$1 (" + (String)linkTargets.get(pat) + ")");
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < lines.length) {
            sb.append(lines[i2]);
            sb.append("\n");
            ++i2;
        }
        return sb.toString();
    }

    public static class SysProtocol
    implements Protocol {
        private StringBuffer log = new StringBuffer();

        @Override
        public void append(String str) {
            System.out.print(str);
            this.log.append(str);
        }

        @Override
        public void appendHeading(String heading) {
            System.out.print("* " + heading);
            this.log.append("* " + heading);
        }

        @Override
        public void appendWarning(String warning) {
            System.err.print(warning);
            this.log.append(warning);
        }

        public StringBuffer getLog() {
            return this.log;
        }

        @Override
        public void appendThrowable(Throwable th) {
            StringWriter str = new StringWriter();
            th.printStackTrace(new PrintWriter(str));
            String strstr = str.toString();
            System.err.println(strstr);
            this.log.append(strstr);
        }

        @Override
        public void appendVerbatim(String verbatim) {
            this.append(verbatim);
        }

        @Override
        public void flush() {
            System.err.flush();
            System.out.flush();
        }
    }
}

