/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment.cost;

import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class AffineCosts
implements Costs {
    private double start;
    private double elong;
    private Costs c;

    public AffineCosts(double start, Costs c) {
        this.c = c;
        this.elong = c.getGapCosts();
        if (start < 0.0 && -start > this.elong) {
            throw new IllegalArgumentException("Problem: start < 0 && -start > elong");
        }
        this.start = start;
    }

    public AffineCosts(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "AffineCosts");
        this.c = (Costs)XMLParser.extractObjectForTags(xml, "c");
        this.elong = (Double)XMLParser.extractObjectForTags(xml, "elong");
        this.start = (Double)XMLParser.extractObjectForTags(xml, "start");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.c, "c");
        XMLParser.appendObjectWithTags(xml, this.elong, "elong");
        XMLParser.appendObjectWithTags(xml, this.start, "start");
        XMLParser.addTags(xml, "AffineCosts");
        return xml;
    }

    public Costs getInternalCosts() {
        return this.c;
    }

    public double getElongateCosts() {
        return this.elong;
    }

    public double getGapCostsFor(int length) {
        return this.start + (double)length * this.elong;
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j) {
        return this.c.getCostFor(s1, s2, i, j);
    }

    @Override
    public double getGapCosts() {
        return this.c.getGapCosts();
    }
}

